/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.subsystems.fcs.CarouselClampModule;
import org.lsst.ccs.subsystems.fcs.CarouselMainModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselClampLockSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselStandalonePlutoGateway;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CarouselTest
extends CcsTestCaseTemplate {
    private static Subsystem carouselSubsystem = null;
    private static CarouselMainModule main;
    private static CarouselModule carousel;
    private static SimuCarouselController carouselController;
    private final SecureRandom randomGenerator = new SecureRandom();
    private static SimuCarouselStandalonePlutoGateway plutoGateway;
    private static FilterManager filterManager;
    private static ComponentLookup lookup;
    private static Filter filterU;
    private static Filter filterG;
    private static Filter filterR;
    private static Filter filterI;
    private static Filter filterZ;
    private static final String FILTER_U_NAME = "filterU";
    private static final String FILTER_G_NAME = "filterG";
    private static final String FILTER_R_NAME = "filterR";
    private static final String FILTER_I_NAME = "filterI";
    private static final String FILTER_Z_NAME = "filterZ";

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("************************************");
        System.out.println("TESTS OF CAROUSEL IN STANDALONE MODE");
        System.out.println("************************************");
        CCS.initializeScriptingEnvironment();
        carouselSubsystem = BootUtils.getSubsystemFromFile((String)"carousel__simulation", (String)"");
        carouselSubsystem.start();
        carouselSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        lookup = carouselSubsystem.getComponentLookup();
        main = (CarouselMainModule)lookup.getComponentByName("main");
        carousel = (CarouselModule)lookup.getComponentByName("carousel");
        carousel.updateClampsStateWithSensors();
        carouselController = (SimuCarouselController)lookup.getComponentByName("carouselController");
        Assert.assertTrue((String)"carousel hardware is ready", (boolean)carousel.isCANDevicesReady());
        plutoGateway = (SimuCarouselStandalonePlutoGateway)lookup.getComponentByName("fakePlutoGateway");
        filterManager = (FilterManager)lookup.getComponentByName("filterManager");
        filterManager.initModule();
        filterU = (Filter)filterManager.getFiltersMapByName().get(FILTER_U_NAME);
        filterG = (Filter)filterManager.getFiltersMapByName().get(FILTER_G_NAME);
        filterR = (Filter)filterManager.getFiltersMapByName().get(FILTER_R_NAME);
        filterI = (Filter)filterManager.getFiltersMapByName().get(FILTER_I_NAME);
        filterZ = (Filter)filterManager.getFiltersMapByName().get(FILTER_Z_NAME);
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("*******************************************************************");
        System.out.println("********* end of TESTS OF CAROUSEL IN STANDALONE MODE *************");
        System.out.println("*******************************************************************");
        carouselSubsystem.shutdown();
        carouselSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        CCS.shutdownScriptingEnvironment();
    }

    @Before
    public void setUp() throws FcsHardwareException {
        System.out.println("COUCOU - choses \u00e0 faire avant chaque test. Exemple: test retour \u00e9tat initial");
        System.out.println("Go back to initial conditions");
        carouselSubsystem.clearAllAlerts();
        carousel.rotateToAbsoluteAngle(0);
        Assert.assertEquals((String)"carousel position is 0", (long)0L, (long)carousel.getPosition());
        Assert.assertEquals((String)"socket in STANDBY is socket1", (Object)"socket1", (Object)carousel.getSocketAtStandby().getName());
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsLOCKED();
        carousel.updateClampsStateWithSensors();
        Assert.assertTrue((String)"carousel is holding a filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        Assert.assertTrue((String)"Socket at STANDBY is LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testClamps() throws FcsHardwareException {
        System.out.println("*** test of clamps state ***");
        for (int i = 1; i < 5; ++i) {
            String clampXminusName = "clampXminus" + i;
            System.out.println("Checking ClampState for " + clampXminusName);
            CarouselClampModule clampXminus = (CarouselClampModule)lookup.getComponentByName(clampXminusName);
            Assert.assertTrue((String)(clampXminusName + " contains a filter."), (boolean)clampXminus.isFilterEngaged());
            Assert.assertTrue((String)(clampXminusName + " is LOCKED."), (boolean)clampXminus.isLocked());
            String clampXplusName = "clampXplus" + i;
            System.out.println("Checking ClampState for " + clampXplusName);
            CarouselClampModule clampXplus = (CarouselClampModule)lookup.getComponentByName(clampXplusName);
            Assert.assertTrue((String)(clampXplusName + " contains a filter."), (boolean)clampXplus.isFilterEngaged());
            Assert.assertTrue((String)(clampXplusName + " is LOCKED."), (boolean)clampXplus.isLocked());
        }
        System.out.println("Test clamps state is in error state");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsUNLOCKED();
        try {
            carousel.updateClampsStateWithSensors();
            Assert.fail((String)"Clamps state are in error. Should raise an Exception: ClampsOrLatchesDisagreeException");
        }
        catch (FcsHardwareException ex) {
            System.out.println("Clamps state are in error. Exception raised: " + (Object)((Object)ex));
        }
        System.out.println("Test unLockClamps when a filter is not clamped at standby");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsUNLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsUNLOCKED();
        carousel.updateClampsStateWithSensors();
        Assert.assertFalse((String)"Clamps at STANDBY are not ClampedOnFilter.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
        try {
            carousel.unlockClamps();
            Assert.fail((String)"Clamps at STANDBY are not ClampedOnFilter. unlockClamps should raise an Exception.");
        }
        catch (FailedCommandException | RejectedCommandException ex) {
            System.out.println("Clamps at STANDBY are not ClampedOnFilter. Raised exception=" + ex);
        }
        System.out.println("Go back to initial conditions");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsLOCKED();
        carousel.updateClampsStateWithSensors();
        Assert.assertTrue((String)"Clamps at STANDBY are LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testClampSensors() {
        System.out.println("*** testClampSensors ***");
        try {
            carousel.unlockClamps();
            Assert.fail((String)"Filter is not held by fakeAutochanger. unlockClamps should raise an Exception.");
        }
        catch (FailedCommandException | RejectedCommandException ex) {
            System.out.println("Filter is not held by fakeAutochanger. Raised exception=" + ex);
        }
        plutoGateway.simulateAutochangerIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"carousel is still holding filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        Assert.assertTrue((String)"filter is also held by autochanger", (boolean)carousel.isAutochangerHoldingFilter());
        carousel.unlockClamps();
        Assert.assertEquals((String)"socket at STANDBY is ", (Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER, (Object)carousel.getSocketAtStandby().getClampsState());
        for (int i = 2; i < 5; ++i) {
            String socketName = "socket" + i;
            Assert.assertEquals((String)"sockets else than socket1 are CLAMPEDONFILTER", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)carousel.getSocketByName(socketName).getClampsState());
        }
        System.out.println("Go back to initial conditions");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsLOCKED();
        carousel.updateClampsStateWithSensors();
        Assert.assertTrue((String)"Clamps at STANDBY are LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testIsHoldingFilter() throws FcsHardwareException {
        System.out.println("*** test of isHoldingFilterAtStandby ***");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsUNLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsUNLOCKED();
        carousel.updateClampsStateWithSensors();
        Assert.assertFalse((String)"carousel is NOT holding a filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        System.out.println("Go back to initial conditions");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsLOCKED();
        carousel.updateClampsStateWithSensors();
        Assert.assertTrue((String)"Clamps at STANDBY are LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testCheckConditionForRotation() throws FcsHardwareException {
        System.out.println("*** test of checkConditionsForRotation");
        try {
            carousel.checkConditionsForRotation();
        }
        catch (FcsHardwareException | RejectedCommandException ex) {
            Assert.fail((String)("in initial conditions, rotation is allowed. No exception should be raised:" + ex));
        }
        System.out.println("Simulate clamps at STANDBY are UNLOCKED");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsUNLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsUNLOCKED();
        carousel.updateClampsStateWithSensors();
        String msg = "Clamps are UNLOCKED but filter is still there.";
        Assert.assertTrue((String)msg, (boolean)carousel.getSocketAtStandby().isUnclampedOnFilter());
        try {
            carousel.checkConditionsForRotation();
            Assert.fail((String)(msg + " checkConditionsForRotation should raise an Exception."));
        }
        catch (FcsHardwareException | RejectedCommandException ex) {
            System.out.println("Carousel can't rotate because " + msg + ex);
        }
        System.out.println("Go back to initial conditions. simulate clamps at STANDBY are LOCKED");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsLOCKED();
        carousel.updateClampsStateWithSensors();
    }

    @Test
    public void testRotateToRelativeAngle() throws FcsHardwareException {
        System.out.println("*** test of rotationToRelativeAngle");
        Assert.assertEquals((String)"socket at STANDBY is socket1", (Object)carousel.getSocketAtStandby().getName(), (Object)"socket1");
        Assert.assertEquals((String)"carousel position is 0", (long)0L, (long)carousel.getPosition());
        System.out.println("rotate to position 20");
        carousel.rotateToRelativeAngle(20);
        Assert.assertEquals((String)"carousel position is 20", (long)20L, (long)carousel.getPosition());
        Assert.assertFalse((String)"carousel is NOT holding a filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        System.out.println("rotate back to position 0");
        carousel.rotateToRelativeAngle(-20);
        Assert.assertEquals((String)("carousel position should be again but is:" + carousel.getPosition()), (long)0L, (long)carousel.getPosition());
        Assert.assertTrue((String)"carousel is holding a filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        System.out.println("rotate to position -52");
        carousel.rotateToRelativeAngle(-52);
        Assert.assertEquals((String)("carousel position should be 308 but is:" + carousel.getPosition()), (long)308L, (long)carousel.getPosition());
        System.out.println("rotate back to position 0");
        carousel.rotateToRelativeAngle(52);
        Assert.assertEquals((String)("carousel position should be 0 back again but is:" + carousel.getPosition()), (long)0L, (long)carousel.getPosition());
        System.out.println("rotation to position 340");
        carousel.rotateToRelativeAngle(340);
        Assert.assertEquals((String)("carousel position should be 340 but is:" + carousel.getPosition()), (long)340L, (long)carousel.getPosition());
        System.out.println("rotate back to position 0");
        carousel.rotateToRelativeAngle(20);
        Assert.assertEquals((String)("carousel position should be 0 back again but is:" + carousel.getPosition()), (long)0L, (long)carousel.getPosition());
        System.out.println("rotate to position 190");
        carousel.rotateToRelativeAngle(190);
        Assert.assertEquals((String)("carousel position should be 190 back again but is:" + carousel.getPosition()), (long)190L, (long)carousel.getPosition());
        System.out.println("rotate to position 230");
        carousel.rotateToRelativeAngle(230);
        Assert.assertEquals((String)("carousel position should be 60 but is:" + carousel.getPosition()), (long)60L, (long)carousel.getPosition());
        System.out.println("rotate to position -300");
        carousel.rotateToRelativeAngle(-300);
        Assert.assertEquals((String)("carousel position should be 120 but is:" + carousel.getPosition()), (long)120L, (long)carousel.getPosition());
        System.out.println("rotate back to position 0");
        carousel.rotateToRelativeAngle(-120);
        Assert.assertEquals((String)("carousel position should be 0 back again but is:" + carousel.getPosition()), (long)0L, (long)carousel.getPosition());
    }

    @Test
    public void testRotateToRelativeAngleWithRandomGenerator() throws FcsHardwareException {
        int endPosition;
        int randomAngle;
        int i;
        System.out.println("*** test of rotateToRelativeAngle with randomGenerator");
        int initialPosition = carousel.getPosition();
        for (i = 0; i < 5; ++i) {
            randomAngle = this.randomGenerator.nextInt(360);
            System.out.println("randomAngle=" + randomAngle);
            carousel.rotateToRelativeAngle(randomAngle);
            endPosition = FcsUtils.addAngle((int)initialPosition, (int)randomAngle);
            Assert.assertEquals((String)("carousel position should be " + endPosition + " but is:" + carousel.getPosition()), (long)endPosition, (long)carousel.getPosition());
            initialPosition = endPosition;
        }
        for (i = 0; i < 5; ++i) {
            randomAngle = -this.randomGenerator.nextInt(360);
            carousel.rotateToRelativeAngle(randomAngle);
            System.out.println("randomAngle=" + randomAngle);
            endPosition = FcsUtils.addAngle((int)initialPosition, (int)randomAngle);
            Assert.assertEquals((String)("carousel position should be " + endPosition + " but is:" + carousel.getPosition()), (long)endPosition, (long)carousel.getPosition());
            initialPosition = endPosition;
        }
    }

    @Test
    public void testRotateToAbsoluteAngle() throws FcsHardwareException {
        System.out.println("*** test of rotationToAbsoluteAngle");
        System.out.println("testRotateToAbsoluteAngle: rotate to position -33");
        try {
            carousel.rotateToAbsoluteAngle(-33);
            Assert.fail((String)"carousel.rotateToAbsoluteAngle(-33) should raise IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            System.out.println("carousel.rotateToAbsoluteAngle(-33) raise Exception:" + ex);
        }
        try {
            carousel.rotateToAbsoluteAngle(390);
            Assert.fail((String)"carousel.rotateToAbsoluteAngle(390) should raise IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            System.out.println("carousel.rotateToAbsoluteAngle(390) raise Exception:" + ex);
        }
        System.out.println("rotate to absolute position 90");
        carousel.rotateToAbsoluteAngle(90);
        Assert.assertEquals((String)"carousel position is 90", (long)90L, (long)carousel.getPosition());
        System.out.println("rotate to absolute position 179");
        carousel.rotateToAbsoluteAngle(179);
        Assert.assertEquals((String)"carousel position is 179", (long)179L, (long)carousel.getPosition());
        System.out.println("rotate to absolute position 180");
        carousel.rotateToAbsoluteAngle(180);
        Assert.assertEquals((String)"carousel position is 180", (long)180L, (long)carousel.getPosition());
        System.out.println("rotate to absolute position 180");
        carousel.rotateToAbsoluteAngle(216);
        Assert.assertEquals((String)"carousel position is 216", (long)216L, (long)carousel.getPosition());
        System.out.println("Go back to initial conditions");
        carousel.rotateToAbsoluteAngle(0);
        Assert.assertEquals((String)"carousel position is 0", (long)0L, (long)carousel.getPosition());
    }

    @Test
    public void testRotateSocketToStandby() throws FcsHardwareException {
        System.out.println("rotateSocketToStandby");
        Assert.assertEquals((String)"STANDBY position for socket2 is 288", (long)288L, (long)carousel.getSocketByName("socket2").getStandbyPosition());
        carousel.rotateSocketToStandby("socket2");
        Assert.assertEquals((String)"carousel position is now 288", (long)288L, (long)carousel.getPosition());
        Assert.assertEquals((String)"socket2 is now at STANDBY", (Object)"socket2", (Object)carousel.getSocketAtStandby().getName());
        carousel.rotateSocketToStandby("socket4");
        Assert.assertEquals((String)"socket4 is now at STANDBY", (Object)"socket4", (Object)carousel.getSocketAtStandby().getName());
        carousel.rotateSocketToStandby("socket3");
        Assert.assertEquals((String)"socket3 is now at STANDBY", (Object)"socket3", (Object)carousel.getSocketAtStandby().getName());
        carousel.rotateSocketToStandby("socket5");
        Assert.assertEquals((String)"socket5 is now at STANDBY", (Object)"socket5", (Object)carousel.getSocketAtStandby().getName());
        System.out.println("Go back to initial conditions");
        carousel.rotateSocketToStandby("socket1");
        Assert.assertEquals((String)"socket1 is now at STANDBY", (Object)"socket1", (Object)carousel.getSocketAtStandby().getName());
    }

    @Test
    public void testRotateSocketToStandbyWithRandomGenerator() throws FcsHardwareException {
        System.out.println("rotateSocketToStandby with randomGenerator");
        for (int i = 0; i < 10; ++i) {
            int socketNumber = this.randomGenerator.nextInt(5);
            String socketName = "socket" + socketNumber;
            System.out.println("rotateSocketToStandby(" + socketName + ")");
            if (socketNumber == 0) {
                try {
                    carousel.rotateSocketToStandby(socketName);
                    Assert.fail((String)"socket0 is an invalid socket name. Should raise an exception of type IllegalArgumentException");
                }
                catch (IllegalArgumentException ex) {
                    System.out.println("socket0 is an invalid socket name. Exception raised:" + ex);
                }
                continue;
            }
            carousel.rotateSocketToStandby(socketName);
            Assert.assertEquals((String)(socketName + " is now at STANDBY"), (Object)socketName, (Object)carousel.getSocketAtStandby().getName());
        }
    }

    @Test
    public void testRotateEmptySocketAtStandby() {
        System.out.println("rotateEmptySocketAtStandby");
        try {
            carousel.rotateEmptySocketAtStandby();
        }
        catch (FailedCommandException | FcsHardwareException | RejectedCommandException ex) {
            Assert.fail((String)("rotateEmptySocketAtStandby should do nothing but not raised an Exception:" + ex));
        }
    }

    @Test
    public void testCarouselController() throws FcsHardwareException {
        System.out.println("test of SimuCarouselController");
        Assert.assertEquals((String)"carouselController position is 0", (long)0L, (long)carouselController.readPosition());
        System.out.println("testCarouselController: rotate to position 10");
        carouselController.simulateWriteTargetPosition(10, carousel.getPosition());
        Assert.assertEquals((String)"carouselController position is 10", (long)10L, (long)carouselController.readPosition());
        carousel.updatePosition();
        Assert.assertEquals((String)"carousel position is 10", (long)10L, (long)carousel.getPosition());
        System.out.println("testCarouselController: rotate to position 150");
        carouselController.simulateWriteTargetPosition(150, carousel.getPosition());
        Assert.assertEquals((String)"carouselController position is 150", (long)150L, (long)carouselController.readPosition());
        carousel.updatePosition();
        Assert.assertEquals((String)"carousel position is 150", (long)150L, (long)carousel.getPosition());
        System.out.println("testCarouselController: rotate to position 288");
        carouselController.simulateWriteTargetPosition(288, carousel.getPosition());
        Assert.assertEquals((String)"carouselController position is 288", (long)288L, (long)carouselController.readPosition());
        carousel.updatePosition();
        Assert.assertEquals((String)"carousel position is 288", (long)288L, (long)carousel.getPosition());
        Assert.assertEquals((String)"socket2 is at STANDBY position", (Object)"socket2", (Object)carousel.getSocketAtStandby().getName());
        System.out.println("testCarouselController: rotate to position 216");
        carouselController.simulateWriteTargetPosition(216, carousel.getPosition());
        Assert.assertEquals((String)"carouselController position is 216", (long)216L, (long)carouselController.readPosition());
        carousel.updatePosition();
        Assert.assertEquals((String)"carousel position is 216", (long)216L, (long)carousel.getPosition());
        Assert.assertEquals((String)"socket3 is at STANDBY position", (Object)"socket3", (Object)carousel.getSocketAtStandby().getName());
        System.out.println("testCarouselController: rotate to position 144");
        carouselController.simulateWriteTargetPosition(144, carousel.getPosition());
        Assert.assertEquals((String)"carouselController position is 144", (long)144L, (long)carouselController.readPosition());
        carousel.updatePosition();
        Assert.assertEquals((String)"carousel position is 144", (long)144L, (long)carousel.getPosition());
        Assert.assertEquals((String)"socket4 is at STANDBY position", (Object)"socket4", (Object)carousel.getSocketAtStandby().getName());
        System.out.println("testCarouselController: rotate to position 72");
        carouselController.simulateWriteTargetPosition(72, carousel.getPosition());
        Assert.assertEquals((String)"carouselController position is 72", (long)72L, (long)carouselController.readPosition());
        carousel.updatePosition();
        Assert.assertEquals((String)"carousel position is 72", (long)72L, (long)carousel.getPosition());
        Assert.assertEquals((String)"socket5 is at STANDBY position", (Object)"socket5", (Object)carousel.getSocketAtStandby().getName());
        System.out.println("testCarouselController: rotate back to position 0");
        carouselController.simulateWriteTargetPosition(0, carousel.getPosition());
        carousel.updatePosition();
        Assert.assertEquals((String)"carousel position should be 0", (long)0L, (long)carousel.getPosition());
        Assert.assertEquals((String)"socket1 is at STANDBY position", (Object)"socket1", (Object)carousel.getSocketAtStandby().getName());
    }

    @Test
    public void testCheckFiltersLocation() {
        System.out.println("checkFiltersLocation");
        main.checkFiltersLocation();
        Assert.assertEquals((String)"filterU is on socket1", (Object)carousel.getSocketByName("socket1").getFilter(), (Object)filterU);
        Assert.assertEquals((String)"filterG is on socket2", (Object)carousel.getSocketByName("socket2").getFilter(), (Object)filterG);
        Assert.assertEquals((String)"filterR is on socket3", (Object)carousel.getSocketByName("socket3").getFilter(), (Object)filterR);
        Assert.assertEquals((String)"filterI is on socket4", (Object)carousel.getSocketByName("socket4").getFilter(), (Object)filterI);
        Assert.assertEquals((String)"filterZ is on socket5", (Object)carousel.getSocketByName("socket5").getFilter(), (Object)filterZ);
    }

    @Test
    public void testSaveFilterLocation() {
        System.out.println("saveFilterLocation");
        try {
            main.saveFilterLocation();
            ConfigurationState cs = (ConfigurationState)carouselSubsystem.getState(ConfigurationState.class);
            Assert.assertFalse((String)("ConfigurationState is no more dirty : " + cs), (boolean)cs.equals((Object)ConfigurationState.DIRTY));
        }
        catch (Exception ex) {
            Assert.fail((String)("saveFilterLocation should not raise Exception: " + ex));
        }
    }

    @Test
    public void launchScript() throws Exception {
        System.out.println("************************************************");
        System.out.println("*** Launch Python SCRIPT carouselTest.py ***");
        System.out.println("************************************************");
        JythonScriptExecutorUtils.executeScript((String)"org/lsst/ccs/subsystems/fcs/scripts/carouselTest.py", (String[])new String[0]);
    }
}

