/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutoChangerTwoTrucksModule;
import org.lsst.ccs.subsystems.fcs.AutochangerLatchModule;
import org.lsst.ccs.subsystems.fcs.AutochangerMainModule;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClampModule;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerStandalonePlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;

public class AutochangerOnlineClampsTest
extends CcsTestCaseTemplate {
    private static Subsystem autochangerSubsystem = null;
    private static AutochangerMainModule main;
    private static AutoChangerModule autochanger;
    private static AutoChangerTwoTrucksModule trucks;
    private static AutochangerTwoLatches latches;
    private static AutochangerLatchModule latchXminus;
    private static AutochangerLatchModule latchXplus;
    private static AutochangerThreeOnlineClamps onlineClamps;
    private static AutochangerOnlineClampModule onlineClampXminus;
    private static AutochangerOnlineClampModule onlineClampXplus;
    private static AutochangerOnlineClampModule onlineClampYminus;
    private static SimuAutochangerStandalonePlutoGateway plutoGateway;
    private static SimuEPOSControllerModule onlineClampXminusController;
    private static CanOpenProxy tcpProxy;
    private static AutochangerOnlineClampModule[] clampsList;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("*************************************************************");
        System.out.println("    TESTS OF AUTOCHANGER ONLINE CLAMPS IN STANDALONE MODE    ");
        System.out.println("*************************************************************");
        autochangerSubsystem = BootUtils.getSubsystemFromFile((String)"autochanger__simulation", (String)"");
        autochangerSubsystem.start();
        autochangerSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = autochangerSubsystem.getComponentLookup();
        main = (AutochangerMainModule)lookup.getComponentByName("main");
        autochanger = (AutoChangerModule)lookup.getComponentByName("autochanger");
        autochanger.updateStateWithSensors();
        trucks = (AutoChangerTwoTrucksModule)lookup.getComponentByName("autochangerTrucks");
        plutoGateway = (SimuAutochangerStandalonePlutoGateway)lookup.getComponentByName("acSensorsGateway");
        plutoGateway.simulateAutochangerTrucksAreAtHandoff();
        trucks.updatePosition();
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoff());
        latches = (AutochangerTwoLatches)lookup.getComponentByName("latches");
        latchXminus = (AutochangerLatchModule)lookup.getComponentByName("latchXminus");
        latchXplus = (AutochangerLatchModule)lookup.getComponentByName("latchXplus");
        onlineClamps = (AutochangerThreeOnlineClamps)lookup.getComponentByName("onlineClamps");
        onlineClampXminus = (AutochangerOnlineClampModule)lookup.getComponentByName("onlineClampXminus");
        onlineClampXplus = (AutochangerOnlineClampModule)lookup.getComponentByName("onlineClampXplus");
        onlineClampYminus = (AutochangerOnlineClampModule)lookup.getComponentByName("onlineClampYminus");
        onlineClampXminusController = (SimuEPOSControllerModule)lookup.getComponentByName(onlineClampXminus.getControllerName());
        clampsList = new AutochangerOnlineClampModule[]{onlineClampXminus, onlineClampXplus, onlineClampYminus};
        Assert.assertEquals((String)"onlineClampXminusController.getName()=onlineClampXminus.getControllerName()", (Object)onlineClampXminusController.getName(), (Object)onlineClampXminus.getControllerName());
        Assert.assertTrue((String)"After initialization phase, simulated hardware should be ready.", (boolean)main.isCANDevicesReady());
        tcpProxy = (CanOpenProxy)lookup.getComponentByName("tcpProxy");
    }

    @Before
    public void setUp() throws Exception {
        System.out.println("****************************************************");
        System.out.println("***********  BEFORE EACH TEST    *******************");
        System.out.println("****************************************************");
        System.out.println("***go back to initial conditions: autochanger empty at HANDOFF");
        System.out.println("simulateAutochangerTrucksIsAtHandoff");
        onlineClampXminus.configureController();
        onlineClampXplus.configureController();
        onlineClampYminus.configureController();
        plutoGateway.simulateAutochangerTrucksAreAtHandoff();
        trucks.updatePosition();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoff());
        System.out.println("simulateAutochangerIsEmpty");
        plutoGateway.simulateAutochangerIsEmpty();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"latchXminus should be empty", (boolean)latchXminus.isEmpty());
        Assert.assertTrue((String)"latchXplus should be empty", (boolean)latchXplus.isEmpty());
        Assert.assertTrue((String)"Autochanger latches should be empty", (boolean)latches.isEmpty());
        Assert.assertTrue((String)"Autochanger should be empty", (boolean)autochanger.isEmpty());
        System.out.println("simulateAutochangerAreUnlocked");
        plutoGateway.simulateAutochangerLatchesAreUnlocked();
        System.out.println("simulateAutochangerOnlineClampsAreUnlocked");
        plutoGateway.simulateAutochangerOnlineClampsAreOpened();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Latches are UNLOCKED", (boolean)latches.isUnlocked());
        Assert.assertTrue((String)"ONLINE clamps are OPENED", (boolean)onlineClamps.isOpened());
        autochangerSubsystem.clearAllAlerts();
    }

    @Test
    public void test_close_open_onlineClamp() throws HardwareException {
        System.out.println("*****************************************");
        System.out.println("*** test_close_open_onlineClamp       ***");
        System.out.println("*****************************************");
        Assert.assertTrue((String)"Online clamps are OPENED", (boolean)onlineClamps.isOpened());
        Assert.assertTrue((String)"onlineClampXminusController is initialized", (boolean)onlineClampXminusController.isInitialized());
        Assert.assertTrue((String)"onlineClampXminus hardware is ready", (boolean)onlineClampXminus.isCANDevicesReady());
        Assert.assertTrue((String)"onlineClampXminus is initialized", (boolean)onlineClampXminus.isInitialized());
        Assert.assertTrue((String)"ONLINE clamps hardware is ready", (boolean)onlineClamps.isCANDevicesReady());
        Assert.assertTrue((String)"ONLINE clamps is initialized", (boolean)onlineClamps.isInitialized());
        System.out.println("*** test method close of class AutochangerOnlineClampModule - test with onlineClampXminus");
        System.out.println("*** test close onlineClampXminus  - should fail because autochanger trucks are at HANDOFF");
        try {
            onlineClampXminus.close();
            Assert.fail((String)"autochanger is at HANDOFF - can't close clamps. Should raise a RejectedCommandException.");
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
        plutoGateway.simulateAutochangerTrucksAreOnline();
        trucks.updatePosition();
        System.out.println("*** test close onlineClampXminus again - should fail because autochanger is empty");
        try {
            onlineClampXminus.close();
            Assert.fail((String)"onlineClampXminus can't be CLOSED if there is no filter in autochanger trucks. Should raise a RejectedCommandException.");
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerLatchesAreLocked();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"Autochanger is not empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"Latches are LOCKED", (boolean)latches.isLocked());
        System.out.println("*** test close the 3 onlineClamps - should success");
        for (AutochangerOnlineClampModule clamp : clampsList) {
            clamp.close();
            Assert.assertTrue((String)(clamp.getName() + " is CLOSED"), (boolean)clamp.isClosed());
        }
        System.out.println("*** test close onlineClampXminus again - should do nothing but log.");
        onlineClampXminus.close();
        Assert.assertTrue((String)"onlineClampXminus is CLOSED", (boolean)onlineClampXminus.isClosed());
        System.out.println("*** test open onlineClamps");
        for (AutochangerOnlineClampModule clamp : clampsList) {
            clamp.open();
            Assert.assertTrue((String)(clamp.getName() + " is OPENED"), (boolean)clamp.isOpened());
        }
    }

    @Test
    public void test_lock_unlock_onlineClamp() {
        System.out.println("*****************************************");
        System.out.println("*** test_lock_unlock_onlineClamp");
        System.out.println("*****************************************");
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerLatchesAreLocked();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"Autochanger is not empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"Latches are LOCKED", (boolean)latches.isLocked());
        AutochangerOnlineClampModule clampToTest = onlineClampYminus;
        try {
            clampToTest.lock();
            Assert.fail((String)(clampToTest.getName() + " can't be locked because it's opened. It has to be closed before."));
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        try {
            clampToTest.unlock();
            Assert.fail((String)(clampToTest.getName() + " can't be unlocked because it's opened."));
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        try {
            clampToTest.close();
            Assert.fail((String)"clampToTest.close() should fail because autochanger is not ONLINE.");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        plutoGateway.simulateAutochangerTrucksAreOnline();
        autochanger.updateStateWithSensors();
        for (AutochangerOnlineClampModule clamp : clampsList) {
            clamp.close();
            Assert.assertTrue((String)(clamp.getName() + " is CLOSED"), (boolean)clamp.isClosed());
        }
        for (AutochangerOnlineClampModule clamp : clampsList) {
            clamp.lock();
            Assert.assertTrue((String)(clamp.getName() + " is LOCKED"), (boolean)clamp.isLocked());
        }
        for (AutochangerOnlineClampModule clamp : clampsList) {
            clamp.lock();
            Assert.assertTrue((String)(clamp.getName() + " is LOCKED"), (boolean)clamp.isLocked());
        }
        clampToTest = onlineClampXminus;
        try {
            clampToTest.close();
            Assert.fail((String)(clampToTest.getName() + " can't be closed because it's locked. It has to be unlocked."));
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        clampToTest = onlineClampXplus;
        try {
            clampToTest.open();
            Assert.fail((String)(clampToTest.getName() + " can't be opened because it's locked. It has to be unlocked first."));
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        for (AutochangerOnlineClampModule clamp : clampsList) {
            clamp.unlock();
            Assert.assertTrue((String)(clamp.getName() + " is CLOSED"), (boolean)clamp.isClosed());
            Assert.assertEquals((String)(clamp.getName() + " value of current sent to controller is currentToClose"), (long)clamp.getSentCurrent(), (long)clamp.getCurrentToClose());
        }
        System.out.println("*** open again onlineClamps");
        for (AutochangerOnlineClampModule clamp : clampsList) {
            clamp.open();
            Assert.assertTrue((String)(clamp.getName() + " is OPENED"), (boolean)clamp.isOpened());
        }
    }

    @Test
    public void testProcessUpdate() throws Exception {
        System.out.println("*****************************************");
        System.out.println("*** test processUpdate                ***");
        System.out.println("*****************************************");
        Assert.assertFalse((String)"onlineClampXminus controller is NOT in fault", (boolean)onlineClampXminus.isControllerInFault());
        String msg = "emcy," + onlineClampXminus.getController().getNodeID() + ",4210,04";
        System.out.println("message=" + msg);
        System.out.println("*** Simulate an emergency message coming from tcpProxy for onlineClampXminus");
        tcpProxy.processEmcyMessage(msg);
        Assert.assertTrue((String)"Subsystem is in ALARM State.", (boolean)autochangerSubsystem.isInState((Enum)AlertState.ALARM));
        System.out.println("onlineClampXminus nodeID=" + onlineClampXminus.getController().getNodeID());
        int sleepTime = 500;
        Thread.sleep(sleepTime);
        Assert.assertTrue((String)"onlineClampXminus controller is in fault", (boolean)onlineClampXminus.isControllerInFault());
        Assert.assertFalse((String)"onlineClampXplus controller is NOT in fault", (boolean)onlineClampXplus.isControllerInFault());
        System.out.println("*** Simulate an emergency message coming from tcpProxy for onlineClampXplus");
        tcpProxy.processEmcyMessage("emcy," + onlineClampXplus.getController().getNodeID() + ",4210,04");
        Thread.sleep(sleepTime);
        Assert.assertTrue((String)"onlineClampXplus controller is in fault", (boolean)onlineClampXplus.isControllerInFault());
        System.out.println("*** faultReset onlineClampXminusController");
        onlineClampXminus.getController().faultReset();
        Thread.sleep(sleepTime);
        Assert.assertFalse((String)"onlineClampXminus controller is NOT in fault", (boolean)onlineClampXminus.isControllerInFault());
        Assert.assertTrue((String)"onlineClampXplus controller is in fault", (boolean)onlineClampXplus.isControllerInFault());
        System.out.println("*** faultreset onlineClampXplusController");
        onlineClampXplus.getController().faultReset();
        Thread.sleep(sleepTime);
        System.out.println("onlineClampXplus is no more in fault");
        Assert.assertFalse((String)"onlineClampXplus controller is NOT in fault", (boolean)onlineClampXplus.isControllerInFault());
    }

    @Test
    public void testExecuteCurrentRamp() throws Exception {
        System.out.println("*****************************************");
        System.out.println("***   test executeCurrentRamp         ***");
        System.out.println("*****************************************");
        int period = 50;
        int initialValue = 0;
        int finalValue = 2000;
        System.out.println("initial value =" + initialValue + " final value=" + finalValue);
        onlineClampXminus.executeCurrentRamp(initialValue, finalValue, (long)period);
        int readCurrent = onlineClampXminus.getController().readCurrent();
        Assert.assertEquals((String)("onlineClampXminus readCurrent should be = " + finalValue), (long)finalValue, (long)readCurrent);
        initialValue = 0;
        finalValue = -2000;
        System.out.println("initial value =" + initialValue + " final value=" + finalValue);
        onlineClampXminus.executeCurrentRamp(initialValue, finalValue, (long)period);
        readCurrent = onlineClampXminus.getController().readCurrent();
        Assert.assertEquals((String)("onlineClampXminus readCurrent should be = " + finalValue), (long)finalValue, (long)readCurrent);
        initialValue = -2000;
        finalValue = 0;
        System.out.println("initial value =" + initialValue + " final value=" + finalValue);
        onlineClampXminus.executeCurrentRamp(initialValue, finalValue, (long)period);
        readCurrent = onlineClampXminus.getController().readCurrent();
        Assert.assertEquals((String)("onlineClampXminus readCurrent should be = " + finalValue), (long)finalValue, (long)readCurrent);
        initialValue = 2000;
        finalValue = 0;
        System.out.println("initial value =" + initialValue + " final value=" + finalValue);
        onlineClampXminus.executeCurrentRamp(initialValue, finalValue, (long)period);
        readCurrent = onlineClampXminus.getController().readCurrent();
        Assert.assertEquals((String)("onlineClampXminus readCurrent should be = " + finalValue), (long)finalValue, (long)readCurrent);
        initialValue = 300;
        finalValue = 3000;
        System.out.println("initial value =" + initialValue + " final value=" + finalValue);
        onlineClampXminus.executeCurrentRamp(initialValue, finalValue, (long)period);
        readCurrent = onlineClampXminus.getController().readCurrent();
        Assert.assertEquals((String)("onlineClampXminus readCurrent should be = " + finalValue), (long)finalValue, (long)readCurrent);
    }

    @Test
    public void testcloseAndUnlockClamps() {
        System.out.println("*****************************************");
        System.out.println("***   test closeAndLockClamps         ***");
        System.out.println("*****************************************");
        try {
            onlineClamps.closeAndLockClamps();
            Assert.fail((String)"onlineClamps.closeAndLockClamps() should fail because autochanger is not at ONLINE.");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        plutoGateway.simulateAutochangerTrucksAreOnline();
        autochanger.updateStateWithSensors();
        try {
            onlineClamps.closeAndLockClamps();
            Assert.fail((String)"onlineClamps.closeAndLockClamps() should fail because autochanger is empty.");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        plutoGateway.simulateFilterIsOnAutochanger();
        autochanger.updateStateWithSensors();
        onlineClamps.closeAndLockClamps();
        System.out.println("clamps STATUS=" + onlineClamps.getLockStatus());
        Assert.assertTrue((String)"clamps are LOCKED", (boolean)onlineClamps.isLocked());
        System.out.println("***   end of test lockClamps         ***");
        System.out.println("*****************************************");
        System.out.println("***   test unlockAndOpenClamps        ***");
        System.out.println("*****************************************");
        onlineClamps.unlockAndOpenClamps();
        Assert.assertTrue((String)"clamps are OPENED", (boolean)onlineClamps.isOpened());
        System.out.println("***   end of test unlockClamps         ***");
    }

    @AfterClass
    public static void after() throws Exception {
        autochangerSubsystem.shutdown();
        autochangerSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
    }
}

