/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class DigitalSensorTest
extends CcsTestCaseTemplate {
    private static final int inputNumero1 = 3;
    private static final int inputNumero2 = 5;
    private static final int byteNumero2 = 1;
    private static DigitalSensor sensor1;
    private static DigitalSensor sensor2;
    private static final String ZERO = "0";
    private static final String UN = "1";
    private static final String DEUX = "2";
    private static final String TROIS = "3";
    private static final String FF = "FF";
    private static final String FFFF = "FFFF";
    private static final String GATEWAY = "gateway";

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF DigitalSensor");
        System.out.println("***************************************");
        Subsystem s = BootUtils.getSubsystemFromFile((String)"testDigitalSensor");
        sensor1 = (DigitalSensor)s.getComponentLookup().getComponentByName("sensor1");
        sensor2 = (DigitalSensor)s.getComponentLookup().getComponentByName("sensor2");
    }

    @AfterClass
    public static void tearDownClass() {
        System.out.println("********* end of DigitalSensor tests *************");
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetByteNumero() {
        System.out.println("getByteNumero");
        int expResult = 0;
        int result = sensor1.getByteNumero();
        Assert.assertEquals((String)"byteNumero of sensor1 is 0", (long)expResult, (long)result);
        expResult = 1;
        result = sensor2.getByteNumero();
        Assert.assertEquals((String)"byteNumero of sensor2 is 1", (long)expResult, (long)result);
    }

    @Test
    public void testGetInputNumero() {
        System.out.println("getInputNumero");
        int expResult = 3;
        int result = sensor1.getInputNumero();
        Assert.assertEquals((String)"inputNumero of sensor1 is 3", (long)expResult, (long)result);
        expResult = 5;
        result = sensor2.getInputNumero();
        Assert.assertEquals((String)"inputNumero of sensor2 is 5", (long)expResult, (long)result);
    }

    @Test
    public void testUpdateValue_String() {
        DigitalSensor sensor;
        int i;
        System.out.println("##########################################");
        System.out.println("   updateValue of class Digital sensor");
        System.out.println("##########################################");
        System.out.println("updateValue");
        DigitalSensor sensor5 = new DigitalSensor(GATEWAY, 5);
        try {
            sensor5.updateValue(FFFF);
            Assert.fail((String)"FFFF trop grand devrait lancer une exception");
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        sensor1.updateValue(FF);
        Assert.assertTrue((String)"new digital value of sensor1 is now true", (boolean)sensor1.isOn());
        sensor1.updateValue(ZERO);
        Assert.assertFalse((String)"new digital value of sensor1 is now false", (boolean)sensor1.isOn());
        String bin = "00001000";
        sensor1.updateValue(FcsUtils.binaryToHex((String)bin));
        Assert.assertTrue((String)"new digital value of sensor1 is now true", (boolean)sensor1.isOn());
        sensor2.updateValue(FF);
        Assert.assertTrue((String)"new digital value of sensor2 is now 1", (boolean)sensor2.isOn());
        sensor2.updateValue(ZERO);
        Assert.assertFalse((String)"new digital value of sensor2 is now false", (boolean)sensor2.isOn());
        for (i = 0; i < 8; ++i) {
            sensor = new DigitalSensor(GATEWAY, i);
            sensor.updateValue(FF);
            Assert.assertTrue((String)"when GATEWAY returns FF, sensor is ON", (boolean)sensor.isOn());
        }
        for (i = 0; i < 8; ++i) {
            sensor = new DigitalSensor(GATEWAY, i);
            sensor.updateValue(ZERO);
            Assert.assertFalse((String)"when GATEWAY returns ZERO, sensor is OFF", (boolean)sensor.isOn());
        }
        for (i = 0; i < 8; ++i) {
            sensor = new DigitalSensor(GATEWAY, i);
            sensor.updateValue(UN);
            if (i > 0) {
                Assert.assertFalse((String)("when GATEWAY returns 1, sensor " + sensor + " is OFF"), (boolean)sensor.isOn());
                continue;
            }
            Assert.assertTrue((String)("when GATEWAY returns 1, sensor " + sensor + " is ON"), (boolean)sensor.isOn());
        }
        for (i = 0; i < 8; ++i) {
            sensor = new DigitalSensor(GATEWAY, i);
            sensor.updateValue(DEUX);
            if (i == 1) {
                Assert.assertTrue((String)("when GATEWAY returns 2, sensor " + sensor + " is ON"), (boolean)sensor.isOn());
                continue;
            }
            Assert.assertFalse((String)("when GATEWAY returns 2, sensor " + sensor + " is OFF"), (boolean)sensor.isOn());
        }
        for (i = 0; i < 8; ++i) {
            sensor = new DigitalSensor(GATEWAY, i);
            sensor.updateValue(TROIS);
            if (i > 1) {
                Assert.assertFalse((String)("when GATEWAY returns 3, sensor " + sensor + " is OFF"), (boolean)sensor.isOn());
                continue;
            }
            Assert.assertTrue((String)("when GATEWAY returns 3, sensor " + sensor + " is ON"), (boolean)sensor.isOn());
        }
        for (i = 0; i < 8; ++i) {
            sensor = new DigitalSensor(GATEWAY, i);
            sensor.updateValue("23");
            if (i == 0 || i == 1 || i == 5) {
                Assert.assertTrue((String)("when GATEWAY returns 23, sensor " + sensor + " is ON"), (boolean)sensor.isOn());
                continue;
            }
            Assert.assertFalse((String)("when GATEWAY returns 23, sensor " + sensor + " is OFF"), (boolean)sensor.isOn());
        }
        for (i = 0; i < 8; ++i) {
            sensor = new DigitalSensor(GATEWAY, i);
            sensor.updateValue("c5");
            if (i == 0 || i == 2 || i == 6 || i == 7) {
                Assert.assertTrue((String)("when GATEWAY returns c5, sensor " + sensor + " is ON"), (boolean)sensor.isOn());
                continue;
            }
            Assert.assertFalse((String)("when GATEWAY returns c5, sensor " + sensor + " is OFF"), (boolean)sensor.isOn());
        }
    }

    @Test
    public void testUpdateValue_StringArr() {
        System.out.println("updateValue");
        String[] hexaValues = new String[]{FF, FF, FF};
        sensor1.updateValue(hexaValues);
        Assert.assertTrue((String)"new digital value of sensor1 is now true", (boolean)sensor1.isOn());
        sensor2.updateValue(hexaValues);
        Assert.assertTrue((String)"new digital value of sensor2 is now true", (boolean)sensor2.isOn());
        String[] hexaValues2 = new String[]{FF, ZERO, FF};
        sensor2.updateValue(hexaValues2);
        Assert.assertFalse((String)"new digital value of sensor2 is now false", (boolean)sensor2.isOn());
        String bin = "00100000";
        String[] hexaValues4 = new String[]{ZERO, FcsUtils.binaryToHex((String)bin)};
        sensor2.updateValue(hexaValues4);
        Assert.assertTrue((String)"new digital value of sensor2 is now true", (boolean)sensor2.isOn());
        String[] hexaValues3 = new String[]{"00", FF, FF};
        sensor1.updateValue(hexaValues3);
        Assert.assertFalse((String)"new digital value of sensor1 is now false", (boolean)sensor1.isOn());
    }

    @Test
    public void testToString() {
        System.out.println("toString");
        String expResult = "sensor1/DIO module=dio1/Input numero=3/byteNumero=0/value=false";
        String result = sensor1.toString();
        Assert.assertEquals((String)("printed sensor1 is " + expResult), (Object)expResult, (Object)result);
        expResult = "sensor2/DIO module=dio2/Input numero=5/byteNumero=1/value=false";
        result = sensor2.toString();
        Assert.assertEquals((String)("printed sensor2 is " + expResult), (Object)expResult, (Object)result);
    }
}

