/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenADC;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSensor14bits;

public class CanOpenSensor14bitsTest
extends CcsTestCaseTemplate {
    private static Subsystem sensorSubsystem = null;
    private static CanOpenSensor14bits sensor14bits;
    private static CanOpenADC adc;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF CanOpenSensor14bits                 ");
        sensorSubsystem = BootUtils.getSubsystemFromFile((String)"canOpenSensor14bitsTest");
        sensorSubsystem.start();
        ComponentLookup lookup = sensorSubsystem.getComponentLookup();
        sensor14bits = (CanOpenSensor14bits)lookup.getComponentByName("sensor14bits");
        adc = (CanOpenADC)lookup.getComponentByName("ai814");
    }

    @AfterClass
    public static void after() throws Exception {
        sensorSubsystem.shutdown();
    }

    @Test
    public void testInitModule() {
        System.out.println("initModule");
        Assert.assertSame((String)("sensor14bits' adc is " + adc), (Object)CanOpenSensor14bitsTest.sensor14bits.adc, (Object)adc);
    }

    @Test
    public void testUpdateValue() {
        System.out.println("updateValue");
        PDOStorage pdoStorage = new PDOStorage();
        String hexaValue = "4F";
        String pdoLine = "v" + CanOpenSensor14bitsTest.adc.nodeID + "_" + CanOpenSensor14bitsTest.sensor14bits.numOfAnalogInput + "=" + hexaValue;
        pdoStorage.updatePDOs(pdoLine);
        int expResult = Integer.parseInt(hexaValue, 16);
        int result = sensor14bits.updateValue(pdoStorage);
        Assert.assertEquals((String)"new value of the sensor is now in hexa 4F", (long)expResult, (long)result);
        hexaValue = "0";
        pdoLine = "v" + CanOpenSensor14bitsTest.adc.nodeID + "_" + CanOpenSensor14bitsTest.sensor14bits.numOfAnalogInput + "=" + hexaValue;
        pdoStorage.updatePDOs(pdoLine);
        expResult = Integer.parseInt(hexaValue, 16);
        result = sensor14bits.updateValue(pdoStorage);
        Assert.assertEquals((String)"new value of the sensor is now in hexa 0", (long)expResult, (long)result);
        hexaValue = "FFFF";
        pdoLine = "v" + CanOpenSensor14bitsTest.adc.nodeID + "_" + CanOpenSensor14bitsTest.sensor14bits.numOfAnalogInput + "=" + hexaValue;
        pdoStorage.updatePDOs(pdoLine);
        expResult = Integer.parseInt(hexaValue, 16);
        result = sensor14bits.updateValue(pdoStorage);
        Assert.assertEquals((String)"new value of the sensor is now in hexa FFFF", (long)expResult, (long)result);
    }

    @Test
    public void testToString() {
        System.out.println("toString");
        String hexaValue = "4F";
        String pdoLine = "v" + CanOpenSensor14bitsTest.adc.nodeID + "_" + CanOpenSensor14bitsTest.sensor14bits.numOfAnalogInput + "=" + hexaValue;
        PDOStorage pdoStorage = new PDOStorage();
        pdoStorage.updatePDOs(pdoLine);
        int expResultInt = Integer.parseInt(hexaValue, 16);
        int resultInt = sensor14bits.updateValue(pdoStorage);
        Assert.assertEquals((String)"new value of the sensor is now in hexa 4F", (long)expResultInt, (long)resultInt);
        String expResult = "sensor14bits/returned value=79/adcName=ai814/inputNumero=5";
        String result = sensor14bits.toString();
        Assert.assertEquals((String)("printed sensor is " + expResult), (Object)expResult, (Object)result);
    }
}

