/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class CanOpenProxyTest
extends CcsTestCaseTemplate {
    private static Subsystem subs;
    private static CanOpenProxy tcpProxy;
    private static CanOpenDevice device1;
    private static CanOpenDevice device2;
    private static CanOpenDevice device3;
    private static final String deviceName1 = "device1";
    private static final String deviceName2 = "device2";
    private static final String deviceName3 = "device3";
    private static final String nodeID1 = "24A";
    private static final String nodeID2 = "02F4A";
    private static final String nodeID3 = "3";
    private static final String nodeID4 = "3a";
    private static final String serial1 = "8XFFV678";
    private static final String serial2 = "99xfr56A";
    private static final String serial3 = "033fzbgt4";
    private static final String infoMessage1 = "info,24A,type, vendor, productCode, revision,8XFFV678";
    private static final String infoMessage2 = "info,02F4A,type, vendor, productCode, revision,99xfr56A";
    private static final String infoMessage3 = "info,3,type, vendor, productCode, revision,033fzbgt4";

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("        TESTS OF CanOpenProxy");
        System.out.println("***************************************");
        subs = BootUtils.getSubsystemFromFile((String)"testCanOpenProxy");
        ComponentLookup lookup = subs.getComponentLookup();
        tcpProxy = (CanOpenProxy)lookup.getComponentByName("main");
        device1 = (CanOpenDevice)lookup.getComponentByName(deviceName1);
        device2 = (CanOpenDevice)lookup.getComponentByName(deviceName2);
        device3 = (CanOpenDevice)lookup.getComponentByName(deviceName3);
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("********* end of CanOpenProxy tests *************");
    }

    @Before
    public void setUp() {
        tcpProxy.initialize();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSetHardwareList() {
        System.out.println("#setHardwareList");
        Assert.assertEquals((String)"There is 3 devices in hardwareList.", (long)3L, (long)CanOpenProxyTest.tcpProxy.hardwareMapByNodeID.size());
    }

    @Test
    public void testGetMyClientName() {
        System.out.println("#getMyClientName");
        String expResult = "testFCS";
        String result = tcpProxy.getMyClientName();
        Assert.assertEquals((String)"Client name = testFCS", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetPdoStorage() {
        System.out.println("#getPdoStorage");
        String expResult = "PDO STORAGE:(SIZE=0){}";
        String result = tcpProxy.getPdoStorage().toString();
        Assert.assertEquals((String)"PDO Storage should be empty.", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetNodeName() {
        System.out.println("#getNodeName");
        String expResult = deviceName1;
        String result = tcpProxy.getNodeName(nodeID1);
        Assert.assertEquals((String)"Name of device1 isdevice1", (Object)expResult, (Object)result);
        expResult = deviceName2;
        result = tcpProxy.getNodeName(nodeID2);
        Assert.assertEquals((String)"Name of device2 isdevice2", (Object)expResult, (Object)result);
        String fakeNodeID = "fakeNodeID";
        result = tcpProxy.getNodeName(fakeNodeID);
        System.out.println("Result=" + result);
        expResult = "UnknownDevice" + fakeNodeID;
        Assert.assertEquals((String)(fakeNodeID + "is unbooted."), (Object)expResult, (Object)result);
    }

    @Test
    public void testListNodes() {
        System.out.println("#listNodes");
        String expResult = "main: no booted CANopen devices.";
        String result = tcpProxy.listBootedNodes();
        Assert.assertEquals((String)"There should be none booted nodes.", (Object)expResult, (Object)result);
        tcpProxy.processBootMessage(nodeID1);
        expResult = "main booted CANopen devices:{24A=Node ID= 24A (in decimal= 586)/ type=0/ vendor=0/ product code=0/ revision=0/ serial number=0}";
        result = tcpProxy.listBootedNodes();
        Assert.assertEquals((String)"There should be a booted node now.", (Object)expResult, (Object)result);
    }

    @Test
    public void testIsHardwareReady() {
        System.out.println("#isHardwareReady");
        boolean expResult = false;
        boolean result = tcpProxy.isCANDevicesReady();
        Assert.assertEquals((String)"isHardwareReady returns false because the tcp server is not started", (Object)expResult, (Object)result);
    }

    @Test
    public void testProcessBootMessage() {
        System.out.println("#processBootMessage");
        boolean result = tcpProxy.isBooted(nodeID1);
        Assert.assertFalse((String)"24A is not yet booted", (boolean)result);
        tcpProxy.processBootMessage(nodeID1);
        boolean result2 = tcpProxy.isBooted(nodeID1);
        Assert.assertTrue((String)"24A is booted now", (boolean)result2);
    }

    @Test
    public void testProcessEmcyMessage() {
        System.out.println("#processEmcyMessage");
        String message1 = "emcy,24A,00,00";
        String message2 = "emcy,001a,00,00";
        try {
            tcpProxy.processEmcyMessage(message1);
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof NullPointerException));
        }
        try {
            tcpProxy.processEmcyMessage(message2);
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof NullPointerException));
        }
    }

    @Test
    public void testProcessInfoMessage() {
        System.out.println("#processInfoMessage");
        tcpProxy.processBootMessage(nodeID3);
        boolean result = tcpProxy.isBooted(nodeID3);
        Assert.assertTrue((String)"3 is booted now.", (boolean)result);
        tcpProxy.processBootMessage(nodeID3);
        tcpProxy.processInfoMessage(infoMessage3, nodeID3);
        CanOpenNode bootedNode = tcpProxy.getBootedNodeBySerialNumber(serial3);
        String expResult = bootedNode.getSerialNB();
        Assert.assertEquals((String)"Serial number of node3 should now be 033fzbgt4", (Object)expResult, (Object)serial3);
    }

    @Test
    public void testProcessUnknownCommand() {
        System.out.println("#processUnknownCommand");
        String message = "Unknown,COUCOU";
        try {
            tcpProxy.processUnknownCommand(message);
            System.out.println("AlertState=" + subs.getState());
            Assert.assertTrue((String)"s should be in AlertState.ALARM", (boolean)subs.isInState((Enum)AlertState.ALARM));
        }
        catch (NullPointerException ex) {
            System.out.println(ex);
            System.out.println("When an unknown message is received from the CANbus, an ALARM of type WARNING is raised.A NullPointerException is raised because getSubsystem() is null.");
        }
    }

    @Test
    public void testProcessResponseToReadSDO() {
        System.out.println("#processResponseToReadSDO");
        String response = "rsdo,3a,00,ff";
        String nodeID = nodeID4;
        String request = "rsdo,3a,1003,01";
        String expResult = "ff";
        try {
            String result = tcpProxy.processResponseToReadSDO(response, nodeID, request);
            Assert.assertEquals((String)("response to" + request + " is " + expResult), (Object)expResult, (Object)result);
        }
        catch (Exception ex) {
            System.out.println("Should not raised an Exception:" + ex);
        }
        response = "rsdo,3a,06010000,ff";
        nodeID = nodeID4;
        request = "rsdo,3a,1003,01";
        expResult = "ff";
        try {
            tcpProxy.processResponseToReadSDO(response, nodeID, request);
            Assert.fail((String)("response to" + request + " is not" + expResult));
        }
        catch (NullPointerException | SDORequestException ex) {
            System.out.println("response to" + request + " is not" + expResult + " should raised an Exception:" + ex);
        }
        catch (ShortResponseToSDORequestException ex) {
            System.out.println("Should raised an Exception of type SDORequestException:" + (Object)((Object)ex));
        }
    }

    @Test
    public void testCheckBootedCanOpenNodes() {
        System.out.println("#checkCanOpenNodes");
        try {
            tcpProxy.checkBootedCanOpenNodes();
            Assert.fail((String)"An Exception of type HardwareException should have been raised.");
        }
        catch (HardwareException ex) {
            System.out.println((Object)ex);
        }
        tcpProxy.processBootMessage(nodeID1);
        try {
            tcpProxy.checkBootedCanOpenNodes();
            Assert.fail((String)"An Exception of type HardwareException should have been raised");
        }
        catch (HardwareException ex) {
            System.out.println((Object)ex);
        }
    }

    @Test
    public void testCheckNumberOfBootedNodes() {
        System.out.println("#checkNumberOfBootedNodes");
        try {
            tcpProxy.checkNumberOfBootedNodes();
            Assert.fail((String)"No hardware is booted :an Exception of type HardwareException should have been raised.");
        }
        catch (NullPointerException | HardwareException ex) {
            System.out.println(ex);
        }
        tcpProxy.processBootMessage(nodeID1);
        tcpProxy.processBootMessage(nodeID2);
        tcpProxy.processBootMessage(nodeID3);
        try {
            tcpProxy.checkNumberOfBootedNodes();
        }
        catch (HardwareException ex) {
            Assert.fail((String)("3 nodes are booted. No hardware exception should have been raised." + (Object)((Object)ex)));
        }
    }

    @Test
    public void testCheckHardwareID() {
        System.out.println("#checkHardwareID");
        tcpProxy.processBootMessage(nodeID1);
        tcpProxy.checkHardwareID((PieceOfHardware)device1);
        Assert.assertTrue((String)"s should be in AlertState.ALARM", (boolean)subs.isInState((Enum)AlertState.ALARM));
        subs.clearAllAlerts();
        tcpProxy.processInfoMessage(infoMessage1, nodeID1);
        try {
            tcpProxy.checkHardwareID((PieceOfHardware)device1);
        }
        catch (NullPointerException ex) {
            System.out.println(ex);
            System.out.println("The node is booted and serial number is OK. A NullPointerException is raised because we want to publish data but getSubsystem() is null.");
            Assert.assertTrue((String)"24A is booted", (boolean)tcpProxy.isBooted(nodeID1));
        }
        tcpProxy.processBootMessage(nodeID2);
        String message = "info,02F4A,type, vendor, productCode, revision,XXXX000YYY";
        tcpProxy.processInfoMessage(message, nodeID2);
        tcpProxy.checkHardwareID((PieceOfHardware)device2);
        Assert.assertTrue((String)"nodeID2 is booted but with a wrong serial number so subsystem should be in AlertState.ALARM", (boolean)subs.isInState((Enum)AlertState.ALARM));
        subs.clearAllAlerts();
        tcpProxy.checkHardwareID((PieceOfHardware)device3);
        Assert.assertTrue((String)"nodeID3 is not booted so subsystem should be in AlertState.ALARM", (boolean)subs.isInState((Enum)AlertState.ALARM));
        subs.clearAllAlerts();
        tcpProxy.processBootMessage(nodeID4);
        message = "info,3a,type, vendor, productCode, revision,033fzbgt4";
        tcpProxy.processInfoMessage(message, nodeID4);
        tcpProxy.checkHardwareID((PieceOfHardware)device3);
        Assert.assertTrue((String)"deviceName3 is booted but with another CANopen ID", (boolean)subs.isInState((Enum)AlertState.ALARM));
    }

    @Test
    public void testGetBootedNodeBySerialNumber() {
        System.out.println("getBootedNodeBySerialNumber");
        Object expResult = null;
        CanOpenNode result = tcpProxy.getBootedNodeBySerialNumber(serial1);
        Assert.assertEquals((String)"No CANopen node is booted yet.", expResult, (Object)result);
        tcpProxy.processBootMessage(nodeID2);
        tcpProxy.processInfoMessage(infoMessage2, nodeID2);
        CanOpenNode result2 = tcpProxy.getBootedNodeBySerialNumber(serial2);
        Assert.assertEquals((String)"A CANopen node is booted now and has serial number:99xfr56A", (Object)serial2, (Object)result2.getSerialNB());
    }

    @Test
    public void testPrintBootedNodeBySerialNumber() {
        System.out.println("printBootedNodeBySerialNumber");
        try {
            String sn = null;
            tcpProxy.printBootedNodeBySerialNumber(sn);
            Assert.fail((String)"An Exception of type IllegalArgumentException should have been raised.");
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        try {
            tcpProxy.processBootMessage(nodeID1);
            tcpProxy.processInfoMessage(infoMessage1, nodeID1);
            String expResult = "Node ID= 24A (in decimal= 586)/ type=type/ vendor= vendor/ product code= productCode/ revision= revision/ serial number=8XFFV678";
            String result = tcpProxy.printBootedNodeBySerialNumber(serial1);
            Assert.assertEquals((String)"Booted node is 24A", (Object)expResult, (Object)result);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)"Serial number:8XFFV678 is not null.");
        }
    }

    @Test
    public void testToString() {
        System.out.println("toString");
        String expResult = "main/port=53000/clientName=testFCS/hardwareBootTimeout=10000";
        String result = tcpProxy.toString();
        Assert.assertEquals((String)"toString method should returns:main/port=53000/clientName=testFCS/hardwareBootTimeout=10000", (Object)expResult, (Object)result);
    }
}

