/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;

public class CanOpenEPOSTest
extends CcsTestCaseTemplate {
    private static CanOpenEPOS controller;
    private static final String name = "controller1";
    private static final Map<String, Integer> paramsForCurrent;
    private static final Map<String, Integer> paramsForProfilePosition;
    private static final Map<String, Integer> paramsForHoming;

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF CanOpenEPOS");
        paramsForCurrent.put(EPOSEnumerations.Parameter.MotorType.toString(), 11);
        paramsForCurrent.put(EPOSEnumerations.Parameter.ContinuousCurrentLimit.toString(), 2360);
        paramsForCurrent.put(EPOSEnumerations.Parameter.OutputCurrentLimit.toString(), 4720);
        paramsForProfilePosition.put(EPOSEnumerations.Parameter.MotionProfileType.toString(), 0);
        paramsForHoming.put(EPOSEnumerations.Parameter.HomeOffset.toString(), 0);
        Subsystem s = BootUtils.getSubsystemFromFile((String)"testCanOpenEPOS");
        controller = (CanOpenEPOS)s.getComponentLookup().getComponentByName(name);
    }

    @AfterClass
    public static void tearDownClass() {
        System.out.println("********* end of CanOpenEPOS tests *************");
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testIsEnabledToPublish() {
        System.out.println("isEnabledToPublish");
        CanOpenEPOS instance = controller;
        boolean expResult = false;
        boolean result = instance.isEnabledToPublish();
        Assert.assertEquals((String)"Controller is not enabled.", (Object)expResult, (Object)result);
    }

    @Test
    public void testIsTurnedOff() {
        System.out.println("isTurnedOff");
        CanOpenEPOS instance = controller;
        boolean expResult = false;
        boolean result = instance.isTurnedOff();
        Assert.assertEquals((String)"After initialization, the controller is off.", (Object)expResult, (Object)result);
    }

    @Test
    public void testCreateStatusDataPublishedByEPOSController() {
        System.out.println("getStatusData");
        String expResult = "controller1/isBooted=false/isInitialized=false/inError=false/Error Register=NO ERROR/Error History=";
        StatusDataPublishedByEPOSController status = controller.createStatusDataPublishedByEPOSController();
        Assert.assertTrue((String)status.toString(), (boolean)status.toString().startsWith(expResult));
        Assert.assertFalse((boolean)status.isEnabled());
        Assert.assertEquals((String)"Controller name is :controller", (Object)controller.getName(), (Object)status.getName());
    }

    static {
        paramsForCurrent = new HashMap<String, Integer>();
        paramsForProfilePosition = new HashMap<String, Integer>();
        paramsForHoming = new HashMap<String, Integer>();
    }
}

