/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class PieceOfHardwareTest {
    private static String nodeID = "3a";
    private static String serial = "756DDF";
    private static CanOpenDevice device;
    private static String deviceName;

    @BeforeClass
    public static void setUpClass() throws Exception {
        Subsystem s = BootUtils.getSubsystemFromFile((String)"testCanOpenDevice");
        device = (CanOpenDevice)s.getComponentLookup().getComponentByName(deviceName);
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetSerialNB() {
        System.out.println("getSerialNB");
        String expResult = serial;
        String result = device.getSerialNB();
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testGetNodeID() {
        System.out.println("getNodeID");
        String expResult = nodeID;
        String result = device.getNodeID();
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testIsBooted() {
        System.out.println("isBooted");
        boolean expResult = false;
        boolean result = device.isBooted();
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testIsInitialized() {
        System.out.println("isInitialized");
        boolean expResult = false;
        boolean result = device.isInitialized();
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testInitializeAndCheckHardware() {
        System.out.println("initializeAndCheckHardware");
        try {
            device.initializeAndCheckHardware();
            Assert.fail((String)"Device is not booted :an Exception of type FcsHardwareException should have been raised.");
        }
        catch (FcsHardwareException ex) {
            System.out.println((Object)ex);
        }
    }

    @Test
    public void testCheckBooted() {
        System.out.println("checkBooted");
        try {
            device.checkBooted();
            Assert.fail((String)"Device is not booted :an Exception of type FcsHardwareException should have been raised.");
        }
        catch (FcsHardwareException ex) {
            System.out.println((Object)ex);
        }
    }

    @Test
    public void testCheckInitialized() {
        System.out.println("checkInitialized");
        try {
            device.checkInitialized();
            Assert.fail((String)"Device is not initialized :an Exception of type FcsHardwareException should have been raised.");
        }
        catch (FcsHardwareException ex) {
            System.out.println((Object)ex);
        }
    }

    @Test
    public void testCreateStatusDataPublishedByHardware() {
        System.out.println("createStatusDataPublishedByHardware");
        StatusDataPublishedByHardware status = device.createStatusDataPublishedByHardware();
        Assert.assertFalse((boolean)status.isBooted());
        Assert.assertFalse((boolean)status.isInitialized());
    }

    @Test
    public void testPrintState() {
        System.out.println("printState");
        String expResult = "name=device1,nodeID=3a,serial number=756DDF is NOT BOOTED and NOT INITIALIZED";
        Assert.assertEquals((Object)expResult, (Object)device.printState());
    }

    static {
        deviceName = "device1";
    }
}

