/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.security.SecureRandom;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FilterIdentificator;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGatewayWithFilterID;

public class FilterIdentificatorTest
extends CcsTestCaseTemplate {
    private static Subsystem filterIdentificatorSubsystem = null;
    private static FilterIdentificator filterIdentificator;
    private static SimuPlutoGatewayWithFilterID plutoGateway;
    private final SecureRandom randomGenerator = new SecureRandom();

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("******************************************");
        System.out.println("***    TESTS OF FilterIdentificator   ****");
        System.out.println("******************************************");
        filterIdentificatorSubsystem = BootUtils.getSubsystemFromFile((String)"filterIdentificator__simulation", (String)"");
        filterIdentificatorSubsystem.start();
        ComponentLookup lookup = filterIdentificatorSubsystem.getComponentLookup();
        filterIdentificator = (FilterIdentificator)lookup.getComponentByName("filterIdentificator");
        filterIdentificator.initModule();
        plutoGateway = (SimuPlutoGatewayWithFilterID)lookup.getComponentByName("acSensorsGateway");
    }

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        System.out.println("*** back to initial state ***");
        plutoGateway.initModule();
        filterIdentificator.updateSensorsValues();
    }

    @After
    public void tearDown() {
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("****************************************************");
        System.out.println("*** shutdown of filterIdentificator subsystem    ***");
        System.out.println("****************************************************");
        filterIdentificatorSubsystem.shutdown();
    }

    @Test
    public void testReadFilterIdentifier() {
        System.out.println("readFilterIdentifier");
        int expResult = 0;
        int result = filterIdentificator.readFilterIdentifier();
        Assert.assertEquals((String)"In the begining filterID=0", (long)expResult, (long)result);
        plutoGateway.replaceHexaValues((DigitalSensor)filterIdentificator.getFilterIDSensors().get(0), true);
        Assert.assertEquals((String)"ID0=1 so filterID=1", (long)1L, (long)filterIdentificator.readFilterIdentifier());
        plutoGateway.replaceHexaValues((DigitalSensor)filterIdentificator.getFilterIDSensors().get(1), true);
        Assert.assertEquals((String)"ID0=1 and ID1=1 so filterID=3", (long)3L, (long)filterIdentificator.readFilterIdentifier());
        plutoGateway.replaceHexaValues((DigitalSensor)filterIdentificator.getFilterIDSensors().get(2), true);
        Assert.assertEquals((String)"ID0=1 and ID1=1 and ID2=1 so filterID=7", (long)7L, (long)filterIdentificator.readFilterIdentifier());
        plutoGateway.replaceHexaValues((DigitalSensor)filterIdentificator.getFilterIDSensors().get(0), false);
        Assert.assertEquals((String)"ID0=0 and ID1=1 and ID2=1 so filterID=6", (long)6L, (long)filterIdentificator.readFilterIdentifier());
    }

    @Test
    public void testUpdateSensorsValues() {
        System.out.println("updateSensorsValues");
        plutoGateway.replaceHexaValues((DigitalSensor)filterIdentificator.getFilterIDSensors().get(0), true);
        filterIdentificator.updateSensorsValues();
        Assert.assertEquals((String)"Now filterIdentificator .toString() is 000001", (Object)"000001", (Object)filterIdentificator.toString());
    }

    @Test
    public void testSimulateFilterID() {
        System.out.println("simulateFilterID");
        plutoGateway.simulateFilterID(5);
        Assert.assertEquals((String)"Now filterID is 5", (long)5L, (long)filterIdentificator.readFilterIdentifier());
        plutoGateway.simulateFilterID(12);
        Assert.assertEquals((String)"Now filterID is 12", (long)12L, (long)filterIdentificator.readFilterIdentifier());
        try {
            plutoGateway.simulateFilterID(0);
            Assert.fail((String)"argument of simulateFilterID can't be 0");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        try {
            plutoGateway.simulateFilterID(64);
            Assert.fail((String)"argument of simulateFilterID must be < 64");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        int randomFilterID = this.randomGenerator.nextInt(63);
        if (randomFilterID > 0) {
            System.out.println("simulateFilterID with randomFilterID=" + randomFilterID);
            plutoGateway.simulateFilterID(randomFilterID);
            Assert.assertEquals((String)("Now filterID is " + randomFilterID), (long)randomFilterID, (long)filterIdentificator.readFilterIdentifier());
        }
    }

    @Test
    public void testToString() {
        System.out.println("toString");
        String expResult = "000000";
        String result = filterIdentificator.toString();
        Assert.assertEquals((String)"After INITIALIZATION filterIdentificator.toString() is 000000", (Object)expResult, (Object)result);
    }
}

