// see documentation on single-filter-test on : https://confluence.slac.stanford.edu/display/LSSTCAM/Single+Filter+Test
package sftSimulation

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.singlefiltertest.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.description.groovy.CCSBuilder



//Carousel Can Open Devices (CAN-CBX-AI814)
def adcName = "ai814"

//Carousel clamps controllers name
def clampXminusControllerName = "clampXminusController" //controller to unlock clamp on the side Xminus
def clampXplusControllerName =  "clampXplusController" //controller to unlock clamp on the side Xplus

//Autochanger Can Open Devices
def dacName = "ao412"  // to control the latches actuator
def railsSensorsDIOName = "dio8n1"  // to control the trucks and monitor the rails sensors
def filterSensorsDIOName = "dio8n2" // to monitor the filter sensors

CCSBuilder builder = ["single-filter-test"]

builder.
    main ( SftMainModule, bridge:ref("tcpProxy"), dummyFilter:ref("dummyFilter")) {

    tcpProxy (SimuCanOpenProxy,
        portNumber:54321,fieldBusTimeout:2000,clientName:"TestBench",hardwareBootTimeout:2500) {
        
        ai814 (SimuCanOpenADC, 
            nodeID:"21",serialNB:"c7c40234",transmissionType:"1")

        ao412 (CanOpenDevice,
            nodeID:"22",serialNB:"c7c60307")            
            
        dio8n1 ( SimuCompactIOModule , 
            //name: railsSensorsDIOName) ,
            nodeID: "23", serialNB: "c7ca0914",initialHexaValue:"50")
                                    
        dio8n2 ( SimuCompactIOModule , 
            //name: filterSensorsDIOName) ,
            nodeID: "24",serialNB: "c7ca0913",initialHexaValue:"44")
        
        clampXminusController (SimuCarouselClampController,    
            //name: clampXminusControllerName),
            nodeID:"1a",serialNB:"79003317",
            paramsForCurrent:[MotorType:11, PositionSensorType:3,PolePairNumber:8,
                ContinuousCurrentLimit:2360,OutputCurrentLimit:4720,
                ThermalTimeConstantWinding:160,
                MaxSpeedInCurrentMode:25],
            paramsForProfilePosition:[MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])  

        clampXplusController (SimuCarouselClampController,
            //name: clampXplusControllerName),
            nodeID:"1b",
            serialNB:"79003313",
            paramsForCurrent:[MotorType:11, PositionSensorType:3,PolePairNumber:8,
                ContinuousCurrentLimit:2360,OutputCurrentLimit:4720,
                ThermalTimeConstantWinding:160,
                MaxSpeedInCurrentMode:25],
            paramsForProfilePosition:[MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])
    }

    dummyFilter (Filter, filterID:10,weight:44,socketName:"socket1") 
    
    //----------------------------
    // BEGIN Carousel description
    carousel (SftCarouselModule) {//begin description of carousel's children
        socket1 ( CarouselSocket,
            clampXminus:ref("clampXminus"),
            clampXplus:ref("clampXplus"),
            position:0,standbyPosition:0)
        {   
            //-------------------------
            // BEGIN clampXminus description
            clampXminus (CarouselClampModule,
                
                filterPresenceSensor:ref("filterPresenceXminus"),
                lockSensor:ref("lockSensorXminus"),
                thermometer:ref("thermometerXminus"))
            {
                filterPresenceXminus (SimuCarouselClampFilterPresenceSensor,
                    adcName:adcName,numOfAnalogInput:5)
                
                lockSensorXminus (SimuCarouselClampLockSensor,
                    adcName:adcName,numOfAnalogInput:7)
                
                thermometerXminus (SimuThermometer)

            }
            //-------------------------
            // END clampXminus description
            
            //-------------------------
            // BEGIN clampXplus description
            clampXplus (CarouselClampModule,
                filterPresenceSensor:ref("filterPresenceXplus"),
                lockSensor:ref("lockSensorXplus"),
                thermometer:ref("thermometerXplus"))
            {
                filterPresenceXplus (SimuCarouselClampFilterPresenceSensor,
                    adcName:adcName,numOfAnalogInput:1)

                lockSensorXplus (SimuCarouselClampLockSensor,
                    adcName:adcName,numOfAnalogInput:3)

                thermometerXplus (SimuThermometer)

            }
            //-------------------------
            // END clampXplus description
            
        } // END carouselSocket description
        
    }//end description of carousel's children
    //END Carousel description
    // ------------------------
    
    // ------------------------
    //BEGIN AUTO CHANGER
    autochanger (SftAutoChangerModule,
        
        latchXminus:ref("latchXminus"),
        latchXplus:ref("latchXplus"),
        truckXminus:ref("truckXminus"),
        truckXplus:ref("truckXplus"),
        railsSensorsDIOName:railsSensorsDIOName,
        filterSensorsDIOName:filterSensorsDIOName,
        sftTrucksMotor:ref("sftTrucksMotor"))

            {//begin description of autochanger's children

                // ------------------------
                //BEGIN  SFT TRUCKS MOTOR (AUTOCHANGER)
                sftTrucksMotor(SimuTruckMotorModule)


                //END  SFT TRUCKS MOTOR
                // ------------------------
                // ------------------------
                //BEGIN  latchMinux    (AUTOCHANGER)
                latchXminus (SftFilterLatchModule,
                            filterSensorsDIOName:filterSensorsDIOName,
                            lockSensor:ref("lockSensorLatchXminus"),
                            unlockSensor:ref("unlockSensorLatchXminus"),
                            filterPresenceSensor:ref("filterPresenceSensorLatchXminus"),
                            latchActuator:ref("latchActuatorXminus"))
                    {
                        lockSensorLatchXminus ( DigitalSensor ,
                            dioName:filterSensorsDIOName,inputNumero:1)

                        unlockSensorLatchXminus ( DigitalSensor ,
                            dioName:filterSensorsDIOName,inputNumero:2)

                        filterPresenceSensorLatchXminus ( DigitalSensor ,
                                dioName:filterSensorsDIOName,inputNumero:0)

                        latchActuatorXminus (SimuLatchActuatorModule,
                                currentLimitInVolt:0.150,
                                speedVoltageInVolt:4,
                                speedVoltageMaxValue:10,
                                speedVoltageMinValue:-10,
                                filterSensorsDIOName:filterSensorsDIOName)
                    }
                    // ------------------------
                    //END  latchXminus    (AUTOCHANGER)

                    // ------------------------
                    //BEGIN  latchXplus    (AUTOCHANGER)
                    latchXplus (SftFilterLatchModule,
                        filterSensorsDIOName:filterSensorsDIOName,
                        lockSensor:ref("lockSensorLatchXplus"),
                        unlockSensor:ref("unlockSensorLatchXplus"),
                        filterPresenceSensor:ref("filterPresenceSensorLatchXplus"),
                        latchActuator:ref("latchActuatorXplus"))
                    {
                        lockSensorLatchXplus ( DigitalSensor ,
                            dioName:filterSensorsDIOName,inputNumero:5)
                        unlockSensorLatchXplus ( DigitalSensor ,
                            dioName:filterSensorsDIOName,inputNumero:6)
                        filterPresenceSensorLatchXplus ( DigitalSensor ,
                            dioName:filterSensorsDIOName,inputNumero:4)
                        latchActuatorXplus (SimuLatchActuatorModule,
                            currentLimitInVolt: 0.150,
                            speedVoltageInVolt: 4,
                            speedVoltageMinValue: -10,
                            speedVoltageMaxValue: 10,
                            filterSensorsDIOName:filterSensorsDIOName)
                    }
                            //END  LATCH   (AUTOCHANGER)
                            // ------------------------

                    // ------------------------
                    //BEGIN  TRUCK   (AUTOCHANGER)
                    truckXminus (  SimuTruckModule ,
                        railSensorStandback:ref("railSensorStandbackXminus"),
                        railSensorStandby:ref("railSensorStandbyXminus"))
                    {
                        railSensorStandbackXminus (  DigitalSensor ,
                            dioName:railsSensorsDIOName,
                            inputNumero: 4)
                        railSensorStandbyXminus (  DigitalSensor ,
                            dioName:railsSensorsDIOName,inputNumero: 5)
                    }
                    truckXplus (  SimuTruckModule ,
                        railSensorStandback:ref("railSensorStandbackXplus"),
                        railSensorStandby:ref("railSensorStandbyXplus"))
                    {
                        railSensorStandbackXplus (  DigitalSensor ,
                            dioName:railsSensorsDIOName,inputNumero: 6)

                        railSensorStandbyXplus (  DigitalSensor ,
                            dioName:railsSensorsDIOName,inputNumero: 7)
                    }
                    //END  TRUCK   (AUTOCHANGER)
                    // ------------------------


            }//END AUTO CHANGER
             // ------------------------ 
                      




        //end description of Main submodules
        }

                


