#!/bin/sh
#this script generates the groovy description file fr the loader-standalone  with simulated hardware

#Directory where one can find the groovy description files
source .setupFCS_BIN
echo "RESOURCES_DIR=$RESOURCES_DIR"

#Directory were are stored all scripts
echo "SCRIPTS_DIR=$SCRIPTS_DIR"


#the file this script is going to generate
LOADER_FILENAME=loader__simulation.groovy

#head file
LOADER_HEAD=loader-standalone_head

#bridge to loader hardware filename 
B_LOADER_DESC=bridgeToLoader_description
B_LOADER_STANDALONE_DESC=bridgeToLoaderSTANDALONE_description

#Fake autochanger Description
FAKE_AC_DESC=fakeAutochanger_description

#Loader description
LOADER_DESC=loader_description

#Directory to save files
TMPDIR=/Users/virieux/tmp/

cd $RESOURCES_DIR

### save existing FCS description file ###
echo "Saving $LOADER_FILENAME in $TMPDIR"
DATE=`date '+%Y%m%d_%H%M%S'`
cp $LOADER_FILENAME $TMPDIR/$LOADER_FILENAME.$DATE

### saving existing bridgeToLoaderSTANDALONE_description description file ###
echo "Saving $B_LOADER_STANDALONE_DESC in $TMPDIR"
DATE=`date '+%Y%m%d_%H%M%S'`
cp $B_LOADER_STANDALONE_DESC $TMPDIR/$B_LOADER_STANDALONE_DESC.$DATE

### Generation of file LOADER_FILENAME

echo "Generation of $LOADER_FILENAME from $LOADER_HEAD $B_LOADER_STANDALONE_DESC $FAKE_AC_DESC $LOADER_DESC"

chmod u+w $LOADER_FILENAME
chmod u+w $B_LOADER_STANDALONE_DESC

cat $B_LOADER_DESC|sed 's/SimuLoaderPlutoGateway/SimuLoaderStandalonePlutoGateway/g' > $B_LOADER_STANDALONE_DESC
cat $LOADER_HEAD $B_LOADER_STANDALONE_DESC $FAKE_AC_DESC $LOADER_DESC > $LOADER_FILENAME

echo "}    // main" >> $LOADER_FILENAME
chmod u-w $LOADER_FILENAME
chmod u-w $B_LOADER_STANDALONE_DESC

