/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;

public class SimuEPOSControllerModule
extends CanOpenEPOS {
    private boolean enabled;
    protected int targetPosition;
    protected int position = 0;
    protected int ssiPosition;
    protected int targetCurrent;
    protected int actualCurrent;

    public SimuEPOSControllerModule(String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.mode = EPOSEnumerations.EposMode.PROFILE_POSITION;
        this.enabledToPublish = true;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="For simulator only : Update position with a position given as argument.")
    public void setPosition(int actualPosition) {
        this.position = actualPosition;
    }

    @Override
    public boolean isTargetReached() {
        return this.position == this.targetPosition || this.actualCurrent == this.targetCurrent;
    }

    @Override
    public boolean isParametersOK() {
        return true;
    }

    @Override
    public void enableAndWriteRelativePosition(int pos) {
        this.enable();
        this.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.writeTargetPosition(this.position + pos);
        this.writeControlWord("7F");
    }

    @Override
    public void defineAbsolutePosition(int position) {
        this.position = position;
    }

    @Override
    public void disable() {
        this.enabled = false;
        this.publishData();
    }

    @Override
    public void writeParameters(EPOSEnumerations.EposMode mode) {
    }

    @Override
    public void writeParameterInHexa(EPOSEnumerations.Parameter parameter, String string) {
        FCSCst.FCSLOG.info((Object)(this.getName() + " " + parameter.toString() + " set to value in HEXA=" + string));
    }

    @Override
    public void writeParameter(EPOSEnumerations.Parameter param, int value) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + "writeParameter"));
    }

    @Override
    public void writeTargetPosition(int position) {
        this.position = position;
    }

    @Override
    public void writeParameters(Map<String, Integer> paramMap) {
    }

    @Override
    public void writeCurrent(int aValue) {
        this.turnedOff = false;
        this.actualCurrent = aValue;
    }

    @Override
    public void off() {
        this.turnedOff = true;
    }

    @Override
    public int readPosition() {
        return this.position;
    }

    @Override
    public int readSSIPosition() {
        return this.ssiPosition;
    }

    @Override
    public void enable() {
        this.enabled = true;
        this.publishData();
    }

    @Override
    public int readCurrent() {
        return this.actualCurrent;
    }

    @Override
    public EPOSEnumerations.EposMode readMode() {
        return this.mode;
    }

    @Override
    public void quickStop() {
        FCSCst.FCSLOG.finest((Object)(this.getName() + " quickStop done."));
    }

    @Override
    public int readNumberOfErrors() {
        return 0;
    }

    @Override
    public String readErrorRegister() {
        return null;
    }

    @Override
    public String[] readErrorHistory() {
        return new String[0];
    }

    @Override
    public String displayErrorHistory() {
        return "No ERROR";
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the Controller is in fault.")
    public void checkFault() {
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns always true in simulation.")
    public boolean isBooted() {
        return true;
    }

    @Override
    public int readProfileVelocity() {
        return 0;
    }

    @Override
    public String readParameters(EPOSEnumerations.EposMode mode) {
        return this.getName() + ":no parameter to read.";
    }

    @Override
    public void checkParameters(EPOSEnumerations.EposMode aMode) {
    }

    @Override
    protected void checkCurrentValue(int aValue) {
    }

    @Override
    public void writeControlWord(String f) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + "writeControlWord :" + f));
    }

    @Override
    public void shutdownEPOS() {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " is SHUTDOWN"));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

