/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutoChangerTwoTrucksModule;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClampModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterIdentificator;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerLinearRailController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuFilterIDPlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGateway;

public class SimuAutochangerPlutoGateway
extends SimuPlutoGateway
implements SimuFilterIDPlutoGatewayInterface {
    private FilterIdentificator filterIdentificator;
    private FilterHolder carousel;
    private AutoChangerModule autochanger;
    private AutoChangerTwoTrucksModule trucks;
    private SimuAutochangerLinearRailController linearRailMasterController;
    private SimuAutochangerLinearRailController linearRailSlaveController;
    private AutochangerOnlineClampModule onlineClampXminus;
    private AutochangerOnlineClampModule onlineClampXplus;
    private AutochangerOnlineClampModule onlineClampYminus;
    private ComplementarySensors loaderConnectedSensors;
    private ComplementarySensors lockSensorsLatchXminus;
    private ComplementarySensors lockSensorsLatchXplus;
    private ComplementarySensors unlockSensorsLatchXminus;
    private ComplementarySensors unlockSensorsLatchXplus;
    private ComplementarySensors filterEngagedSensorsLatchXminus;
    private ComplementarySensors filterEngagedSensorsLatchXplus;
    private ComplementarySensors handoffPositionSensorsXminus;
    private ComplementarySensors onlinePositionSensorsXminus;
    private ComplementarySensors standbyPositionSensorsXminus;
    private ComplementarySensors handoffPositionSensorsXplus;
    private ComplementarySensors onlinePositionSensorsXplus;
    private ComplementarySensors standbyPositionSensorsXplus;

    public SimuAutochangerPlutoGateway(String nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public List<DigitalSensor> getFilterIDSensors() {
        return this.filterIdentificator.getFilterIDSensors();
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getComponentLookup();
        this.filterIdentificator = (FilterIdentificator)((Object)lookup.getComponentByName("filterIdentificator"));
        this.carousel = (FilterHolder)lookup.getComponentByName("carousel");
        this.loaderConnectedSensors = (ComplementarySensors)lookup.getComponentByName("loaderConnectedSensors");
        this.linearRailMasterController = (SimuAutochangerLinearRailController)lookup.getComponentByName("linearRailMasterController");
        this.linearRailSlaveController = (SimuAutochangerLinearRailController)lookup.getComponentByName("linearRailSlaveController");
        this.trucks = (AutoChangerTwoTrucksModule)lookup.getComponentByName("autochangerTrucks");
        this.lockSensorsLatchXminus = (ComplementarySensors)lookup.getComponentByName("lockSensorsLatchXminus");
        this.unlockSensorsLatchXminus = (ComplementarySensors)lookup.getComponentByName("unlockSensorsLatchXminus");
        this.filterEngagedSensorsLatchXminus = (ComplementarySensors)lookup.getComponentByName("filterEngagedSensorsLatchXminus");
        this.lockSensorsLatchXplus = (ComplementarySensors)lookup.getComponentByName("lockSensorsLatchXplus");
        this.unlockSensorsLatchXplus = (ComplementarySensors)lookup.getComponentByName("unlockSensorsLatchXplus");
        this.filterEngagedSensorsLatchXplus = (ComplementarySensors)lookup.getComponentByName("filterEngagedSensorsLatchXplus");
        this.onlineClampXminus = (AutochangerOnlineClampModule)lookup.getComponentByName("onlineClampXminus");
        this.onlineClampXplus = (AutochangerOnlineClampModule)lookup.getComponentByName("onlineClampXplus");
        this.onlineClampYminus = (AutochangerOnlineClampModule)lookup.getComponentByName("onlineClampYminus");
        this.handoffPositionSensorsXminus = (ComplementarySensors)lookup.getComponentByName("handoffPositionSensorsXminus");
        this.handoffPositionSensorsXplus = (ComplementarySensors)lookup.getComponentByName("handoffPositionSensorsXplus");
        this.onlinePositionSensorsXminus = (ComplementarySensors)lookup.getComponentByName("onlinePositionSensorsXminus");
        this.onlinePositionSensorsXplus = (ComplementarySensors)lookup.getComponentByName("onlinePositionSensorsXplus");
        this.standbyPositionSensorsXminus = (ComplementarySensors)lookup.getComponentByName("standbyPositionSensorsXminus");
        this.standbyPositionSensorsXplus = (ComplementarySensors)lookup.getComponentByName("standbyPositionSensorsXplus");
        this.simulateAutochangerTrucksAreAtHandoff();
        this.simulateAutochangerIsEmpty();
        this.simulateAutochangerLatchesAreUnlocked();
        this.simulateAutochangerOnlineClampsAreUnlocked();
    }

    protected void simuComplementarySensorsOn(ComplementarySensors sensors) {
        this.replaceHexaValues(sensors.getSensor(), true);
        this.replaceHexaValues(sensors.getSensorC(), false);
    }

    protected void simuComplementarySensorsNotOn(ComplementarySensors sensors) {
        this.replaceHexaValues(sensors.getSensor(), false);
        this.replaceHexaValues(sensors.getSensorC(), true);
    }

    protected void simuComplementarySensorsInError(ComplementarySensors sensors) {
        this.replaceHexaValues(sensors.getSensor(), true);
        this.replaceHexaValues(sensors.getSensorC(), true);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksAreAtHandoff() {
        ComplementarySensors[] sensors;
        FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksAreAtHandoff");
        this.simuComplementarySensorsOn(this.handoffPositionSensorsXminus);
        this.simuComplementarySensorsOn(this.handoffPositionSensorsXplus);
        for (ComplementarySensors coupleSensors : sensors = new ComplementarySensors[]{this.standbyPositionSensorsXminus, this.standbyPositionSensorsXplus, this.onlinePositionSensorsXminus, this.onlinePositionSensorsXplus}) {
            this.simuComplementarySensorsNotOn(coupleSensors);
        }
        this.setTrucksPosition(this.trucks.getHandoffPosition());
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.getName(), (Object)this.trucks.getHandoffPosition()));
        FCSCst.FCSLOG.info((Object)"end of simulateAutochangerTrucksAreAtHandoff");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksAreOnline() {
        ComplementarySensors[] sensors;
        FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksAreOnline");
        this.simuComplementarySensorsOn(this.onlinePositionSensorsXminus);
        this.simuComplementarySensorsOn(this.onlinePositionSensorsXplus);
        for (ComplementarySensors coupleSensors : sensors = new ComplementarySensors[]{this.standbyPositionSensorsXminus, this.standbyPositionSensorsXplus, this.handoffPositionSensorsXminus, this.handoffPositionSensorsXplus}) {
            this.simuComplementarySensorsNotOn(coupleSensors);
        }
        this.setTrucksPosition(this.trucks.getOnlinePosition());
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.getName(), (Object)this.trucks.getOnlinePosition()));
        FCSCst.FCSLOG.info((Object)"end of simulateAutochangerTrucksAreOnline");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksAreAtStandby() {
        ComplementarySensors[] sensors;
        FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksAreAtStandby");
        this.simuComplementarySensorsOn(this.standbyPositionSensorsXminus);
        this.simuComplementarySensorsOn(this.standbyPositionSensorsXplus);
        for (ComplementarySensors coupleSensors : sensors = new ComplementarySensors[]{this.onlinePositionSensorsXminus, this.onlinePositionSensorsXplus, this.handoffPositionSensorsXminus, this.handoffPositionSensorsXplus}) {
            this.simuComplementarySensorsNotOn(coupleSensors);
        }
        this.setTrucksPosition(this.trucks.getStandbyPosition());
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.getName(), (Object)this.trucks.getStandbyPosition()));
        this.simulateFilterIDAtStandby();
        FCSCst.FCSLOG.info((Object)"end of simulateAutochangerTrucksAreAtStandby");
    }

    private void setTrucksPosition(int pos) {
        this.linearRailMasterController.setPosition(pos);
        this.linearRailMasterController.setSsiPosition(this.linearRailMasterController.getEncoderRibbonMinValue() + pos);
        this.linearRailSlaveController.setPosition(pos);
        this.linearRailSlaveController.setSsiPosition(this.linearRailSlaveController.getEncoderRibbonMinValue() + pos);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksAreInTravel() {
        ComplementarySensors[] sensors;
        for (ComplementarySensors coupleSensors : sensors = new ComplementarySensors[]{this.onlinePositionSensorsXminus, this.onlinePositionSensorsXplus, this.handoffPositionSensorsXminus, this.handoffPositionSensorsXplus, this.standbyPositionSensorsXminus, this.standbyPositionSensorsXplus}) {
            this.simuComplementarySensorsNotOn(coupleSensors);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsConnected() {
        this.simuComplementarySensorsOn(this.loaderConnectedSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsDisconnected() {
        this.simuComplementarySensorsNotOn(this.loaderConnectedSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsOnAutochanger() {
        this.simuComplementarySensorsOn(this.filterEngagedSensorsLatchXminus);
        this.simuComplementarySensorsOn(this.filterEngagedSensorsLatchXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerIsEmpty() {
        this.simuComplementarySensorsNotOn(this.filterEngagedSensorsLatchXminus);
        this.simuComplementarySensorsNotOn(this.filterEngagedSensorsLatchXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchesAreLocked() {
        this.simuComplementarySensorsOn(this.lockSensorsLatchXminus);
        this.simuComplementarySensorsOn(this.lockSensorsLatchXplus);
        this.simuComplementarySensorsNotOn(this.unlockSensorsLatchXminus);
        this.simuComplementarySensorsNotOn(this.unlockSensorsLatchXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchesAreUnlocked() {
        this.simuComplementarySensorsNotOn(this.lockSensorsLatchXminus);
        this.simuComplementarySensorsNotOn(this.lockSensorsLatchXplus);
        this.simuComplementarySensorsOn(this.unlockSensorsLatchXminus);
        this.simuComplementarySensorsOn(this.unlockSensorsLatchXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchIsLocked(String latchName) {
        if (latchName.contains("Xminus")) {
            this.simuComplementarySensorsOn(this.lockSensorsLatchXminus);
            this.simuComplementarySensorsNotOn(this.unlockSensorsLatchXminus);
        } else if (latchName.contains("Xplus")) {
            this.simuComplementarySensorsOn(this.lockSensorsLatchXplus);
            this.simuComplementarySensorsNotOn(this.unlockSensorsLatchXplus);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchIsUnlocked(String latchName) {
        if (latchName.contains("Xminus")) {
            this.simuComplementarySensorsNotOn(this.lockSensorsLatchXminus);
            this.simuComplementarySensorsOn(this.unlockSensorsLatchXminus);
        } else if (latchName.contains("Xplus")) {
            this.simuComplementarySensorsNotOn(this.lockSensorsLatchXplus);
            this.simuComplementarySensorsOn(this.unlockSensorsLatchXplus);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLatchLockSensorsInError(String latchName) {
        if (latchName.contains("Xminus")) {
            this.simuComplementarySensorsInError(this.lockSensorsLatchXminus);
        } else if (latchName.contains("Xplus")) {
            this.simuComplementarySensorsInError(this.lockSensorsLatchXplus);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampsAreLocked() {
        this.simulateAutochangerOnlineClampIsLocked(this.onlineClampXminus);
        this.simulateAutochangerOnlineClampIsLocked(this.onlineClampXplus);
        this.simulateAutochangerOnlineClampIsLocked(this.onlineClampYminus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampsAreClosed() {
        this.simulateAutochangerOnlineClampIsClosed(this.onlineClampXminus);
        this.simulateAutochangerOnlineClampIsClosed(this.onlineClampXplus);
        this.simulateAutochangerOnlineClampIsClosed(this.onlineClampYminus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampsAreUnlocked() {
        this.simulateAutochangerOnlineClampIsUnlocked(this.onlineClampXminus);
        this.simulateAutochangerOnlineClampIsUnlocked(this.onlineClampXplus);
        this.simulateAutochangerOnlineClampIsUnlocked(this.onlineClampYminus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampsAreOpened() {
        this.simulateAutochangerOnlineClampIsOpened(this.onlineClampXminus);
        this.simulateAutochangerOnlineClampIsOpened(this.onlineClampXplus);
        this.simulateAutochangerOnlineClampIsOpened(this.onlineClampYminus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampIsClosed(AutochangerOnlineClampModule clamp) {
        this.simuComplementarySensorsOn(clamp.getCloseSensors());
        this.simuComplementarySensorsNotOn(clamp.getOpenSensors());
        clamp.setSentCurrent(clamp.getCurrentToClose());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampIsLocked(AutochangerOnlineClampModule clamp) {
        this.simuComplementarySensorsOn(clamp.getCloseSensors());
        this.simuComplementarySensorsNotOn(clamp.getOpenSensors());
        clamp.setSentCurrent(clamp.getCurrentToClamp());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampIsUnlocked(AutochangerOnlineClampModule clamp) {
        this.simuComplementarySensorsOn(clamp.getCloseSensors());
        this.simuComplementarySensorsNotOn(clamp.getOpenSensors());
        clamp.setSentCurrent(clamp.getCurrentToClose());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampIsOpened(AutochangerOnlineClampModule clamp) {
        this.simuComplementarySensorsOn(clamp.getOpenSensors());
        this.simuComplementarySensorsNotOn(clamp.getCloseSensors());
        clamp.setSentCurrent(clamp.getCurrentToOpen());
    }

    private void simulateFilterIDAtStandby() {
        if (this.carousel instanceof CarouselModule && ((CarouselModule)this.carousel).getFilterAtStandby() != null) {
            this.simulateFilterID(((CarouselModule)this.carousel).getFilterAtStandby().getFilterID());
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIDOnAutochanger(int id) {
        this.simulateFilterIsOnAutochanger();
        this.simulateFilterID(id);
        this.autochanger.setFilterOnTrucksID(id);
    }

    public void start() {
        boolean aFilterIsOnTrucks = false;
        this.autochanger = (AutoChangerModule)this.getComponentLookup().getComponentByName("autochanger");
        FilterManager filterManager = (FilterManager)((Object)this.getComponentLookup().getComponentByName("filterManager"));
        SortedMap<String, Filter> filtersMap = filterManager.getFiltersMapByName();
        for (Map.Entry entry : filtersMap.entrySet()) {
            Filter filter = (Filter)entry.getValue();
            if (!filter.isOnAutoChanger()) continue;
            FCSCst.FCSLOG.fine((Object)(filter.getName() + " is on autochanger trucks."));
            aFilterIsOnTrucks = true;
            this.autochanger.setFilterOnTrucksID(filter.getFilterID());
        }
        if (aFilterIsOnTrucks) {
            this.simulateAutochangerTrucksAreOnline();
            this.simulateFilterIsOnAutochanger();
            this.simulateAutochangerLatchesAreLocked();
            this.simulateAutochangerOnlineClampsAreLocked();
        } else {
            this.simulateAutochangerTrucksAreAtHandoff();
            this.simulateAutochangerIsEmpty();
            this.simulateAutochangerLatchesAreUnlocked();
            this.simulateAutochangerOnlineClampsAreUnlocked();
        }
    }
}

