/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClampModule;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerWithBrake;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;

public class SimuAutochangerOnlineClampController
extends SimuEPOSControllerModule
implements EPOSControllerWithBrake {
    @ConfigurationParameter(isFinal=true)
    private String onlineClampName;
    private SimuAutochangerPlutoGateway plutoGateway;
    private String plutoGatewayName;
    private AutochangerOnlineClampModule onlineClamp;
    private boolean brakeActivated;

    public SimuAutochangerOnlineClampController(String nodeID, String serialNB, String onlineClampName, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.onlineClampName = onlineClampName;
        this.plutoGatewayName = "acSensorsGateway";
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getComponentLookup();
        this.plutoGateway = (SimuAutochangerPlutoGateway)lookup.getComponentByName(this.plutoGatewayName);
        this.onlineClamp = (AutochangerOnlineClampModule)lookup.getComponentByName(this.onlineClampName);
    }

    @Override
    public void writeCurrent(int current) {
        this.targetCurrent = current;
        this.actualCurrent = current;
        if (this.targetCurrent == this.onlineClamp.getCurrentToClose()) {
            this.plutoGateway.simulateAutochangerOnlineClampIsClosed(this.onlineClamp);
        } else if (this.targetCurrent == this.onlineClamp.getCurrentToOpen()) {
            this.plutoGateway.simulateAutochangerOnlineClampIsOpened(this.onlineClamp);
        } else if (this.targetCurrent == this.onlineClamp.getCurrentToClamp()) {
            this.plutoGateway.simulateAutochangerOnlineClampIsLocked(this.onlineClamp);
        }
    }

    @Override
    public void activateBrakeAndDisable() {
        this.brakeActivated = true;
    }

    @Override
    public void enableAndReleaseBrake() {
        this.brakeActivated = false;
    }

    @Override
    public void doReleaseBrake() {
        this.brakeActivated = false;
    }

    @Override
    public boolean isBrakeActivated() {
        return this.brakeActivated;
    }

    @Override
    public void activateBrake() {
        this.brakeActivated = true;
    }
}

