/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;

public class CanOpenSystecIO
extends CanOpenDevice {
    public int defaultSensorType = 33;
    public int digitalDigit = 1;
    public int lowerLimitValue = -20;
    public int upperLimitValue = 50;

    public CanOpenSystecIO(String nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Command(type=Command.CommandType.QUERY, description="Initialize and configure the device in order to be able to read temperatures.")
    public void initialize() {
        for (int i = 1; i < 9; ++i) {
            this.setAISensorType(i, this.defaultSensorType);
            this.setDigitalDigit(i, this.digitalDigit);
            this.setLowerLimit(i, this.lowerLimitValue);
            this.setUpperLimit(i, this.upperLimitValue);
            this.enableChannel(i);
        }
        this.initialized = true;
    }

    public void setGain(int channelNO, int gainValue) {
    }

    public void setAISensorType(int channelNO, int sensorType) {
        String sensorTypeStr = Integer.toString(sensorType, 16);
        this.writeSDO("6110", Integer.toString(channelNO), "02", sensorTypeStr);
    }

    public void setDigitalDigit(int chanelNO, int digitalDigit) {
        this.writeSDO("6132", Integer.toString(chanelNO), "01", Integer.toString(digitalDigit));
    }

    public void setLowerLimit(int chanelNO, int lowerLimitValue) {
        this.writeSDO("7134", Integer.toString(chanelNO), "02", Integer.toHexString(lowerLimitValue));
    }

    public void setUpperLimit(int chanelNO, int upperLimitValue) {
        this.writeSDO("7135", Integer.toString(chanelNO), "02", Integer.toString(upperLimitValue));
    }

    public void setAIOperationMode(int chanelNO, int operationMode) {
        this.writeSDO("6112", Integer.toString(chanelNO), "01", Integer.toHexString(operationMode));
    }

    public void enableChannel(int channelNO) {
        this.setAIOperationMode(channelNO, 1);
    }

    public void disableChannel(int channelNO) {
        this.setAIOperationMode(channelNO, 0);
    }

    @Command(type=Command.CommandType.QUERY, description="read chanel and return hexa value of temperature read")
    public String readChannelHexaValue(int channelNO) {
        return this.readSDO("7130", Integer.toString(channelNO));
    }

    @Command(type=Command.CommandType.QUERY, description="read channel and return temperature read as a double")
    public double readChannel(int channelNO) {
        return Integer.parseInt(this.readChannelHexaValue(channelNO), 16);
    }
}

