/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.nio.file.FileSystemNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;
import org.lsst.ccs.subsystems.fcs.drivers.FcsTcpProxy;
import org.lsst.ccs.subsystems.fcs.errors.CWrapperNotConnected;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenProxy
extends FcsTcpProxy
implements HardwareController,
ClearAlertHandler,
BridgeToHardware {
    @ConfigurationParameter(isFinal=true)
    private String clientName;
    @ConfigurationParameter(range="1000..10000", description="A timeout for the hardware booting process")
    private long hardwareBootTimeout = 1000L;
    protected Map<String, CanOpenNode> bootedNodes = new HashMap<String, CanOpenNode>();
    protected Map<String, PieceOfHardware> hardwareMapByNodeID = new HashMap<String, PieceOfHardware>();
    private StringBuilder errorMessageSB;
    private boolean hardwareIDError;
    protected boolean hardwareBootProcessEnded = false;
    private PDOStorage pdoStorage;
    private ScheduledFuture<?> checkDevicesHandle;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
    protected final Condition bootingCompleted = this.lock.newCondition();

    public CanOpenProxy(int portNumber, int fieldBusTimeout, String clientName, long hardwareBootTimeout) {
        super(portNumber, fieldBusTimeout);
        this.clientName = clientName;
        this.hardwareBootTimeout = hardwareBootTimeout;
    }

    public String getMyClientName() {
        return this.clientName;
    }

    public PDOStorage getPdoStorage() {
        return this.pdoStorage;
    }

    @Override
    public void disconnectHardware() {
        this.stopServer();
        this.initialize();
    }

    @Override
    public void connectHardware() throws HardwareException {
        this.startServer();
        this.startThreadReader();
    }

    @Override
    public void initModule() {
        super.initModule();
        this.initialize();
        ComponentLookup lookup = this.getSubsystem().getComponentLookup();
        Map mapByName = lookup.getChildren(this.getName(), PieceOfHardware.class);
        for (PieceOfHardware poh : mapByName.values()) {
            this.hardwareMapByNodeID.put(poh.getNodeID(), poh);
        }
        FCSCst.FCSLOG.info((Object)(this.getName() + ": init MODULE CanOpenProxy."));
        FCSCst.FCSLOG.info((Object)(this.getName() + ":NUMBER OF CAN OPEN DEVICES EXPECTED =" + this.hardwareMapByNodeID.size()));
        FCSCst.FCSLOG.info((Object)this.toString());
        try {
            CanOpenErrorsTable.loadDeviceErrorTable();
            CanOpenErrorsTable.loadErrorRegisterTable();
            CanOpenErrorsTable.loadCommunicationErrorTable();
        }
        catch (DeploymentException ex) {
            String msg = ex + ": Could not load CanOpen Error Tables";
            FCSCst.FCSLOG.error((Object)msg);
            throw new FileSystemNotFoundException(msg);
        }
    }

    public void initialize() {
        this.bootedNodes = new HashMap<String, CanOpenNode>();
        this.hardwareBootProcessEnded = false;
        this.hardwareIDError = false;
        this.pdoStorage = new PDOStorage();
        this.errorMessageSB = new StringBuilder(String.valueOf(this.getName()));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1)
    public TreeWalkerDiag checkHardware() throws HardwareException {
        this.hardwareBootProcessEnded = false;
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": BEGIN CHECKHARDWARE"));
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.CAN_DEVICES_BOOTING, FcsEnumerations.FilterReadinessState.NOT_READY});
        this.lock.lock();
        try {
            this.readDevicesInfo(System.currentTimeMillis(), this.hardwareBootTimeout);
            this.waitForEndOfBooting();
        }
        finally {
            FCSCst.FCSLOG.debug((Object)(this.getName() + ": finally in checkHardware"));
            this.hardwareBootProcessEnded = true;
            this.bootingCompleted.signalAll();
            this.lock.unlock();
        }
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": END OF BOOT PROCESS"));
        FCSCst.FCSLOG.info((Object)(this.getName() + "=>" + this.listBootedNodes()));
        this.checkBootedCanOpenNodes();
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": END CHECKHARDWARE"));
        this.publishData();
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void checkHardwareLight() throws HardwareException {
        this.hardwareBootProcessEnded = false;
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": BEGIN CHECKHARDWARE"));
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.CAN_DEVICES_BOOTING, FcsEnumerations.FilterReadinessState.NOT_READY});
        long duration = 0L;
        long beginTime = System.currentTimeMillis();
        while (!this.hardwareBootProcessEnded && duration < this.hardwareBootTimeout) {
            this.retrieveHardwareInfoLight();
            duration = System.currentTimeMillis() - beginTime;
        }
    }

    public void retrieveHardwareInfoLight() throws HardwareException {
        FCSCst.FCSLOG.info((Object)(this.getName() + ":Identification of the hardware"));
        for (Map.Entry<String, PieceOfHardware> entry : this.hardwareMapByNodeID.entrySet()) {
            PieceOfHardware poh = entry.getValue();
            String bootedNodeID = entry.getKey();
            this.updateDeviceInfoLight(bootedNodeID);
        }
        this.publishData();
    }

    public void readDevicesInfo(long beginTime, long timeout) {
        Runnable checkDevices = () -> {
            try {
                this.retrieveHardwareInfo();
                this.publishData();
                long duration = System.currentTimeMillis() - beginTime;
                if (duration > timeout || this.bootedNodes.size() == this.hardwareMapByNodeID.size()) {
                    this.hardwareBootProcessEnded = true;
                    this.cancelReadDevicesInfo();
                }
            }
            catch (HardwareException ex) {
                FCSCst.FCSLOG.error((Object)(this.getName() + " couln't read devices info because:" + (Object)((Object)ex)));
            }
        };
        this.checkDevicesHandle = this.scheduler.scheduleAtFixedRate(checkDevices, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    private void cancelReadDevicesInfo() {
        this.lock.lock();
        try {
            FCSCst.FCSLOG.debug((Object)(this.getName() + " => stop waiting for devices info."));
            this.bootingCompleted.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.checkDevicesHandle.cancel(true);
        FCSCst.FCSLOG.debug((Object)(this.getName() + " => readDevicesInfo canceled"));
    }

    private void waitForEndOfBooting() {
        while (!this.hardwareBootProcessEnded) {
            try {
                FCSCst.FCSLOG.info((Object)(this.getName() + " waiting until all pieces of hardware are booted."));
                this.bootingCompleted.await();
            }
            catch (InterruptedException ex) {
                FCSCst.FCSLOG.info((Object)(this.getName() + ": InterruptedException received=" + ex));
                break;
            }
        }
        FCSCst.FCSLOG.info((Object)(this.getName() + " STOP WAITING FOR END OF BOOTING PROCESS"));
    }

    public void checkStarted() throws HardwareException {
        FCSCst.FCSLOG.info((Object)(this.getName() + " BEGIN checkStarted"));
        this.checkHardware();
        FCSCst.FCSLOG.info((Object)(this.getName() + " END checkStarted"));
    }

    public void checkStopped() throws HardwareException {
        FCSCst.FCSLOG.info((Object)(this.getName() + " nothing to do in checkStopped"));
    }

    @Override
    public void shutdownNow() {
        super.shutdownNow();
        this.scheduler.shutdown();
    }

    public String getNodeName(String aNodeID) {
        if (this.hardwareMapByNodeID.get(aNodeID) == null) {
            return "UnknownDevice" + aNodeID;
        }
        return this.hardwareMapByNodeID.get(aNodeID).getName();
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Return true if the device, with nodeID given as argument, is booted.")
    public boolean isBooted(String aNodeID) {
        return this.bootedNodes.containsKey(aNodeID);
    }

    private boolean isSerialNumberOK(String aNodeID) {
        if (this.bootedNodes.containsKey(aNodeID)) {
            return this.hardwareMapByNodeID.get(aNodeID).getSerialNB().equals(this.bootedNodes.get(aNodeID).getSerialNB());
        }
        return false;
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Print the list of CANopen nodes which are booted on the CAN bus. (values are in HEXA)")
    public String listBootedNodes() {
        if (this.bootedNodes.isEmpty()) {
            return this.getName() + ": no booted CANopen devices.";
        }
        return this.getName() + " booted CANopen devices:" + this.bootedNodes.toString();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Send a CanOpen command to the Can Bus.")
    public String sendCanOpenCommand(String command) {
        if (!this.tcpServerStarted) {
            throw new FcsHardwareException(this.getName() + ": is not started, can't send CanOpen commands.");
        }
        FcsUtils.checkCommand(command);
        return this.sendCanOpen(command);
    }

    protected void checkCanOpenCommand(String command) {
        FcsUtils.checkCommand(command);
        String[] words = command.split(",");
        if (words.length > 1) {
            this.checkNodeID(words[1]);
        }
    }

    public void checkNodeID(String nodeID) {
        if (!this.hardwareMapByNodeID.containsKey(nodeID)) {
            throw new IllegalArgumentException(nodeID + " is not in the hardware list for tcpProxy " + this.getName());
        }
    }

    private String sendCanOpen(String command) {
        try {
            return (String)this.call(this.getMyClientName(), command);
        }
        catch (CWrapperNotConnected ex) {
            this.raiseAlarm("FCS001:" + this.getName(), "Can't communicate with hardware because CWrapper is not connected - check ethernet connections.", ex);
            throw new FcsHardwareException("CWrapper not connected.", ex);
        }
    }

    public String writeSDO(String nodeID, String index, String subindex, String size, String value) {
        String request = FcsUtils.buildWsdoCommand(nodeID, index, subindex, size, value);
        String sdoResponseLine = this.sendCanOpen(request);
        String[] words = sdoResponseLine.split(",");
        String errorCode = words[2];
        if ("0".equals(errorCode)) {
            return "OK";
        }
        String msg = this.getName() + ":wrong writeSDO command : " + sdoResponseLine;
        this.processSDORequestError(request, sdoResponseLine, nodeID, errorCode, AlertState.ALARM);
        throw new SDORequestException(msg);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Send a CanOpen writeSDO command to the Can Bus.  \nValues of the argument are to be given in hexadecimal format for: index and subindex\n and in decimal format for size and value.\n size represents the number of bytes on which the value is encoded. See device documentation.")
    public String writeSDO(String nodeID, String index, String subindex, int size, int value) {
        this.checkNodeID(nodeID);
        if (size < 0 || size > 4) {
            throw new IllegalArgumentException("size must be > 0 and < 4");
        }
        return this.writeSDO(nodeID, index, subindex, Integer.toHexString(size), Integer.toHexString(value));
    }

    public String readSDO(String nodeID, String index, String subindex) {
        String request = FcsUtils.buildRsdoCommand(nodeID, index, subindex);
        String sdoLine = this.sendCanOpen(FcsUtils.buildRsdoCommand(nodeID, index, subindex));
        return this.processResponseToReadSDO(sdoLine, nodeID, request);
    }

    public String processResponseToReadSDO(String response, String nodeID, String request) {
        String[] words = response.split(",");
        int responseLength = words.length;
        String errorCode = words[2];
        if ("0".equals(errorCode) && responseLength > 3) {
            return words[3];
        }
        if ("0".equals(errorCode) && responseLength == 3) {
            String msg = this.getName() + ":readSDO request received a too short response=" + response + " request was" + request;
            String deviceName = this.getNodeName(nodeID);
            this.raiseWarning(deviceName + ":" + FcsEnumerations.FcsAlert.SDO_TOO_SHORT, FcsEnumerations.FcsAlert.SDO_TOO_SHORT.getLongDescription(), msg);
            throw new ShortResponseToSDORequestException(msg);
        }
        if ("-1".equals(errorCode)) {
            String msg = this.getName() + ":wrong readSDO command : " + request + " response:" + response;
            String deviceName = this.getNodeName(nodeID);
            this.raiseAlarm(FcsEnumerations.FcsAlert.SDO_ERROR, msg, deviceName);
            throw new SDORequestException(msg);
        }
        String msg = this.getName() + ":wrong readSDO command : " + request + " response:" + response;
        this.processSDORequestError(request, response, nodeID, errorCode, AlertState.ALARM);
        throw new SDORequestException(msg);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Send a CANOpen readSDO command to the Can Bus.")
    public String readSDOCommand(String nodeID, String index, String subindex) {
        this.checkNodeID(nodeID);
        return this.readSDO(nodeID, index, subindex);
    }

    public void processSDORequestError(String request, String response, String nodeID, String errorCode, AlertState alertState) {
        String error = String.format("%08d", Integer.parseInt(errorCode));
        String errorName = CanOpenErrorsTable.getCommErrorNameByCode(error);
        String deviceName = this.getNodeName(nodeID);
        String msg = this.getName() + ": SDO request was going wrong for device: " + deviceName;
        msg = msg + ",request=" + request + ",received response=" + response;
        msg = msg + ",errorCode=" + errorCode + ",errorName=" + errorName;
        if (alertState == AlertState.WARNING) {
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, msg, deviceName);
        } else {
            this.raiseAlarm(FcsEnumerations.FcsAlert.SDO_ERROR, msg, deviceName);
        }
    }

    @Override
    public PDOStorage readPDOs() {
        try {
            String replyToSync = this.sendCanOpen("sync");
            FCSCst.FCSLOG.finest((Object)(this.getName() + ": replyToSync=" + replyToSync));
            this.pdoStorage.updatePDOs(replyToSync);
            return this.pdoStorage;
        }
        catch (FcsHardwareException ex) {
            String msg = this.getName() + ": error in response to a sync command.";
            this.raiseAlarm("FCS001:", msg, ex);
            throw new FcsHardwareException(msg, ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Identification of the hardware : we want to retrieve the information \n     * stored in the hardware of the booted nodes and update the array of nodes\n     * with this information.")
    public void retrieveHardwareInfo() throws HardwareException {
        FCSCst.FCSLOG.info((Object)(this.getName() + ":Identification of the hardware"));
        for (Map.Entry<String, CanOpenNode> entry : this.bootedNodes.entrySet()) {
            CanOpenNode bootedNode = entry.getValue();
            String bootedNodeID = entry.getKey();
            if (bootedNode == null || bootedNode.isIdentified()) continue;
            this.updateDeviceInfo(bootedNodeID);
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update device information in sending to the CANbus a CANopen command : info,nodeID")
    public void updateDeviceInfo(String bootedNodeID) throws HardwareException {
        try {
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":Sending to can open command : info," + bootedNodeID));
            String result = this.sendCanOpen("info," + bootedNodeID);
            this.processInfoMessage(result, bootedNodeID);
        }
        catch (FcsHardwareException ex) {
            FCSCst.FCSLOG.error((Object)ex);
            throw new HardwareException(false, (Throwable)ex);
        }
    }

    public void updateDeviceInfoLight(String nodeID) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":Sending to can open command : info," + nodeID));
        try {
            String result = this.sendCanOpen("info," + nodeID);
            this.processInfoMessage(result, nodeID);
        }
        catch (CanOpenCallTimeoutException ex) {
            FCSCst.FCSLOG.warning((Object)(this.getName() + " couldn't get information for node id " + nodeID));
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all CANopen devices are booted and identified.Identified means that the serial numbers match the CANopen nodeID which reside inconfiguration.")
    public boolean isCANDevicesReady() {
        boolean nbBootedDevices = this.bootedNodes.size() == this.hardwareMapByNodeID.size();
        FCSCst.FCSLOG.info((Object)(this.getName() + ":hardwareBootProcessEnded=" + this.hardwareBootProcessEnded));
        FCSCst.FCSLOG.info((Object)(this.getName() + ":canOpenNodeNumbersOK=" + nbBootedDevices));
        FCSCst.FCSLOG.info((Object)(this.getName() + ":hardwareIDError=" + this.hardwareIDError));
        return this.hardwareBootProcessEnded && nbBootedDevices && !this.hardwareIDError;
    }

    @Override
    void processBootMessage(String nodeID) {
        if (this.isBooted(nodeID)) {
            this.checkResetNode(nodeID);
        } else {
            this.bootedNodes.put(nodeID, new CanOpenNode(nodeID));
            FCSCst.FCSLOG.info((Object)("Node " + nodeID + " added"));
            FCSCst.FCSLOG.info((Object)("Number of booted devices=" + this.bootedNodes.size()));
            FCSCst.FCSLOG.info((Object)("Number of expected devices=" + this.hardwareMapByNodeID.size()));
            this.checkResetNode(nodeID);
        }
    }

    private void checkResetNode(String nodeID) {
        if (this.hardwareBootProcessEnded) {
            String deviceName = this.getNodeName(nodeID);
            String cause = this.getName() + " received an unsynchronous boot message for node ID = " + nodeID + " Has the device been reset or powered on ? device name=" + deviceName;
            this.raiseWarning(deviceName + ":" + FcsEnumerations.FcsAlert.UNSYNC_BOOT, FcsEnumerations.FcsAlert.UNSYNC_BOOT.getLongDescription(), cause);
        }
    }

    @Override
    public void processEmcyMessage(String message) {
        String[] words = message.split(",");
        String nodeID = words[1].replaceFirst("^0+(?!$)", "");
        String deviceErrorCode = words[2];
        String errReg = words[3];
        String deviceErrorName = CanOpenErrorsTable.getDeviceErrorNameByCode(deviceErrorCode);
        String errorRegisterName = CanOpenErrorsTable.getErrorRegisterNameByCode(errReg);
        String deviceName = this.getNodeName(nodeID);
        EmergencyMessage emcyMsg = new EmergencyMessage(this.getName(), nodeID, deviceName, deviceErrorCode, deviceErrorName, errReg, errorRegisterName);
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.getName(), (Object)emcyMsg));
        FCSCst.FCSLOG.warning((Object)(this.getName() + " received EMERGENCY message=" + message + " for nodeID=" + nodeID));
        if ("00".equals(errReg) || "20".equals(nodeID)) {
            this.raiseWarning(FcsEnumerations.FcsAlert.EMCY, emcyMsg.toString(), deviceName);
        } else {
            this.raiseAlarm(FcsEnumerations.FcsAlert.EMCY, emcyMsg.toString(), deviceName);
        }
    }

    void processInfoMessage(String message, String bootedNodeID) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":Received on socket command = " + message));
        String[] words = message.split(",");
        String command = words[0];
        String nodeID = words[1];
        if ("info".equals(command) && bootedNodeID.equals(nodeID)) {
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":updating Node Info for node " + nodeID));
            String type = words[2];
            String vendor = words[3];
            String productCode = words[4];
            String revision = words[5];
            String serialNB = words[6];
            this.bootedNodes.get(bootedNodeID).setNodeInfo(type, vendor, productCode, revision, serialNB);
        } else {
            FCSCst.FCSLOG.error((Object)(this.getName() + ":ERROR for command = " + command + "NodeID = " + nodeID));
        }
    }

    public void checkBootedCanOpenNodes() throws HardwareException {
        FCSCst.FCSLOG.info((Object)(this.getName() + ":CHECKING HARDWARE CONFIGURATION "));
        this.checkNumberOfBootedNodes();
        this.hardwareIDError = false;
        for (PieceOfHardware hardware : this.hardwareMapByNodeID.values()) {
            FCSCst.FCSLOG.info((Object)("ABOUT TO CHECK: " + hardware.getName() + " NODE_ID=" + hardware.getNodeID()));
            this.checkHardwareID(hardware);
        }
        if (this.hardwareIDError) {
            throw new HardwareException(false, this.errorMessageSB.toString());
        }
        if (this.getSubsystem().isInState((Enum)OperationalState.ENGINEERING_OK)) {
            this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.HOMING_TO_BE_DONE, FcsEnumerations.FilterReadinessState.NOT_READY});
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Checks if the number of booted nodes is not zero.")
    public void checkNumberOfBootedNodes() throws HardwareException {
        if (this.bootedNodes.isEmpty()) {
            String msg = String.format(" (hardwareBootTimeout=%02d, expectedNodesNB=%02d)", this.hardwareBootTimeout, this.hardwareMapByNodeID.size());
            FCSCst.FCSLOG.error((Object)(this.getName() + ":NO HARDWARE DETECTED - POWER FAILURE ?" + msg));
            this.raiseAlarm(this.getName() + ":NO_HARDWARE", "NO HARDWARE DETECTED - POWER FAILURE ?", this.getName() + " this could happen because of a POWER FAILURE on CAN bus, or on CANopen devices." + msg);
            throw new HardwareException(true, this.getName() + msg);
        }
        if (this.bootedNodes.size() != this.hardwareMapByNodeID.size()) {
            FCSCst.FCSLOG.error((Object)(this.getName() + " number of booted nodes differs from number of expected devices"));
        }
    }

    protected void checkHardwareID(PieceOfHardware pieceOfHardware) {
        if (!this.bootedNodes.containsKey(pieceOfHardware.getNodeID())) {
            String msg = String.format(pieceOfHardware.getName() + ":HARDWARE NOT DETECTED - Possible power failure ? tcpProxy=" + this.getName() + " " + pieceOfHardware.toString(), new Object[0]);
            FCSCst.FCSLOG.error((Object)msg);
            this.errorMessageSB.append(msg);
            this.hardwareIDError = true;
            this.raiseAlarm(pieceOfHardware.getName() + ":" + FcsEnumerations.FcsAlert.HARDWARE_MISSING, FcsEnumerations.FcsAlert.HARDWARE_MISSING.getLongDescription(), msg);
        } else if (this.isSerialNumberOK(pieceOfHardware.getNodeID())) {
            FCSCst.FCSLOG.info((Object)(pieceOfHardware.getName() + " BOOTED AND SERIAL NUMBER OK:" + pieceOfHardware.toString()));
            this.publishHardwareData(pieceOfHardware);
        } else {
            CanOpenNode bootedNode = this.bootedNodes.get(pieceOfHardware.getNodeID());
            String msg = pieceOfHardware.getName() + " has a wrong serial number. tcpProxy =" + this.getName() + " Hardware expected:" + pieceOfHardware.toString() + " Hardware booted:" + bootedNode.toString();
            FCSCst.FCSLOG.error((Object)msg);
            this.errorMessageSB.append(msg);
            this.hardwareIDError = true;
            this.raiseAlarm(pieceOfHardware.getName() + ":" + FcsEnumerations.FcsAlert.HARDWARE_ERROR, FcsEnumerations.FcsAlert.HARDWARE_ERROR.getLongDescription(), msg);
        }
    }

    public CanOpenNode getBootedNodeBySerialNumber(String sn) {
        for (Map.Entry<String, CanOpenNode> entry : this.bootedNodes.entrySet()) {
            CanOpenNode bootedNode = entry.getValue();
            if (!bootedNode.getSerialNB().equalsIgnoreCase(sn)) continue;
            return bootedNode;
        }
        return null;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns the serial number read on the CANopen device if the  device is booted, otherwise returns null.")
    public String getBootedSerialNumberForNode(String nodeId) {
        if (this.bootedNodes.containsKey(nodeId)) {
            return this.bootedNodes.get(nodeId).getSerialNB();
        }
        return null;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns a String representation of a CANopen node booted on the CANbus for the device which serial number is given as a parameter.")
    public String printBootedNodeBySerialNumber(String sn) {
        if (sn == null) {
            throw new IllegalArgumentException(this.getName() + " Serial Number must be not null.");
        }
        return String.valueOf(this.getBootedNodeBySerialNumber(sn));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return a printed list of hardware.")
    public String printHardwareList() {
        return this.hardwareMapByNodeID.toString();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return a printed list of hardware with the initialization state.")
    public String printHardwareState() {
        this.publishData();
        StringBuilder sb = new StringBuilder(this.getName() + " CANopen devices : {");
        for (PieceOfHardware poh : this.hardwareMapByNodeID.values()) {
            sb.append(poh.printState());
            String snBooted = this.getBootedSerialNumberForNode(poh.getNodeID());
            if (poh.isBooted() && !poh.getSerialNB().equals(snBooted)) {
                sb.append(" ==>Booted with serial number=");
                sb.append(snBooted);
            }
            sb.append(";\n");
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return an Array containing hardware names handled by this component.")
    public List<String> listHardwareNames() {
        ArrayList<String> res = new ArrayList<String>();
        for (PieceOfHardware pieceOfHardware : this.hardwareMapByNodeID.values()) {
            res.add(pieceOfHardware.getName());
        }
        return res;
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        switch (alert.getAlertId()) {
            case "FCS001": {
                if (this.clientContext.socket.isConnected() && !this.clientContext.socket.isClosed()) {
                    return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
            case "FCS002": {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        }
        return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Publish booting information for all CANopen devices.")
    public void publishData() {
        for (PieceOfHardware device : this.hardwareMapByNodeID.values()) {
            this.publishHardwareData(device);
            if (!(device instanceof CanOpenEPOS)) continue;
            ((CanOpenEPOS)device).publishData();
        }
    }

    public void publishHardwareData(PieceOfHardware device) {
        StatusDataPublishedByHardware status = device.createStatusDataPublishedByHardware();
        FCSCst.FCSLOG.finest((Object)(this.getName() + ":publishHardwareData is publishing:" + status));
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)status));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Publish booting information for a CANopen device given by its CANopen nodeID.")
    public void publishHardwareData(String nodeID) {
        this.publishHardwareData(this.hardwareMapByNodeID.get(nodeID));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return a printed format of PDOStorage.")
    public String printPDOStorage() {
        return this.pdoStorage.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/clientName=");
        sb.append(this.clientName);
        sb.append("/hardwareBootTimeout=");
        sb.append(this.hardwareBootTimeout);
        return sb.toString();
    }

    @Override
    public boolean isCWrapperConnected() {
        return this.isReady(this.getMyClientName());
    }

    @Override
    public boolean isRealHardware() {
        return true;
    }
}

