/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.HashMap;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForLinearRail;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenEPOSLinearRailTruck
extends CanOpenEPOS
implements EPOSControllerForLinearRail {
    @ConfigurationParameter(description="minimal position of the encoder ribbon.")
    private final int encoderRibbonMinValue;
    private boolean homingDone;
    private boolean configDigitalInputOK = true;
    private boolean configDigitalOutputOK = true;
    private StringBuilder configDigitalInputSb = new StringBuilder(this.getName());
    private StringBuilder configDigitalOutputSb = new StringBuilder(this.getName());

    public CanOpenEPOSLinearRailTruck(String nodeID, String serialNB, HashMap<String, Integer> paramsForCurrent, HashMap<String, Integer> paramsForProfilePosition, HashMap<String, Integer> paramsForHoming, int encoderRibbonMinValue) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.encoderRibbonMinValue = encoderRibbonMinValue;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, description="return true if homing is done: the controller knows its absolute position.")
    public boolean isHomingDone() {
        return this.homingDone;
    }

    private void checkInMode(EPOSEnumerations.EposMode mode) {
        if (this.readMode() != mode) {
            throw new FcsHardwareException(this.getName() + " is not in mode " + (Object)((Object)mode));
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="return true if homing has to be done.")
    public void homing() {
        this.checkInitialized();
        this.homingDone = false;
        int ssiPosition = this.readSSIPosition();
        int pos = ssiPosition - this.encoderRibbonMinValue;
        FCSCst.FCSLOG.debug((Object)(this.getName() + " ssiPosition=" + ssiPosition + ", position=" + pos));
        if (Math.abs(pos - this.readPosition()) < 10) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " no homing to be done."));
            this.homingDone = true;
        } else {
            this.doHoming(pos);
            this.publishData();
        }
    }

    private void doHoming(int pos) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " ==> BEGIN homing"));
        this.defineAbsolutePosition(pos);
        long timeout = 500L;
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        while (!this.isTargetReached() && duration <= timeout) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " homing target not yet reached. duration=" + duration));
            duration = System.currentTimeMillis() - timeStart;
        }
        if (!this.isTargetReached()) {
            this.publishData();
            this.activateBrakeAndDisable();
            throw new FcsHardwareException(this.getName() + " couldn't do homing : target is not reached.");
        }
        this.writeControlWord("F");
        this.homingDone = true;
        this.publishData();
        this.activateBrakeAndDisable();
        FCSCst.FCSLOG.debug((Object)(this.getName() + " ==> END homing"));
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Activate brake to prevent truck motion.")
    public void activateBrake() {
        String hexaValue = this.readParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState);
        this.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState, FcsUtils.force2zero(hexaValue, 15));
        FCSCst.FCSLOG.info((Object)(this.getName() + ": brake activated."));
    }

    @Override
    public void doReleaseBrake() {
        if (!this.isEnabled()) {
            String msg = this.getName() + " was not enable before releaseBrake.";
            FCSCst.FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        String hexaValue = this.readParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState);
        this.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState, FcsUtils.force2one(hexaValue, 15));
        FCSCst.FCSLOG.info((Object)(this.getName() + ": brake released."));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="return true if brake if activated.")
    public boolean isBrakeActivated() {
        String hexaValue = this.readParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState);
        int digitalOutput = Integer.parseInt(hexaValue, 16);
        int[] digitalOutputInBinary = FcsUtils.toReverseBinary(digitalOutput);
        return digitalOutputInBinary[15] == 0;
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="activate brake to prevent motion and disable controller.")
    public void activateBrakeAndDisable() {
        this.activateBrake();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            FCSCst.FCSLOG.error((Object)ex);
        }
        this.disable();
    }

    @Override
    public void enableAndReleaseBrake() {
        this.enable();
        this.doReleaseBrake();
    }

    @Override
    public void enableAndWriteAbsolutePosition(int pos) {
        this.checkInMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.enable();
        this.doReleaseBrake();
        this.writeTargetPosition(pos);
        this.writeControlWord("3F");
    }

    @Override
    public void enableAndWriteRelativePosition(int pos) {
        this.enable();
        this.doReleaseBrake();
        this.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.writeTargetPosition(pos);
        this.writeControlWord("7F");
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the autochanger linear rails controllers.")
    public void configureDigitalInputOfLinearRails() {
        this.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, "0004");
        this.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput2, "0005");
        this.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, "0");
        this.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, "30");
        this.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, "30");
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="check configuration of digital input of linear rail controller.")
    public void checkConfigDigitalInputOfLinearRails() {
        this.configDigitalInputSb.append(" Configuration of Digital Input:");
        this.checkParamInput(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, "4");
        this.checkParamInput(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput2, "5");
        this.checkParamInput(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, "0");
        this.checkParamInput(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, "30");
        this.checkParamInput(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, "30");
        if (this.configDigitalInputOK) {
            FCSCst.FCSLOG.info((Object)this.configDigitalInputSb.toString());
        } else {
            FCSCst.FCSLOG.error((Object)this.configDigitalInputSb.toString());
        }
    }

    private void checkParamInput(EPOSEnumerations.Parameter param, String hexaValue) {
        int paramValue = this.readParameter(param);
        int configValue = Integer.parseInt(hexaValue, 16);
        if (configValue != paramValue) {
            this.configDigitalInputOK = false;
        }
        this.configDigitalInputSb.append((Object)param).append("=");
        this.configDigitalInputSb.append(paramValue).append(";");
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the autochanger linear rails controllers.")
    public void configureDigitalOutputOfLinearRails() {
        this.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, "0");
        this.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, "000F");
        this.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput2, "0");
        this.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput3, "0002");
        this.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, "0004");
        this.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, "8005");
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="check configuration of digital output of linear rail controller.")
    public void checkConfigDigitalOutputOfLinearRails() {
        this.configDigitalOutputSb.append(" Configuration of Digital Output:");
        this.checkParamOutput(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, "f");
        this.checkParamOutput(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput2, "0");
        this.checkParamOutput(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput3, "2");
        this.checkParamOutput(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, "4");
        this.checkParamOutput(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, "8005");
        if (this.configDigitalOutputOK) {
            FCSCst.FCSLOG.info((Object)this.configDigitalOutputSb.toString());
        } else {
            FCSCst.FCSLOG.error((Object)this.configDigitalOutputSb.toString());
        }
    }

    private void checkParamOutput(EPOSEnumerations.Parameter param, String hexaValue) {
        int paramValue = this.readParameter(param);
        int configValue = Integer.parseInt(hexaValue, 16);
        if (configValue != paramValue) {
            this.configDigitalOutputOK = false;
        }
        this.configDigitalOutputSb.append((Object)param).append("=");
        this.configDigitalOutputSb.append(paramValue).append(";");
    }
}

