/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Map;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenEPOS
extends CanOpenDevice
implements EPOSController {
    protected boolean turnedOff;
    protected boolean parametersOK;
    protected EPOSEnumerations.EposMode mode;
    @ConfigurationParameter
    private Map<String, Integer> paramsForHoming;
    @ConfigurationParameter
    private Map<String, Integer> paramsForProfilePosition;
    @ConfigurationParameter
    private Map<String, Integer> paramsForCurrent;
    protected boolean enabledToPublish;

    public CanOpenEPOS(String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB);
        this.paramsForCurrent = paramsForCurrent;
        this.paramsForProfilePosition = paramsForProfilePosition;
        this.paramsForHoming = paramsForHoming;
        this.turnedOff = false;
        this.parametersOK = true;
        this.enabledToPublish = false;
    }

    @Override
    public boolean isEnabledToPublish() {
        return this.enabledToPublish;
    }

    @Override
    public boolean isTurnedOff() {
        return this.turnedOff;
    }

    @Override
    public boolean isParametersOK() {
        return this.parametersOK;
    }

    @Override
    public EPOSEnumerations.EposMode getMode() {
        return this.mode;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, description="return true if this controller is in the mode given as argument.")
    public boolean isInMode(EPOSEnumerations.EposMode aMode) {
        return aMode.equals((Object)this.readMode());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Changes an EPOS parameter for this controller. Writes the new value on the CPU of the controller.Changes the new value in the configuration. But doesn't save the new parameter in the CPU. To save in CPU controller, use command saveParameters and saveAllChanges.To save configuration, use command saveAllChanges.")
    public void changeEPOSParameter(String key, int value) {
        String paramsToChangeName;
        Map<String, Integer> paramsToChange;
        EPOSEnumerations.Parameter parameter = EPOSEnumerations.Parameter.valueOf(key);
        this.writeParam(key, value);
        EPOSEnumerations.EposMode eposMode = EPOSEnumerations.EposMode.getModeForParameter(parameter);
        if (EPOSEnumerations.EposMode.CURRENT.equals((Object)eposMode)) {
            paramsToChange = this.paramsForCurrent;
            paramsToChangeName = "paramsForCurrent";
        } else if (EPOSEnumerations.EposMode.PROFILE_POSITION.equals((Object)eposMode)) {
            paramsToChange = this.paramsForProfilePosition;
            paramsToChangeName = "paramsForProfilePosition";
        } else if (EPOSEnumerations.EposMode.HOMING.equals((Object)eposMode)) {
            paramsToChange = this.paramsForHoming;
            paramsToChangeName = "paramsForHoming";
        } else {
            throw new IllegalArgumentException(key + " no parameter list is defined for mode: " + (Object)((Object)eposMode));
        }
        paramsToChange.put(key, value);
        this.getComponentConfigurationEnvironment().change(paramsToChangeName, paramsToChange);
        FCSCst.FCSLOG.info((Object)(this.getName() + ":changed EPOS parameter " + key + "for mode " + (Object)((Object)eposMode)));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Reads the EPOS mode in the CPU of the EPOS device and updates the field mode.")
    public EPOSEnumerations.EposMode readMode() {
        try {
            EPOSEnumerations.EposMode readMode;
            String modeInHexa = this.readSDO("6061", "0").trim().toUpperCase();
            this.mode = readMode = EPOSEnumerations.EposMode.getMode(modeInHexa);
            return readMode;
        }
        catch (CanOpenCallTimeoutException ex) {
            String msg = this.getName() + ":" + FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT.getLongDescription() + " to command: readMode - POWER FAILURE ? ";
            this.raiseWarning(this.getName() + ":" + FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT.getLongDescription(), msg + ex);
            return this.mode;
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Changes EPOS mode in the CPU of the EPOS device and updates the field mode.")
    public void changeMode(EPOSEnumerations.EposMode newMode) {
        this.writeSDO("6060", "0", "1", newMode.getModeInHexa());
        this.mode = newMode;
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="This methods reads in the CPU of the EPOS the values of the parameters for a given mode.")
    public String readParameters(String modeInString) {
        return this.readParameters(EPOSEnumerations.EposMode.valueOf(modeInString));
    }

    @Override
    public String readParameters(EPOSEnumerations.EposMode aMode) {
        EPOSEnumerations.Parameter[] params;
        String modeIS = aMode.toString();
        StringBuilder sb = new StringBuilder(this.getName() + " parameters VALUES in decimal format for mode ");
        sb.append(modeIS);
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = aMode.getParameters()) {
            sb.append(param.toString());
            sb.append("=");
            int valueInt = this.readParameter(param);
            sb.append(valueInt);
            sb.append("\n");
        }
        FCSCst.FCSLOG.debug((Object)(this.getName() + sb.toString()));
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the parameters for the actual mode.")
    public String readParameters() {
        return this.readParameters(this.readMode().toString());
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="This methods writes in the CPU of the EPOS device the values of the parameters set for the mode.")
    public void writeParameters() {
        this.readMode();
        this.writeParameters(this.mode);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="This methods writes in the CPU of the EPOS device the values of the parameters set for the mode given as argument")
    public void writeParameters(EPOSEnumerations.EposMode mode) {
        String modeIS = mode.toString();
        Map<String, Integer> paramsMap = null;
        switch (mode) {
            case HOMING: {
                paramsMap = this.paramsForHoming;
                break;
            }
            case PROFILE_POSITION: {
                paramsMap = this.paramsForProfilePosition;
                break;
            }
            case CURRENT: {
                paramsMap = this.paramsForCurrent;
                break;
            }
            default: {
                assert (false) : mode;
                break;
            }
        }
        if (paramsMap == null) {
            throw new EPOSConfigurationException(this.getName() + "parameters for mode :" + modeIS + "are NULL");
        }
        if (paramsMap.isEmpty()) {
            throw new EPOSConfigurationException(this.getName() + "parameters for mode :" + modeIS + "are not defined.");
        }
        this.writeParameters(paramsMap);
    }

    @Override
    public void writeParameters(Map<String, Integer> paramMap) {
        for (Map.Entry<String, Integer> entry : paramMap.entrySet()) {
            String paramName = entry.getKey();
            int value = entry.getValue();
            this.writeParam(paramName, value);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Set EPOS parameter with the value given as argument.")
    public String writeParameter(String parameterName, int value) {
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.valueOf(parameterName);
        this.writeSDO(param.getIndex(), param.getSubindex(), param.getSize(), Integer.toHexString(value));
        return String.format("%s has been written to the CanEpos CPU, value=%d", param.toString(), value);
    }

    private void writeParam(String parameterName, int value) {
        this.writeParameter(EPOSEnumerations.Parameter.valueOf(parameterName), value);
    }

    @Override
    public void writeParameter(EPOSEnumerations.Parameter param, int value) {
        this.writeSDO(param.getIndex(), param.getSubindex(), param.getSize(), Integer.toHexString(value));
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Set EPOS parameter with the hexadecimal value given as argument.")
    public void writeParameterInHexa(String parameterName, String hexaValue) {
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.valueOf(parameterName);
        this.writeParameterInHexa(param, hexaValue);
    }

    @Override
    public void writeParameterInHexa(EPOSEnumerations.Parameter param, String hexaValue) {
        this.writeSDO(param.getIndex(), param.getSubindex(), param.getSize(), hexaValue);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Reads in the EPOS CPU the decimal value of the Parameter which parameter name is given as argument.")
    public int readParameter(String parameterName) {
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.valueOf(parameterName);
        return this.readParameter(param);
    }

    public int readParameter(EPOSEnumerations.Parameter param) {
        try {
            String valueInHexa = this.readSDO(param.getIndex(), param.getSubindex());
            int valueInDecimal = new BigInteger(valueInHexa, 16).intValue();
            FCSCst.FCSLOG.debug((Object)(this.getName() + " readParameter:" + param.name() + "=" + valueInDecimal + " in decimal format  (valueInHexa=" + valueInHexa + ")"));
            return valueInDecimal;
        }
        catch (SDORequestException | ShortResponseToSDORequestException ex) {
            String msg = this.getName() + " Error in reading Parameter: " + (Object)((Object)param);
            this.raiseWarning(this.getName(), msg, ex);
            return 0;
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Reads in the EPOS CPU the hexadecimal value of the Parameter which parameter name is given as argument.")
    protected String readParameterInHexa(String parameterName) {
        return this.readParameterInHexa(EPOSEnumerations.Parameter.valueOf(parameterName));
    }

    protected String readParameterInHexa(EPOSEnumerations.Parameter param) {
        return this.readSDO(param.getIndex(), param.getSubindex());
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read controller's parameter in the CPU for each mode and warn if a parameter has not the same value as in the configuration.Then publish data.")
    public void initializeAndCheckHardware() {
        this.checkBooted();
        this.mode = this.readMode();
        this.parametersOK = true;
        this.checkParameters(EPOSEnumerations.EposMode.CURRENT);
        this.checkParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.checkParameters(EPOSEnumerations.EposMode.HOMING);
        this.checkFault();
        this.initialized = true;
        if (!this.parametersOK) {
            FCSCst.FCSLOG.warning((Object)(this.getName() + " Some parameter values are not the same in CPU and configuration system."));
        }
        this.tcpProxy.publishHardwareData(this);
        this.publishData();
        FCSCst.FCSLOG.info((Object)(this.getName() + ": is INITIALIZED."));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the controller is enabled.")
    public boolean isEnabled() {
        try {
            String statusWordInHexa = this.readStatusWord();
            int statusWord = Integer.parseInt(statusWordInHexa, 16);
            int[] statusWordInBinary = FcsUtils.toReverseBinary(statusWord);
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":statusWordInBinary[0]=" + statusWordInBinary[0]));
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":statusWordInBinary[1]=" + statusWordInBinary[1]));
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":statusWordInBinary[2]=" + statusWordInBinary[2]));
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":statusWordInBinary[3]=" + statusWordInBinary[3]));
            return statusWordInBinary[0] == 1 && statusWordInBinary[1] == 1 && statusWordInBinary[2] == 1 && statusWordInBinary[3] == 0;
        }
        catch (ShortResponseToSDORequestException ex) {
            String msg = this.getName() + " couldn't read status word because ShortResponseToSDORequestException :" + ex.getMessage();
            FCSCst.FCSLOG.error((Object)msg);
            FCSCst.FCSLOG.error((Object)ex);
            throw new FcsHardwareException(msg, ex);
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="This methods enables the controller : i.e. this makes it able to receive commands.")
    public void enable() {
        this.shutdownEPOS();
        this.switchOnEnableOperation();
        this.checkEnabled();
    }

    private void checkEnabled() {
        long timeout = 500L;
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        while (!this.isEnabled() && duration <= timeout) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " is not enabled yet."));
            duration = timeStart - System.currentTimeMillis();
        }
        if (!this.isEnabled()) {
            String statusWord = this.readStatusWord();
            FCSCst.FCSLOG.info((Object)(this.getName() + " NOT ENABLED StatusWord=" + statusWord));
            throw new FcsHardwareException(this.getName() + " couldn't be enabled");
        }
    }

    @Override
    public void checkTargetReached(long timeout) {
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        while (!this.isTargetReached() && duration <= timeout) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " target is not yet reached."));
            duration = timeStart - System.currentTimeMillis();
        }
        if (!this.isTargetReached()) {
            String msg = this.getName() + " couldn't reach target during time allocated of " + timeout + " ms";
            FCSCst.FCSLOG.info((Object)msg);
            throw new FcsHardwareException(msg);
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Shutdown the controller.")
    public void shutdownEPOS() {
        this.writeControlWord("6");
        this.enabledToPublish = false;
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": is SHUTDOWN."));
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="writeControlWord(\"F\")")
    public void switchOnEnableOperation() {
        this.writeControlWord("F");
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Restore default parameters. AT YOUR OWN RISK.")
    public void restoreParameters() {
        this.writeSDO("1011", "1", "4", "64616F6C");
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Write a value in hexa in the control world (index=6040, subindex=0,size=2)")
    public void writeControlWord(String value) {
        this.writeSDO("6040", "0", "2", value);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the control world (index=6040, subindex=0,size=2)")
    public String readControlWord() {
        return this.readSDO("6040", "0");
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read the status world (index=6041, subindex=0,size=2)")
    public String readStatusWord() {
        return this.readSDO("6041", "0");
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="QuickStop.")
    public void quickStop() {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " running QUICKSTOP command."));
        if (this.mode.equals((Object)EPOSEnumerations.EposMode.HOMING) || this.mode.equals((Object)EPOSEnumerations.EposMode.PROFILE_POSITION) || this.mode.equals((Object)EPOSEnumerations.EposMode.VELOCITY)) {
            this.writeControlWord("B");
        } else if (this.mode.equals((Object)EPOSEnumerations.EposMode.CURRENT)) {
            this.writeControlWord("2");
        } else {
            throw new IllegalArgumentException(this.getName() + " has invalid Epos mode:" + (Object)((Object)this.mode));
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Turn OFF controller (in mode CURRENT, stop CURRENT) and shutdown.")
    public void off() {
        switch (this.mode) {
            case HOMING: {
                this.writeControlWord("11F");
                break;
            }
            case PROFILE_POSITION: {
                this.writeControlWord("10F");
                break;
            }
            case CURRENT: {
                this.stopCurrent();
                break;
            }
            default: {
                assert (false) : this.mode;
                break;
            }
        }
        this.shutdownEPOS();
        this.turnedOff = true;
        FCSCst.FCSLOG.info((Object)(this.getName() + " is TURNED OFF"));
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Sent current to controller the EPOS CPU. UNIT=mA / FORMAT=decimal")
    public void writeCurrent(int aValue) {
        if (!EPOSEnumerations.EposMode.CURRENT.equals((Object)this.mode)) {
            throw new RejectedCommandException(this.getName() + " is not in CURRENT mode.");
        }
        this.writeSDO("2030", "0", "2", Integer.toHexString(aValue));
        this.turnedOff = false;
        FCSCst.FCSLOG.info((Object)(this.getName() + ": sent current to controller=" + aValue));
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Enables controller and sets the current value in the EPOS CPU.")
    public void enableAndWriteCurrent(int aValue) {
        this.enable();
        this.checkCurrentValue(aValue);
        this.changeMode(EPOSEnumerations.EposMode.CURRENT);
        this.writeCurrent(aValue);
    }

    protected void checkCurrentValue(int aValue) {
        if (aValue > this.readParameter("ContinuousCurrentLimit")) {
            throw new IllegalArgumentException(aValue + " is greater than ContinuousCurrentLimit.");
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, alias="readCurrentActualValue", description="In Current Mode this methods returns the current actualy received by the motor.")
    public int readCurrent() {
        String currentInHexa = this.readSDO("6078", "0");
        int uns16 = Integer.parseInt(currentInHexa, 16);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":readCurrent=" + FcsUtils.convertToInteger16(uns16) + " Unsigned value read=" + uns16));
        return FcsUtils.convertToInteger16(uns16);
    }

    @Command(type=Command.CommandType.QUERY, level=1, alias="readCurrentAverage", description="In Current Mode this methods returns the average of the current  received by the motor.")
    public int readCurrentAverageValue() {
        String currentInHexa = this.readSDO("2027", "0");
        int uns16 = Integer.parseInt(currentInHexa, 16);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":readAverageCurrent=" + FcsUtils.convertToInteger16(uns16) + " Unsigned value read=" + uns16));
        return FcsUtils.convertToInteger16(uns16);
    }

    public void stopCurrent() {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.CURRENT)) {
            throw new RejectedCommandException(this.getName() + "is not in CURRENT mode");
        }
        this.writeSDO("2030", "00", "2", "0");
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, alias="readPositionActualValue", description="In PROFILE_POSITION Mode this methods returns the actual position.")
    public int readPosition() {
        int positionActualValue = this.readParameter(EPOSEnumerations.Parameter.PositionActualValue);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":readPosition=" + positionActualValue));
        return positionActualValue;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read the position returned by the absolute encoder (single serial data).")
    public int readSSIPosition() {
        return this.readParameter(EPOSEnumerations.Parameter.SSIEncoderActualPosition);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="In PROFILE_POSITION returns the value of the parameter ProfileVelocity.")
    public int readProfileVelocity() {
        int profileVelocity = this.readParameter(EPOSEnumerations.Parameter.ProfileVelocity);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":readProfileVelocity=" + profileVelocity));
        return profileVelocity;
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Define the actual position as position given as argument.")
    public void defineAbsolutePosition(int position) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " Defining Absolute Position:" + position));
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameters(EPOSEnumerations.EposMode.HOMING);
        this.writeParameter(EPOSEnumerations.Parameter.HomePosition, position);
        this.writeParameter(EPOSEnumerations.Parameter.HomingMethod, 35);
        this.enable();
        this.writeControlWord("3F");
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position. Target position has to be given in microns.")
    public void writeTargetPosition(int aValue) {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new RejectedCommandException(this.getName() + " is not in PROFILE_POSITION mode");
        }
        String targetPositionInHexa = Integer.toHexString(aValue);
        this.writeSDO("607A", "0", "4", targetPositionInHexa);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="In HOMING mode and PROFILE_POSITION mode this indicates that the position is reached.")
    public boolean isTargetReached() {
        String statusWordInHexa = this.readStatusWord();
        int statusWord = Integer.parseInt(statusWordInHexa, 16);
        int[] statusWordInBinary = FcsUtils.toReverseBinary(statusWord);
        return statusWordInBinary[10] == 1;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the Controller is in fault.")
    public void checkFault() {
        this.checkBooted();
        if (this.readNumberOfErrors() > 0) {
            this.inError = true;
            String errorInHexa = this.readErrorRegister();
            this.errorRegister = CanOpenErrorsTable.getErrorRegisterNameByCode(errorInHexa);
            this.errorHistory = this.readErrorHistoryNames();
            this.setChanged();
            this.notifyObservers(new Module.ValueUpdate((Module)this, this.getName(), (Object)"inFault"));
            this.publishData();
            String errorHistoryString = this.displayErrorHistory();
            throw new FcsHardwareException(this.getName() + " is in fault. " + errorHistoryString);
        }
        this.resetErrorAndNotifyObservers();
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Clear faults on the controller.", alias="resetFault")
    public void faultReset() {
        this.writeControlWord("80");
        this.resetErrorAndNotifyObservers();
    }

    private void resetErrorAndNotifyObservers() {
        this.resetError();
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.getName(), (Object)"faultReset"));
        this.publishData();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="For every parameter to be defined for this mode this method compares the values in configuration with the value stored in controller CPUand throws a HardwareException if these values are not equal.")
    public void checkParameters(EPOSEnumerations.EposMode aMode) {
        Map<String, Integer> paramsMap = null;
        switch (aMode) {
            case HOMING: {
                paramsMap = this.paramsForHoming;
                break;
            }
            case PROFILE_POSITION: {
                paramsMap = this.paramsForProfilePosition;
                break;
            }
            case CURRENT: {
                paramsMap = this.paramsForCurrent;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (paramsMap == null) {
            throw new FcsHardwareException(this.getName() + "parameters for mode :" + aMode.toString() + "are NULL in configuration system.");
        }
        if (paramsMap.isEmpty()) {
            throw new FcsHardwareException(this.getName() + "parameters for mode :" + aMode.toString() + "are not defined in configuration system.");
        }
        this.checkParameters(paramsMap);
    }

    public void checkParameters(Map<String, Integer> paramsMap) {
        boolean errorFound = false;
        for (Map.Entry<String, Integer> entry : paramsMap.entrySet()) {
            String paramName = entry.getKey();
            int configValue = entry.getValue();
            int controllerValue = 0;
            try {
                controllerValue = this.readParameter(paramName);
            }
            catch (CanOpenCallTimeoutException ex) {
                String cause = this.getName() + ":" + FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT.getLongDescription() + " to command: checkParameters - POWER FAILURE ? ";
                this.raiseWarning(this.getName() + ":" + FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT.getLongDescription(), cause + ex);
            }
            if (configValue == controllerValue) continue;
            String cause = paramName + " value found in configuration=" + configValue + " value read in CPU=" + controllerValue + "\n";
            this.raiseWarning(this.getName() + ":" + FcsEnumerations.FcsAlert.PARAMETER_ERROR, FcsEnumerations.FcsAlert.PARAMETER_ERROR.getLongDescription(), cause);
            errorFound = true;
        }
        this.parametersOK = !errorFound;
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Change mode to CURRENT mode and initialize theCURRENT mode parameters from configuration values.")
    public void activateCurrentMode() {
        this.changeMode(EPOSEnumerations.EposMode.CURRENT);
        this.writeParameters(this.paramsForCurrent);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Change mode to HOMING mode and initialize theHOMING mode parameters from configuration values.")
    public void activateHomingMode() {
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameters(this.paramsForHoming);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Change mode to PROFILE_POSITION mode and initialize thePROFILE_POSITION mode parameters from configuration values.")
    public void activateProfilePositionMode() {
        this.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.writeParameters(this.paramsForProfilePosition);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Shutdowns the controller.")
    public void disable() {
        this.shutdownEPOS();
        this.publishData();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, alias="refreshGUI", description="Publish data for the controller on the status bus.")
    public void publishData() {
        super.publishData();
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)this.createStatusDataPublishedByEPOSController()));
    }
}

