/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.Sensor;
import org.lsst.ccs.subsystems.fcs.errors.SensorValueOutOfRangeException;

public abstract class Sensor14bits
extends Module
implements Sensor {
    protected int value;
    private volatile boolean updatingValue = false;
    private final Lock lock = new ReentrantLock();
    private final Condition valueUpdated = this.lock.newCondition();

    public Sensor14bits(int aTickMillis) {
        super(aTickMillis);
    }

    public void initModule() {
        this.updatingValue = false;
        this.value = 0;
    }

    @Override
    public int getValue() {
        this.lock.lock();
        try {
            while (this.updatingValue) {
                try {
                    this.valueUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.getName() + ex.getMessage()));
                }
            }
            int n = this.value;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void updateValue() {
        this.lock.lock();
        try {
            this.updatingValue = true;
            int newValue = this.readNewValue();
            if (newValue < 0 || newValue > Short.MAX_VALUE) {
                throw new SensorValueOutOfRangeException("ERROR in Sensor14bits during updateValue for ", this.name, 0, Short.MAX_VALUE, newValue);
            }
            this.value = newValue;
        }
        finally {
            this.updatingValue = false;
            this.valueUpdated.signal();
            this.lock.unlock();
        }
    }

    public abstract int updateValue(PDOStorage var1);

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns the value of the sensor stored in FCS memory. Doesn't read again the ADC device.")
    public String printValue() {
        return Integer.toString(this.value);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns a printed format of this sensor.")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/returned value=");
        sb.append(Integer.toString(this.value));
        return sb.toString();
    }
}

