/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.Map;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;

public interface EPOSController
extends PieceOfHardware {
    public boolean isTurnedOff();

    public void off();

    public boolean isParametersOK();

    public void changeMode(EPOSEnumerations.EposMode var1);

    @Command(type=Command.CommandType.ACTION, level=1, description="Defines the actual position as the absolute position which value is given as an argument.")
    public void defineAbsolutePosition(int var1);

    public int readNumberOfErrors();

    public String displayErrorHistory();

    public void checkFault();

    public void faultReset();

    public void writeParameters(EPOSEnumerations.EposMode var1);

    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position.")
    public void writeTargetPosition(int var1);

    public void writeParameters(Map<String, Integer> var1);

    @Command(type=Command.CommandType.ACTION, level=1, description="In current mode this methods send a current to the motor.")
    public void writeCurrent(int var1) throws EPOSConfigurationException;

    @Command(type=Command.CommandType.ACTION, level=1, description="Enable, set mode CURRENT and write current.")
    public void enableAndWriteCurrent(int var1);

    public int readPosition();

    public int readSSIPosition();

    public int readCurrent();

    public String readParameters(EPOSEnumerations.EposMode var1);

    public int readProfileVelocity();

    public void enable();

    public boolean isEnabled();

    public EPOSEnumerations.EposMode readMode();

    public void quickStop();

    public void checkParameters(EPOSEnumerations.EposMode var1) throws HardwareException;

    public void writeControlWord(String var1);

    public void shutdownEPOS();

    public boolean isTargetReached();

    public void checkTargetReached(long var1);

    public void switchOnEnableOperation();

    public EPOSEnumerations.EposMode getMode();

    public boolean isEnabledToPublish();

    public boolean isInError();

    public String getErrorRegister();

    public String[] getErrorHistory();

    public void writeParameterInHexa(EPOSEnumerations.Parameter var1, String var2);

    public void disable();

    @Command(type=Command.CommandType.ACTION, level=3, description="Enable controller and go to absolute position. Doesn't check condition. DANGER !!!! ")
    default public void enableAndWriteAbsolutePosition(int pos) {
        this.enable();
        this.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.writeTargetPosition(pos);
        this.writeControlWord("3F");
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Enable controller and go to relative position. Doesn't check condition. DANGER !!!! ")
    default public void enableAndWriteRelativePosition(int pos) {
        this.enable();
        this.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.writeTargetPosition(pos);
        this.writeControlWord("7F");
    }

    default public StatusDataPublishedByEPOSController createStatusDataPublishedByEPOSController() {
        StatusDataPublishedByEPOSController status = new StatusDataPublishedByEPOSController(this.getName(), this.isBooted(), this.isInitialized());
        status.setInError(this.isInError());
        status.setErrorRegister(this.getErrorRegister());
        status.setErrorHistory(this.getErrorHistory());
        status.setEnabled(this.isEnabledToPublish());
        status.setMode(this.getMode());
        return status;
    }

    public void writeParameter(EPOSEnumerations.Parameter var1, int var2);

    public String readStatusWord();

    public boolean isInMode(EPOSEnumerations.EposMode var1);
}

