/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.UsesSubsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;

public interface AlertRaiser
extends UsesSubsystem {
    default public void raiseAlarm(String fcsErrorID, String message, String cause) {
        FCSCst.FCSLOG.error((Object)(fcsErrorID + message + cause));
        this.getSubsystem().raiseAlert(new Alert(fcsErrorID, message), AlertState.ALARM, cause);
    }

    default public void raiseAlarm(FcsEnumerations.FcsAlert fcsAlert, String cause) {
        this.raiseAlarm(fcsAlert.name(), fcsAlert.getLongDescription(), cause);
    }

    default public void raiseAlarm(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName) {
        this.raiseAlarm(deviceName + '/' + fcsAlert.name(), fcsAlert.getLongDescription(), cause);
    }

    default public void raiseAlarm(String fcsErrorID, String message, Exception ex) {
        FCSCst.FCSLOG.error((Object)message, (Throwable)ex);
        this.getSubsystem().raiseAlert(new Alert(fcsErrorID, message), AlertState.ALARM, message + ex);
    }

    default public void raiseWarning(String fcsErrorID, String message, String cause) {
        FCSCst.FCSLOG.warning((Object)message);
        this.getSubsystem().raiseAlert(new Alert(fcsErrorID, message), AlertState.WARNING, cause);
    }

    default public void raiseWarning(FcsEnumerations.FcsAlert fcsAlert, String cause) {
        this.raiseWarning(fcsAlert.name(), fcsAlert.getLongDescription(), cause);
    }

    default public void raiseWarning(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName) {
        this.raiseWarning(deviceName + ':' + fcsAlert.name(), fcsAlert.getLongDescription(), cause);
    }

    default public void raiseWarning(String fcsErrorID, String message, Exception ex) {
        FCSCst.FCSLOG.warning((Object)message);
        this.getSubsystem().raiseAlert(new Alert(fcsErrorID, message), AlertState.WARNING, message + ex);
    }
}

