/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;

public class FilterIdentificator
extends Module {
    @ConfigurationParameter(isFinal=true)
    private String plutoGatewayName;
    private static final int SENSORS_NUMBER = 6;
    private final ArrayList<DigitalSensor> filterIDSensors = new ArrayList();
    private final boolean[] sensorsValues;
    private final char[] chars;
    private PlutoGatewayInterface plutoGateway;
    private final Lock lock = new ReentrantLock();
    private final Condition stateUpdated = this.lock.newCondition();

    public FilterIdentificator(String gwName) {
        this.plutoGatewayName = gwName;
        this.sensorsValues = new boolean[6];
        this.chars = new char[6];
        for (int i = 0; i < 6; ++i) {
            this.sensorsValues[i] = false;
            this.chars[i] = 48;
        }
    }

    public List<DigitalSensor> getFilterIDSensors() {
        return (List)this.filterIDSensors.clone();
    }

    public void initModule() {
        this.plutoGateway = (PlutoGatewayInterface)this.getComponentLookup().getComponentByName(this.plutoGatewayName);
        Map cosMap = this.getSubsystem().getComponentLookup().getChildren(this.getName(), DigitalSensor.class);
        this.filterIDSensors.addAll(cosMap.values());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read hall effect sensors, compute filter number and return it.")
    public int readFilterIdentifier() {
        this.updateSensorsValues();
        return this.computeFilterID();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read filter ID sensors and update values.")
    public void updateSensorsValues() {
        this.lock.lock();
        try {
            this.plutoGateway.updateValues();
            this.updateSensorsValues(this.plutoGateway.getHexaValues());
        }
        finally {
            this.stateUpdated.signal();
            this.lock.unlock();
        }
    }

    public void updateSensorsValues(String[] readHexaValues) {
        FCSCst.FCSLOG.finest((Object)Arrays.toString(readHexaValues));
        for (int i = 0; i < 6; ++i) {
            this.filterIDSensors.get(i).updateValue(readHexaValues);
            this.sensorsValues[i] = this.filterIDSensors.get(i).isOn();
        }
        this.update(this.sensorsValues);
    }

    private void update(boolean[] values) {
        for (int i = 0; i < 6; ++i) {
            this.chars[5 - i] = values[i] ? 49 : 48;
        }
    }

    private int computeFilterID() {
        return Integer.parseInt(new String(this.chars), 2);
    }

    public String toString() {
        return String.valueOf(this.chars);
    }
}

