/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.subsystems.fcs.CarouselClampModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselSocket;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.errors.ClampsOrLatchesDisagreeException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CarouselSocket
extends MobileItemModule
implements ClearAlertHandler {
    private BridgeToHardware bridge;
    private CarouselClampModule clampXminus;
    private CarouselClampModule clampXplus;
    private EPOSController clampActuatorXminus;
    private EPOSController clampActuatorXplus;
    private FilterHolder autochanger;
    @ConfigurationParameter(range="-360..360")
    private int positionOnCarousel;
    @ConfigurationParameter(range="-360..360")
    private int standbyPosition;
    private Filter filter;
    private volatile boolean updatingClamps = false;
    private volatile FcsEnumerations.FilterClampState clampsState = FcsEnumerations.FilterClampState.UNDEFINED;
    private final Condition stateUpdated = this.lock.newCondition();
    private long timeoutForUnlocking = 4000L;
    private long timeoutForReleasing = 4000L;

    public CarouselSocket(CarouselClampModule clampXminus, CarouselClampModule clampXplus, int position, int standbyPosition) {
        super(5000);
        this.clampXminus = clampXminus;
        this.clampXplus = clampXplus;
        this.positionOnCarousel = position;
        this.standbyPosition = standbyPosition;
    }

    public CarouselClampModule getClampXminus() {
        return this.clampXminus;
    }

    public void setClampXminus(CarouselClampModule clampXminus) {
        this.clampXminus = clampXminus;
    }

    public CarouselClampModule getClampXplus() {
        return this.clampXplus;
    }

    public void setClampXplus(CarouselClampModule clampXplus) {
        this.clampXplus = clampXplus;
    }

    public int getActualPosition() {
        return FcsUtils.addAngle(this.positionOnCarousel, this.getCarouselPosition());
    }

    public int getCarouselPosition() {
        return ((CarouselModule)this.getComponentLookup().getComponentByName("carousel")).getPosition();
    }

    public int getPositionOnCarousel() {
        return this.positionOnCarousel;
    }

    public Filter getFilter() {
        return this.filter;
    }

    private void setFilter(Filter filter) {
        this.filter = filter;
    }

    public int getStandbyPosition() {
        return this.standbyPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if this socket is at STANDBY position on the carousel.")
    public boolean isAtStandby() {
        return this.getCarouselPosition() == this.standbyPosition;
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getComponentLookup();
        this.bridge = (BridgeToHardware)lookup.getComponentByName("tcpProxy");
        this.clampActuatorXminus = (EPOSController)lookup.getComponentByName("clampXminusController");
        this.clampActuatorXplus = (EPOSController)lookup.getComponentByName("clampXplusController");
        this.timeoutForReleasing = Math.max(this.clampXminus.timeoutForReleasing, this.clampXplus.timeoutForReleasing);
        this.timeoutForUnlocking = Math.max(this.clampXminus.timeoutForUnlocking, this.clampXplus.timeoutForUnlocking);
        if (!(lookup.getComponentByName("autochanger") instanceof FilterHolder)) {
            String MSG = this.getName() + " ==> autochanger doesn't implements FilterHolder - Please fix groovy description file or Main Module implementation.";
            FCSLOG.error((Object)MSG);
            throw new IllegalArgumentException(MSG);
        }
        this.autochanger = (FilterHolder)lookup.getComponentByName("autochanger");
        this.clampXminus.setController(this.clampActuatorXminus);
        this.clampXplus.setController(this.clampActuatorXplus);
    }

    private boolean isAutochangerHoldingFilter() {
        return this.autochanger.isAtStandby() && this.autochanger.isHoldingFilter();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hardware is connected and ready.")
    public boolean isCANDevicesReady() {
        return ((MainModule)this.getComponentLookup().getComponentByName("main")).isCANDevicesReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return clamps state - doesn't read again sensors.")
    public FcsEnumerations.FilterClampState getClampsState() {
        this.lock.lock();
        try {
            while (this.updatingClamps) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.warning((Object)(this.getName() + " was interrupted during getClampsState."));
                }
            }
            FcsEnumerations.FilterClampState filterClampState = this.clampsState;
            return filterClampState;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    public void updateClampsStateWithSensorsFromSDO() {
        block4: {
            this.lock.lock();
            this.updatingClamps = true;
            try {
                this.clampXminus.updateStateWithSensorsFromSDO();
                this.clampXplus.updateStateWithSensorsFromSDO();
                if (this.clampXminus.getClampState() == this.clampXplus.getClampState()) {
                    this.clampsState = this.clampXminus.getClampState();
                    break block4;
                }
                throw new FcsHardwareException("Error in filter presence detection at standby position : the clamps don't agree.");
            }
            finally {
                this.updatingClamps = false;
                this.stateUpdated.signal();
                this.lock.unlock();
            }
        }
    }

    public void updateClampsStateWithSensors(PDOStorage pdoStorage) {
        block4: {
            this.lock.lock();
            this.updatingClamps = true;
            try {
                this.clampXminus.updateStateWithSensors(pdoStorage);
                this.clampXplus.updateStateWithSensors(pdoStorage);
                if (this.clampXminus.getClampState() == this.clampXplus.getClampState()) {
                    this.clampsState = this.clampXminus.getClampState();
                    FCSLOG.info((Object)(this.getName() + " : clamps are updated"));
                    break block4;
                }
                String msg = this.getName() + ":Error in carousel at standby position : \nclampState at Xminus side is different from clampState at Xplus side.";
                msg = msg + this.clampXminus.getName() + " state=" + this.clampXminus.getClampState();
                msg = msg + this.clampXplus.getName() + " state=" + this.clampXplus.getClampState();
                this.raiseAlarm(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, msg);
                throw new ClampsOrLatchesDisagreeException(msg);
            }
            finally {
                this.updatingClamps = false;
                this.stateUpdated.signal();
                this.lock.unlock();
            }
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Update clamps state in reading sensors.")
    public void updateClampsStateWithSensors() {
        FCSLOG.debug((Object)("updateClampsStateWithSensors/" + this.getName() + "/bridge=" + this.bridge.toString()));
        this.updateClampsStateWithSensors(this.bridge.readPDOs());
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is no filter in the socket.")
    public boolean isEmpty() {
        return this.clampsState == FcsEnumerations.FilterClampState.READYTOCLAMP || this.clampsState == FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is a filter in the socket and the clampsare LOCKED.")
    public boolean isClampedOnFilter() {
        return this.clampsState == FcsEnumerations.FilterClampState.CLAMPEDONFILTER;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is a filter in the socket and the clampsare UNLOCKED.")
    public boolean isUnclampedOnFilter() {
        return this.clampsState == FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is NO filter in the socket and the clampsare UNLOCKED.")
    public boolean isUnclampedEmpty() {
        return this.clampsState == FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if this socket is ready to clamp a filter.")
    public boolean isReadyToClamp() {
        return this.clampsState == FcsEnumerations.FilterClampState.READYTOCLAMP;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Release the 2 clamps of this socket if the socket is at STANDBY position.")
    public void releaseClamps() {
        this.updateClampsStateWithSensors();
        FCSLOG.info((Object)("Checking conditions for release clamp " + this.getName() + " on socket at standby position."));
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.getName() + " is NOT AT STANDBY - can't unlock clamps.");
        }
        if (this.clampsState != FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY) {
            FCSLOG.fine((Object)(this.getName() + " clampsState=" + this.clampsState));
            FCSLOG.fine((Object)(this.clampXminus.getName() + " clampState=" + this.clampXminus.getClampState()));
            FCSLOG.finest((Object)(this.clampXminus.getName() + " lockStatus=" + this.clampXminus.getLockStatus()));
            FCSLOG.finest((Object)(this.clampXminus.getName() + " filterPresenceStatus=" + this.clampXminus.getFilterPresenceStatus()));
            FCSLOG.fine((Object)(this.clampXplus.getName() + " clampState=" + this.clampXplus.getClampState()));
            FCSLOG.finest((Object)(this.clampXplus.getName() + " lockStatus=" + this.clampXplus.getLockStatus()));
            FCSLOG.finest((Object)(this.clampXplus.getName() + " filterPresenceStatus=" + this.clampXplus.getFilterPresenceStatus()));
            throw new RejectedCommandException(this.getName() + ": Can't release clamps if socket is not UNCLAMPED and EMPTY. ");
        }
        FCSLOG.info((Object)(this.getName() + ": Releasing clamps at standby position."));
        this.executeAction(FcsEnumerations.MobileItemAction.RELEASECLAMPS, this.timeoutForReleasing);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlock the 2 clamps of this socket if the socket is at STANDBY position.")
    public void unlockClamps() {
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.getName() + " is NOT AT STANDBY - can't unlock clamps.");
        }
        this.updateClampsStateWithSensors();
        if (this.clampsState != FcsEnumerations.FilterClampState.CLAMPEDONFILTER) {
            throw new RejectedCommandException(this.getName() + ":Can't unlock clamps if isn't clamped on filter.");
        }
        if (!this.isAutochangerHoldingFilter()) {
            throw new RejectedCommandException("CANNOT UNLOCK CLAMPS if FILTER is not HELD by autochanger.");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.UNLOCKCLAMPS, this.timeoutForUnlocking);
    }

    public void removeFilter() {
        this.filter.removeFromCarousel();
        this.filter = null;
        this.publishData();
    }

    public synchronized void putFilterOnSocket(Filter filter) {
        this.setFilter(filter);
        this.publishData();
        filter.putFilterOnSocket(this.getName());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns a String representation of a CarouselSocket.")
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.getName()));
        sb.append(",positionOnCarousel:");
        sb.append(this.positionOnCarousel);
        sb.append(",Filter in socket : ");
        if (this.filter == null) {
            sb.append(" NO FILTER").append("\n");
        } else {
            sb.append(this.filter.getName()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.UNLOCKCLAMPS) {
            return this.clampsState == FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER;
        }
        if (action == FcsEnumerations.MobileItemAction.RELEASECLAMPS) {
            return this.clampsState == FcsEnumerations.FilterClampState.READYTOCLAMP;
        }
        throw new IllegalArgumentException("Action on clamps on socket must be UNLOCKCLAMPS or RELEASECLAMPS");
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.updateClampsStateWithSensors();
        }
        catch (ClampsOrLatchesDisagreeException ex) {
            String msg = this.getName() + " a little delai between the update of the 2 clamps : have to wait ...";
            this.raiseWarning("FCS004", msg, ex);
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.UNLOCKCLAMPS) {
            if (!this.clampActuatorXminus.isEnabled()) {
                this.clampActuatorXminus.enable();
            }
            if (!this.clampActuatorXplus.isEnabled()) {
                this.clampActuatorXplus.enable();
            }
            if (!this.clampActuatorXminus.isEnabled()) {
                throw new RejectedCommandException(this.getName() + " ControllerXminus has to be enabled first.");
            }
            if (!this.clampActuatorXplus.isEnabled()) {
                throw new RejectedCommandException(this.getName() + " ControllerXplus has to be enabled first.");
            }
            this.clampActuatorXminus.writeCurrent(this.clampXminus.getCurrentToUnlock());
            this.clampActuatorXplus.writeCurrent(this.clampXplus.getCurrentToUnlock());
        } else if (action == FcsEnumerations.MobileItemAction.RELEASECLAMPS) {
            this.clampActuatorXminus.off();
            this.clampActuatorXplus.off();
        } else {
            throw new IllegalArgumentException("Action on clamps on socket must be UNLOCKCLAMPS or RELEASECLAMPS");
        }
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.UNLOCKCLAMPS) {
            FCSLOG.info((Object)"Just about to remove filter from carousel (software update)");
            this.removeFilter();
            FCSLOG.info((Object)"Command unlockClamps completed");
        }
        this.publishData();
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.info((Object)(this.getName() + " stopAction : nothing to be done."));
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)this.createStatusDataPublishedByCarouselSocket()));
    }

    public StatusDataPublishedByCarouselSocket createStatusDataPublishedByCarouselSocket() {
        StatusDataPublishedByCarouselSocket status = new StatusDataPublishedByCarouselSocket();
        status.setActualPosition(this.getActualPosition());
        status.setAtStandby(this.isAtStandby());
        status.setClampsState(this.clampsState);
        status.setEmpty(this.isEmpty());
        if (this.filter == null) {
            status.setFilterName("NO FILTER");
        } else {
            status.setFilterName(this.filter.getName());
        }
        return status;
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        switch (alert.getAlertId()) {
            case "FCS004": {
                if (this.clampXminus.getClampState() == this.clampXplus.getClampState()) {
                    return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
        }
        return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
    }
}

