/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.CarouselClampModule;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsMainModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.ModuleState;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CarouselModule
extends MobileItemModule
implements HardwareController,
FilterHolder {
    private static final long serialVersionUID = -2376279469784152348L;
    @ConfigurationParameter
    private int rotationTimeout = 20000;
    private int position = 0;
    private int absoluteTargetPosition;
    private int relativeTargetPosition;
    private final int speed;
    private int current = 0;
    private EPOSController clampXminusController;
    private EPOSController clampXplusController;
    private EPOSController carouselController;
    private PieceOfHardware hyttc580;
    protected PieceOfHardware ai814;
    private PieceOfHardware pt100;
    private FilterHolder autochanger;
    protected Map<String, CarouselSocket> socketsMap;
    private BridgeToHardware bridge;
    private volatile ModuleState state = ModuleState.HALTED;
    private boolean initialized = false;

    public CarouselModule() {
        super(5000);
        this.speed = 0;
    }

    public void setRotationTimeout(int rotationTimeout) {
        if (rotationTimeout < 0 || rotationTimeout > 500000) {
            throw new IllegalArgumentException("rotationTimeout must be between 0 and 500000");
        }
        this.rotationTimeout = rotationTimeout;
    }

    @Command(description="Return true if CANopen devices are booted and initialized and homing has been done.")
    boolean isInitialized() {
        return this.isCANDevicesReady();
    }

    public CarouselSocket getSocketByName(String socketName) {
        if (this.socketsMap.containsKey(socketName)) {
            return this.socketsMap.get(socketName);
        }
        throw new IllegalArgumentException(this.getName() + ": no such name for socket:" + socketName);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return carousel position.", alias="printPosition")
    public int getPosition() {
        return this.position;
    }

    public synchronized ModuleState getState() {
        return this.state;
    }

    public synchronized void setState(ModuleState state) {
        this.state = state;
    }

    public EPOSController getClampXminusController() {
        return this.clampXminusController;
    }

    public EPOSController getClampXplusController() {
        return this.clampXplusController;
    }

    public CarouselClampModule getClampXminus() {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            return null;
        }
        return socketAtStandby.getClampXminus();
    }

    public CarouselClampModule getClampXplus() {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            return null;
        }
        return socketAtStandby.getClampXplus();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if a socket is HALTED at STANDBY position, false otherwise.")
    public synchronized boolean isAtStandby() {
        if (this.isRotating()) {
            return false;
        }
        for (CarouselSocket socket : this.socketsMap.values()) {
            if (!socket.isAtStandby()) continue;
            return true;
        }
        return false;
    }

    public synchronized CarouselSocket getSocketAtStandby() {
        if (this.isRotating()) {
            return null;
        }
        for (CarouselSocket socket : this.socketsMap.values()) {
            if (!socket.isAtStandby()) continue;
            return socket;
        }
        return null;
    }

    public synchronized Filter getFilterAtStandby() {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            return null;
        }
        return socketAtStandby.getFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns name of filter at STANDBY position  or NO_FILTER if there is no filter at STANDBY.")
    public synchronized String getFilterAtStandbyName() {
        Filter filterAtStandby = this.getFilterAtStandby();
        if (filterAtStandby == null) {
            return "NO FILTER";
        }
        return filterAtStandby.getName();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if Autochanger is holding filter at STANDBY.")
    public boolean isAutochangerHoldingFilter() {
        this.autochanger.updateStateWithSensors();
        return this.autochanger.isHoldingFilter();
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getSubsystem().getComponentLookup();
        FCSLOG.info((Object)"[CarouselModule] Initializing the carousel module ");
        this.setState(ModuleState.HALTED);
        this.bridge = (BridgeToHardware)lookup.getComponentByName("tcpProxy");
        this.clampXminusController = (EPOSController)lookup.getComponentByName("clampXminusController");
        this.clampXplusController = (EPOSController)lookup.getComponentByName("clampXplusController");
        this.carouselController = (EPOSController)lookup.getComponentByName("carouselController");
        this.hyttc580 = (PieceOfHardware)lookup.getComponentByName("hyttc580");
        this.ai814 = (PieceOfHardware)lookup.getComponentByName("ai814");
        this.pt100 = (PieceOfHardware)lookup.getComponentByName("pt100");
        Map sMap = lookup.getChildren(this.getName(), CarouselSocket.class);
        this.socketsMap = new TreeMap<String, CarouselSocket>();
        for (Map.Entry entry : sMap.entrySet()) {
            FCSLOG.info((Object)("Add socket to sockets Map:" + ((CarouselSocket)entry.getValue()).toString()));
            this.socketsMap.put((String)entry.getKey(), (CarouselSocket)entry.getValue());
        }
        if (!(lookup.getComponentByName("autochanger") instanceof FilterHolder)) {
            String MSG = this.getName() + " ==> autochanger doesn't implements FilterHolder - Please fix groovy description file or CarouselModule implementation.";
            FCSLOG.error((Object)MSG);
            throw new IllegalArgumentException(MSG);
        }
        this.autochanger = (FilterHolder)lookup.getComponentByName("autochanger");
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        try {
            this.carouselController.initializeAndCheckHardware();
            this.ai814.initializeAndCheckHardware();
            this.hyttc580.initializeAndCheckHardware();
            this.pt100.initializeAndCheckHardware();
            this.initialized = true;
            return TreeWalkerDiag.GO;
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
    }

    @Override
    public void checkStarted() throws HardwareException {
        FCSLOG.info((Object)(this.getName() + " BEGIN checkStarted"));
        this.bridge.checkHardware();
        try {
            this.ai814.initializeAndCheckHardware();
            this.updateClampsStateWithSensors();
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
        FCSLOG.info((Object)(this.getName() + " END checkStarted"));
    }

    @Override
    public void checkStopped() throws HardwareException {
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData("carousel", (Serializable)this.createStatusDataPublishedByCarousel()));
    }

    public StatusDataPublishedByCarousel createStatusDataPublishedByCarousel() {
        StatusDataPublishedByCarousel status = new StatusDataPublishedByCarousel();
        status.setName(this.getName());
        status.setRotationInDegrees(this.position);
        status.setLocked(this.isLocked());
        status.setCurrent(this.current);
        status.setSpeed(this.speed);
        if (this.isAtStandby()) {
            status.setAtStandby(true);
            status.setFilterAtStandbyName(this.getFilterAtStandbyName());
            status.setSocketAtStandbyName(this.getSocketAtStandby().getName());
        } else {
            status.setAtStandby(false);
        }
        TreeMap<String, String> mapSocketFilter = new TreeMap<String, String>();
        for (Map.Entry<String, CarouselSocket> entry : this.socketsMap.entrySet()) {
            CarouselSocket socket = entry.getValue();
            if (socket.getFilter() == null) {
                mapSocketFilter.put(socket.getName(), "NO FILTER");
                continue;
            }
            mapSocketFilter.put(socket.getName(), socket.getFilter().getName());
        }
        status.setFiltersOnCamera(mapSocketFilter);
        return status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("\n Numbers of sockets: ");
        sb.append(this.socketsMap.size());
        for (CarouselSocket socket : this.socketsMap.values()) {
            sb.append("\n Socket name ");
            sb.append(String.valueOf(socket.getName()));
            sb.append(" / ");
            sb.append(String.valueOf(socket));
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if Carousel is stopped and no filter is at STANDBY position")
    public boolean isReadyToGrabAFilterAtStandby() {
        if (this.isRotating()) {
            return false;
        }
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            return false;
        }
        return socketAtStandby.isEmpty() && socketAtStandby.isReadyToClamp();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if a filter is clamped at STANDBY position")
    public boolean isHoldingFilterAtStandby() {
        if (this.isRotating()) {
            return false;
        }
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null || socketAtStandby.isEmpty()) {
            return false;
        }
        return socketAtStandby.isClampedOnFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if carousel is rotating.")
    public boolean isRotating() {
        return this.isMoving();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the brake is released")
    public boolean isAbleToMove() {
        return true;
    }

    public boolean isLocked() {
        return true;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Engage the carousel brake to stop the rotation")
    public String engageBrake() {
        return this.getName() + " locked";
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Release the carousel brake")
    public String releaseBrake() {
        return this.getName() + " unlocked";
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update carousel position in reading controller.")
    public void updatePosition() {
        try {
            this.position = this.carouselController.readPosition();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update field current in reading controller.")
    public void updateCurrent() {
        try {
            this.current = this.carouselController.readCurrent();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        this.publishData();
    }

    public void updateClampsStateWithSensorsFromSDO() {
        for (CarouselSocket socket : this.socketsMap.values()) {
            socket.updateClampsStateWithSensors();
        }
    }

    public void updateClampsStateWithSensorsFromPDO() {
        PDOStorage pdoStore = this.bridge.readPDOs();
        FCSLOG.finest((Object)(this.getName() + ":pdoStore=" + pdoStore.toString()));
        for (CarouselSocket socket : this.socketsMap.values()) {
            socket.updateClampsStateWithSensors(pdoStore);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read clamps sensors and update clamps state")
    public void updateClampsStateWithSensors() {
        this.updateClampsStateWithSensorsFromPDO();
    }

    public void tick() {
        this.publishData();
    }

    private synchronized void putFilterOnCarousel(Filter filter) {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            throw new RejectedCommandException(this.getName() + ": there is no socket at standby position to put a filter in.");
        }
        socketAtStandby.putFilterOnSocket(filter);
        this.publishData();
    }

    private int getStandbyPositionForFilter(Filter filter) {
        CarouselSocket socket = this.socketsMap.get(filter.getSocketName());
        if (socket == null) {
            throw new IllegalArgumentException(this.getName() + " no socket name for filter " + filter.getName());
        }
        return socket.getStandbyPosition();
    }

    public String grabFilterAtStandby(String filterName) {
        FcsMainModule fcsMainModule = (FcsMainModule)this.getComponentLookup().getComponentByName("main");
        fcsMainModule.checkFilterName(filterName);
        Filter filterToGrabbe = fcsMainModule.getFilterByName(filterName);
        FCSLOG.info((Object)("Filter to move : " + filterName));
        FCSLOG.info((Object)("Filter location : " + (Object)((Object)filterToGrabbe.getFilterLocation())));
        return this.getName() + this.grabFilterAtStandby(filterToGrabbe);
    }

    public synchronized String grabFilterAtStandby(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(this.getName() + ": grabbeFilterAtStandby must receive a non null argument as a filter");
        }
        if (this.isRotating()) {
            throw new RejectedCommandException(this.getName() + ": grabbeFilterAtStandby can't grabbe a filter while rotating");
        }
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            throw new RejectedCommandException(this.getName() + ": grabbeFilterAtStandby can't be executed because there is no socket at standby position.");
        }
        socketAtStandby.updateClampsStateWithSensors();
        if (socketAtStandby.isEmpty()) {
            throw new RejectedCommandException(this.getName() + ": grabbeFilterAtStandby can't be executed because no filter is detected in socket at standby position.");
        }
        if (socketAtStandby.isClampedOnFilter()) {
            FCSLOG.info((Object)(this.getName() + ": grabbing " + filter.getName() + " at standby position."));
            this.putFilterOnCarousel(filter);
            FCSLOG.info((Object)(this.getName() + ": " + filter.getName() + " is grabbed on carousel."));
            return this.getName() + ": " + filter.getName() + " is grabbed at standby position";
        }
        throw new RejectedCommandException(this.getName() + ": grabbeFilterAtStandby can't be executed because the clamps are not CLAMPED ON FILTER.");
    }

    public void ungrabFilterAtStandby(String filterName) {
        if (filterName == null) {
            throw new IllegalArgumentException("Filter to ungrabb should not be null");
        }
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            throw new RejectedCommandException(this.getName() + ":A socket has to be halted at standby position for this operation.");
        }
        if (!socketAtStandby.isClampedOnFilter()) {
            throw new RejectedCommandException(this.getName() + ": can't ungrabb filter which is already unclamped.");
        }
        FCSLOG.info((Object)(this.getName() + ": ungrabbing " + filterName + " at standby position."));
        this.unlockClamps();
        FCSLOG.info((Object)(this.getName() + ": socket at standby state : " + socketAtStandby.toString()));
        FCSLOG.info((Object)(this.getName() + ": " + filterName + " is ungrabbed from carousel."));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Release clamps at standby position to get ready to clamp again")
    public void releaseClamps() {
        if (this.getSocketAtStandby() == null) {
            throw new RejectedCommandException(this.getName() + ":Can't release clamps when no socket is halted at standby position.");
        }
        this.getSocketAtStandby().releaseClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Unlock the clamps at STANDBY.")
    public void unlockClamps() {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            throw new RejectedCommandException("Can't unlock clamps while a socket is not halted at standby position.");
        }
        FCSLOG.info((Object)"Unlocking clamps at standby.");
        socketAtStandby.unlockClamps();
    }

    public boolean isAtStandby(Filter filter) {
        return this.getPosition() == this.getStandbyPositionForFilter(filter);
    }

    public void releaseClampsContact() {
    }

    public void engageClampsContact() {
    }

    @Override
    public boolean isCANDevicesReady() {
        return this.bridge.isCANDevicesReady() && this.initialized;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if carousel rotation is permitted.")
    public void checkConditionsForRotation() {
        if (!this.initialized) {
            throw new FcsHardwareException("Carousel hardware is not initialized. Can't rotate.");
        }
        if (this.isRotating()) {
            String message = "Carousel is rotating, stop it before sending a new rotate command.";
            FCSLOG.error((Object)message);
            throw new RejectedCommandException(message);
        }
        if (!this.isAbleToMove()) {
            String message = "Carousel is unable to move. Check motor brake.";
            FCSLOG.error((Object)message);
            throw new RejectedCommandException(message);
        }
        this.updateClampsStateWithSensors();
        if (this.isAtStandby() && this.getSocketAtStandby().isUnclampedOnFilter()) {
            String message = "Filter at STANDBY position is not held by clamps. Can't rotate carousel.";
            FCSLOG.error((Object)message);
            throw new RejectedCommandException(message);
        }
        if (!this.autochanger.isAtHandoff()) {
            throw new RejectedCommandException(this.getName() + " can't rotate if autochanger is not at HANDOFF position.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate carousel to an absolute angle.")
    public void rotateToAbsoluteAngle(@Argument(name="angle", description="Angle to reach in degrees") int angle) {
        this.checkConditionsForRotation();
        if (angle < 0 || angle > 359) {
            throw new IllegalArgumentException("angle must be between 0 and 359");
        }
        this.absoluteTargetPosition = angle;
        this.releaseClampsContact();
        this.executeAction(FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION, this.rotationTimeout);
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate carousel for an angle.")
    public void rotateToRelativeAngle(@Argument(name="angle", description="Relative angle to reach in degrees. Can be positive or negative.") int angle) {
        this.checkConditionsForRotation();
        if (Math.abs(angle) > 360) {
            throw new IllegalArgumentException(angle + ": illegal value for an angle. Must be between -360 and 360");
        }
        FCSLOG.info((Object)(this.getName() + " is at position: " + this.position + "; about to rotate to relative position: " + angle));
        this.absoluteTargetPosition = FcsUtils.addAngle(this.position, angle);
        this.relativeTargetPosition = FcsUtils.computeRotationShortestWay(angle);
        FCSLOG.fine((Object)(this.getName() + " is at position: " + this.position + "; about to rotate - target position: " + this.absoluteTargetPosition + " relative target position: " + this.relativeTargetPosition));
        this.releaseClampsContact();
        this.executeAction(FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION, this.rotationTimeout);
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move a socket which name is given as argument to STANDBY position.", alias="moveSocketToStandby")
    public void rotateSocketToStandby(String socketName) {
        FcsUtils.checkSocketName(socketName);
        CarouselSocket socketToMove = this.socketsMap.get(socketName);
        int requiredPosition = socketToMove.getStandbyPosition();
        String msgWhenCompleted = this.getName() + ":" + socketName + " is at STANDBY position on carousel.";
        if (this.position != requiredPosition) {
            FCSLOG.info((Object)(this.getName() + " is at position: " + this.position + "; about to rotate to position: " + requiredPosition));
            int rotationAngle = requiredPosition - this.position;
            FCSLOG.info((Object)(this.getName() + " rotation angle= " + rotationAngle));
            this.relativeTargetPosition = FcsUtils.computeRotationShortestWay(rotationAngle);
            this.rotateToRelativeAngle(this.relativeTargetPosition);
        }
        FCSLOG.info((Object)msgWhenCompleted);
    }

    public void rotateEmptySocketAtStandby() {
        for (Map.Entry<String, CarouselSocket> entry : this.socketsMap.entrySet()) {
            CarouselSocket socket = entry.getValue();
            if (!socket.isEmpty()) continue;
            this.rotateSocketToStandby(entry.getKey());
            return;
        }
        FCSLOG.error((Object)"no empty socket on carousel - nothing to do.");
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION: {
                return this.position == this.absoluteTargetPosition;
            }
            case ROTATE_CAROUSEL_TO_RELATIVE_POSITION: {
                return this.position == this.absoluteTargetPosition;
            }
        }
        assert (false) : action;
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.carouselController.checkFault();
            this.position = this.carouselController.readPosition();
            FCSLOG.debug((Object)(this.getName() + " position=" + this.position));
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + "=> SDO ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.valueOf("ROTATING"), FcsEnumerations.FilterReadinessState.NOT_READY});
        switch (action) {
            case ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION: {
                this.carouselController.enable();
                this.carouselController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                this.carouselController.writeTargetPosition(this.absoluteTargetPosition);
                this.carouselController.writeControlWord("3F");
                break;
            }
            case ROTATE_CAROUSEL_TO_RELATIVE_POSITION: {
                this.carouselController.enable();
                this.carouselController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                this.carouselController.writeTargetPosition(this.relativeTargetPosition);
                this.carouselController.writeControlWord("7F");
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.getName() + " is ABORTING action " + action.toString() + " within delay " + delay));
        this.carouselController.off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.engageClampsContact();
        this.engageBrake();
        this.carouselController.disable();
    }

    @Override
    public boolean isHoldingFilter() {
        return this.isHoldingFilterAtStandby();
    }

    @Override
    public boolean isAtHandoff() {
        return false;
    }

    @Override
    public void updateStateWithSensors() {
        this.updateClampsStateWithSensors();
    }
}

