/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClampModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class AutochangerThreeOnlineClamps
extends MobileItemModule
implements ControlledBySensors {
    private AutoChangerModule autochanger;
    private final AutochangerOnlineClampModule onlineClampXminus;
    private final AutochangerOnlineClampModule onlineClampXplus;
    private final AutochangerOnlineClampModule onlineClampYminus;
    private final AutochangerOnlineClampModule[] clampsList;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    private ScheduledFuture<?> currentRampHandle;
    protected final Condition currentRampEnded = this.lock.newCondition();
    protected boolean hasToWaitForEndOfCurrentRamp;
    @ConfigurationParameter(description="timeout in milliseconds : if closing the clamps last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForLockingClamps = 15000L;
    @ConfigurationParameter(description="timeout in milliseconds : if unlocking the clamps last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForUnlockingClamps = 15000L;

    public AutochangerThreeOnlineClamps(AutochangerOnlineClampModule onlineClampXminus, AutochangerOnlineClampModule onlineClampXplus, AutochangerOnlineClampModule onlineClampYminus) {
        this.onlineClampXminus = onlineClampXminus;
        this.onlineClampXplus = onlineClampXplus;
        this.onlineClampYminus = onlineClampYminus;
        this.clampsList = new AutochangerOnlineClampModule[]{onlineClampXminus, onlineClampXplus, onlineClampYminus};
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.warning((Object)(this.getName() + ": interrupted in getLockStatus."), (Throwable)ex);
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.lockStatus;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the 3 clamps are LOCKED.")
    public boolean isLocked() {
        return this.onlineClampXminus.isLocked() && this.onlineClampXplus.isLocked() && this.onlineClampYminus.isLocked();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the 3 clamps are CLOSED.")
    public boolean isClosed() {
        return this.onlineClampXminus.isClosed() && this.onlineClampXplus.isClosed() && this.onlineClampYminus.isClosed();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the 3 clamps are OPENED.")
    public boolean isOpened() {
        return this.onlineClampXminus.isOpened() && this.onlineClampXplus.isOpened() && this.onlineClampYminus.isOpened();
    }

    private boolean isInTravel() {
        return this.onlineClampXminus.isInTravel() && this.onlineClampXplus.isInTravel() && this.onlineClampYminus.isInTravel();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if one of the clamp is in error.")
    public boolean isInError() {
        return this.onlineClampXminus.isInError() || this.onlineClampXplus.isInError() || this.onlineClampYminus.isInError();
    }

    @Override
    public void initModule() {
        this.autochanger = (AutoChangerModule)this.getComponentLookup().getComponentByName("autochanger");
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the 3 onlineClamps hardware is ready : controllers ready, controllers parameters checked and controllers configured.")
    public boolean isInitialized() {
        return this.onlineClampXminus.isInitialized() && this.onlineClampXplus.isInitialized() && this.onlineClampYminus.isInitialized();
    }

    private void enableAndCheckControllersBeforeAction() {
        for (AutochangerOnlineClampModule clamp : this.clampsList) {
            clamp.enableAndCheckControllerBeforeAction();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Closes and locks the online clamps.")
    public void closeAndLockClamps() {
        this.updateStateAndCheckSensors();
        if (this.isOpened()) {
            this.executeAction(FcsEnumerations.MobileItemAction.CLOSE_AND_LOCK_ONLINECLAMPS, this.timeoutForLockingClamps);
        } else if (this.isLocked()) {
            FCSLOG.info((Object)(this.getName() + " is already LOCKED - nothing to do."));
        } else {
            throw new RejectedCommandException(this.getName() + " has to be OPENED before a closeAndLockClamps");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Unlock and open the online clamps.")
    public void unlockAndOpenClamps() {
        this.updateStateAndCheckSensors();
        if (this.isLocked()) {
            this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK_AND_OPEN_ONLINECLAMPS, this.timeoutForUnlockingClamps);
        } else if (this.isOpened()) {
            FCSLOG.info((Object)(this.getName() + " clamps already UNLOCKED and OPENED - nothing to do"));
        } else {
            throw new RejectedCommandException(this.getName() + " has to be LOCKED before unlockAndOpen action.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close the 3 online clamps.")
    public void closeClamps() {
        this.updateStateAndCheckSensors();
        if (this.isOpened()) {
            this.executeAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPS, this.timeoutForLockingClamps);
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.getName() + " clamps already CLOSED nothing to do"));
        } else {
            throw new RejectedCommandException(this.getName() + " has to be unlocked before.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Opens the 3 online clamps with a small pressure.")
    public void openClamps() {
        this.updateStateAndCheckSensors();
        if (this.isClosed()) {
            this.executeAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPS, this.timeoutForUnlockingClamps);
        } else if (this.isOpened()) {
            FCSLOG.info((Object)(this.getName() + " clamps already OPENED. Nothing to do"));
        } else {
            throw new RejectedCommandException(this.getName() + " has to be closed before.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Locks clamps : closed with a strong pressure (high current).")
    public void lockClamps() {
        this.updateStateAndCheckSensors();
        if (this.isClosed()) {
            this.executeAction(FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS, this.timeoutForLockingClamps);
        } else if (this.isLocked()) {
            FCSLOG.info((Object)(this.getName() + " is already LOCKED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.getName() + " have to be CLOSED before to be locked.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="unlocks clamps : decreases current in controller to decrease pressure.")
    public void unlockClamps() {
        this.updateStateAndCheckSensors();
        if (this.isLocked()) {
            this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS, this.timeoutForLockingClamps);
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.getName() + " is already CLOSED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.getName() + " have to be CLOSED before to be locked.");
        }
    }

    private void sendCurrentToCloseAllClamps() {
        for (AutochangerOnlineClampModule clamp : this.clampsList) {
            clamp.sendCurrentToControllerAndSaveValue(clamp.getCurrentToClose());
        }
    }

    private void sendCurrentToOpenAllClamps() {
        for (AutochangerOnlineClampModule clamp : this.clampsList) {
            clamp.sendCurrentToControllerAndSaveValue(clamp.getCurrentToOpen());
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the 3 onlineClamps hardware is ready.")
    public boolean isCANDevicesReady() {
        return this.onlineClampXminus.isCANDevicesReady() && this.onlineClampXplus.isCANDevicesReady() && this.onlineClampYminus.isCANDevicesReady();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.CLOSE_AND_LOCK_ONLINECLAMPS || action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPS || action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS) {
            return this.isClosed();
        }
        if (action == FcsEnumerations.MobileItemAction.UNLOCK_AND_OPEN_ONLINECLAMPS || action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPS) {
            return this.isOpened();
        }
        if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS) {
            return this.isLocked();
        }
        throw new IllegalArgumentException(this.getName() + " invalid action:" + (Object)((Object)action));
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.autochanger.updateStateWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.enableAndCheckControllersBeforeAction();
        this.autochanger.checkConditionsForActioningOnlineClamps();
        if (action == FcsEnumerations.MobileItemAction.CLOSE_AND_LOCK_ONLINECLAMPS || action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPS) {
            this.releaseBrakes();
            this.sendCurrentToCloseAllClamps();
        } else if (action == FcsEnumerations.MobileItemAction.UNLOCK_AND_OPEN_ONLINECLAMPS) {
            this.sendPreviouslySentCurrentAndReleaseBrakes();
            this.executeCurrentRampOnAllClamps(this.onlineClampYminus.getSentCurrent(), this.onlineClampXminus.getSentCurrent(), this.onlineClampXplus.getSentCurrent(), 0, 0, 0, 5);
            this.onlineClampXminus.sendCurrentToControllerAndSaveValue(this.onlineClampXminus.getCurrentToOpen());
            this.onlineClampXplus.sendCurrentToControllerAndSaveValue(this.onlineClampXplus.getCurrentToOpen());
            this.onlineClampYminus.sendCurrentToControllerAndSaveValue(this.onlineClampYminus.getCurrentToOpen());
        } else if (action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS) {
            this.sendPreviouslySentCurrentAndReleaseBrakes();
            this.executeCurrentRampOnAllClamps(this.onlineClampYminus.getSentCurrent(), this.onlineClampXminus.getSentCurrent(), this.onlineClampXplus.getSentCurrent(), this.onlineClampYminus.getCurrentToClose(), this.onlineClampXminus.getCurrentToClose(), this.onlineClampXplus.getCurrentToClose(), 5);
        } else if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS) {
            this.releaseBrakes();
            this.increaseCurrentToCurrentToClamp();
        } else if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPS) {
            this.releaseBrakes();
            this.sendCurrentToOpenAllClamps();
        } else {
            throw new IllegalArgumentException(this.getName() + " invalid action:" + (Object)((Object)action));
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.onlineClampXminus.abortAction(action, delay);
        this.onlineClampXplus.abortAction(action, delay);
        this.onlineClampYminus.abortAction(action, delay);
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.CLOSE_AND_LOCK_ONLINECLAMPS) {
            this.increaseCurrentToCurrentToClamp();
            this.autochanger.updateStateWithSensors();
        }
        this.activateBrakesAndSetCurrentToZero();
    }

    private void activateBrakesAndSetCurrentToZero() {
        for (AutochangerOnlineClampModule clamp : this.clampsList) {
            clamp.getController().activateBrake();
            clamp.getController().writeCurrent(0);
        }
    }

    private void releaseBrakes() {
        for (AutochangerOnlineClampModule clamp : this.clampsList) {
            clamp.getController().doReleaseBrake();
        }
    }

    private void increaseCurrentToCurrentToClamp() {
        long period = 500L;
        int n = 2;
        int d = 3;
        this.onlineClampYminus.executeCurrentRamp(this.onlineClampYminus.getCurrentToClose(), this.onlineClampYminus.getCurrentToClamp() * n / d, period);
        this.executeCurrentRampOnClampsX(this.onlineClampXminus.getCurrentToClose(), this.onlineClampXplus.getCurrentToClose(), this.onlineClampXminus.getCurrentToClamp() * n / d, this.onlineClampXplus.getCurrentToClamp() * n / d);
        this.executeCurrentRampOnAllClamps(this.onlineClampYminus.getCurrentToClamp() * n / d, this.onlineClampXminus.getCurrentToClamp() * n / d, this.onlineClampXplus.getCurrentToClamp() * n / d, this.onlineClampYminus.getCurrentToClamp(), this.onlineClampXminus.getCurrentToClamp(), this.onlineClampXplus.getCurrentToClamp(), 4);
    }

    private void sendPreviouslySentCurrentAndReleaseBrakes() {
        this.onlineClampXminus.sendCurrentToControllerAndSaveValue(this.onlineClampXminus.getSentCurrent());
        this.onlineClampXplus.sendCurrentToControllerAndSaveValue(this.onlineClampXplus.getSentCurrent());
        this.onlineClampYminus.sendCurrentToControllerAndSaveValue(this.onlineClampYminus.getSentCurrent());
        this.releaseBrakes();
    }

    public StatusDataPublishedByAutochangerThreeClamps createStatusDataPublishedByThreeClamps() {
        StatusDataPublishedByAutochangerThreeClamps status = new StatusDataPublishedByAutochangerThreeClamps();
        status.setName(this.getName());
        status.setLockStatus(this.lockStatus);
        return status;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData("autochangerClamps", (Serializable)this.createStatusDataPublishedByThreeClamps()));
    }

    private void updateStateAndCheckSensors() {
        this.autochanger.updateStateWithSensors();
        this.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, level=1, description="Update state in reading sensors.")
    public void updateStateWithSensors(String[] hexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            for (AutochangerOnlineClampModule clamp : this.clampsList) {
                clamp.updateStateWithSensors(hexaValues);
            }
            this.computeLockStatus();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
        }
    }

    private void computeLockStatus() {
        this.lockStatus = this.isInError() ? FcsEnumerations.LockStatus.ERROR : (this.isLocked() ? FcsEnumerations.LockStatus.LOCKED : (this.isOpened() ? FcsEnumerations.LockStatus.OPENED : (this.isClosed() ? FcsEnumerations.LockStatus.CLOSED : (this.isInTravel() ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCurrentRampOnClampsX(int initialValueXminus, int initialValueXplus, int finalValueXminus, int finalValueXplus) {
        this.lock.lock();
        try {
            this.hasToWaitForEndOfCurrentRamp = true;
            this.writeCurrentRampOnClampsX(initialValueXminus, initialValueXplus, finalValueXminus, finalValueXplus);
            this.waitForEndOfCurrentRamp();
        }
        finally {
            this.hasToWaitForEndOfCurrentRamp = false;
            this.currentRampEnded.signalAll();
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCurrentRampOnAllClamps(int initialValueYminus, int initialValueXminus, int initialValueXplus, int finalValueYminus, int finalValueXminus, int finalValueXplus, int nbStep) {
        this.lock.lock();
        try {
            this.hasToWaitForEndOfCurrentRamp = true;
            this.writeCurrentRampOnAllClamps(initialValueYminus, initialValueXminus, initialValueXplus, finalValueYminus, finalValueXminus, finalValueXplus, nbStep);
            this.waitForEndOfCurrentRamp();
        }
        finally {
            this.hasToWaitForEndOfCurrentRamp = false;
            this.currentRampEnded.signalAll();
            this.lock.unlock();
        }
    }

    private void cancelCurrentRamp() {
        this.lock.lock();
        try {
            FCSLOG.finest((Object)" => stop writing current");
            this.currentRampEnded.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.currentRampHandle.cancel(true);
        FCSLOG.finest((Object)" => current ramp ended");
    }

    private void waitForEndOfCurrentRamp() {
        while (this.hasToWaitForEndOfCurrentRamp) {
            try {
                FCSLOG.finest((Object)(this.getName() + " waiting for end of current Ramp"));
                this.currentRampEnded.await();
            }
            catch (InterruptedException ex) {
                FCSLOG.finest((Object)(this.getName() + " InterruptedException received=" + ex.toString()));
                break;
            }
        }
        FCSLOG.finest((Object)(this.getName() + " STOP WAITING FOR END OF CURRENT RAMP"));
    }

    private void writeCurrentRampOnClampsX(final int initialValueXminus, final int initialValueXplus, final int finalValueXminus, final int finalValueXplus) {
        int nbStep = 4;
        int period = 250;
        final int stepHeightXminus = (finalValueXminus - initialValueXminus) / 4;
        final int stepHeightXplus = (finalValueXplus - initialValueXplus) / 4;
        FCSLOG.finest((Object)"############################################################");
        FCSLOG.finest((Object)("initialValue for clampXminus=" + initialValueXminus));
        FCSLOG.finest((Object)("finalValue for clampXminus=" + finalValueXminus));
        FCSLOG.finest((Object)("initialValue for clampXplus=" + initialValueXplus));
        FCSLOG.finest((Object)("finalValue for clampXplus=" + finalValueXplus));
        FCSLOG.finest((Object)"nbStep=4");
        FCSLOG.finest((Object)"period=250");
        FCSLOG.finest((Object)("stepHeightXminus=" + stepHeightXminus));
        FCSLOG.finest((Object)("stepHeightXplus=" + stepHeightXplus));
        FCSLOG.finest((Object)"############################################################");
        Runnable currentRamp = new Runnable(){
            private int newCurrentValueXminus;
            private int newCurrentValueXplus;
            {
                this.newCurrentValueXminus = initialValueXminus + stepHeightXminus;
                this.newCurrentValueXplus = initialValueXplus + stepHeightXplus;
            }

            @Override
            public void run() {
                if (AutochangerThreeOnlineClamps.finalValueReached(stepHeightXminus, this.newCurrentValueXminus, finalValueXminus) && AutochangerThreeOnlineClamps.finalValueReached(stepHeightXplus, this.newCurrentValueXplus, finalValueXplus)) {
                    AutochangerThreeOnlineClamps.this.hasToWaitForEndOfCurrentRamp = false;
                    AutochangerThreeOnlineClamps.this.cancelCurrentRamp();
                } else {
                    AutochangerThreeOnlineClamps.this.onlineClampXminus.sendCurrentToControllerAndSaveValue(this.newCurrentValueXminus);
                    AutochangerThreeOnlineClamps.this.onlineClampXplus.sendCurrentToControllerAndSaveValue(this.newCurrentValueXplus);
                    this.newCurrentValueXminus += stepHeightXminus;
                    this.newCurrentValueXplus += stepHeightXplus;
                }
            }
        };
        this.currentRampHandle = this.scheduler.scheduleAtFixedRate(currentRamp, 0L, 250L, TimeUnit.MILLISECONDS);
    }

    private void writeCurrentRampOnAllClamps(final int initialValueYminus, final int initialValueXminus, final int initialValueXplus, final int finalValueYminus, final int finalValueXminus, final int finalValueXplus, int nbStep) {
        int period = 250;
        final int stepHeightYminus = (finalValueYminus - initialValueYminus) / nbStep;
        final int stepHeightXminus = (finalValueXminus - initialValueXminus) / nbStep;
        final int stepHeightXplus = (finalValueXplus - initialValueXplus) / nbStep;
        FCSLOG.finest((Object)"############################################################");
        FCSLOG.finest((Object)("initialValue for clampYminus=" + initialValueYminus));
        FCSLOG.finest((Object)("finalValue for clampYminus=" + finalValueYminus));
        FCSLOG.finest((Object)("initialValue for clampXminus=" + initialValueXminus));
        FCSLOG.finest((Object)("finalValue for clampXminus=" + finalValueXminus));
        FCSLOG.finest((Object)("initialValue for clampXplus=" + initialValueXplus));
        FCSLOG.finest((Object)("finalValue for clampXplus=" + finalValueXplus));
        FCSLOG.finest((Object)("nbStep=" + nbStep));
        FCSLOG.finest((Object)"period=250");
        FCSLOG.finest((Object)("stepHeightYminus=" + stepHeightYminus));
        FCSLOG.finest((Object)("stepHeightXminus=" + stepHeightXminus));
        FCSLOG.finest((Object)("stepHeightXplus=" + stepHeightXplus));
        FCSLOG.finest((Object)"############################################################");
        Runnable currentRamp = new Runnable(){
            private int newCurrentValueYminus;
            private int newCurrentValueXminus;
            private int newCurrentValueXplus;
            {
                this.newCurrentValueYminus = initialValueYminus + stepHeightYminus;
                this.newCurrentValueXminus = initialValueXminus + stepHeightXminus;
                this.newCurrentValueXplus = initialValueXplus + stepHeightXplus;
            }

            @Override
            public void run() {
                if (AutochangerThreeOnlineClamps.finalValueReached(stepHeightXminus, this.newCurrentValueXminus, finalValueXminus) && AutochangerThreeOnlineClamps.finalValueReached(stepHeightXplus, this.newCurrentValueXplus, finalValueXplus) && AutochangerThreeOnlineClamps.finalValueReached(stepHeightYminus, this.newCurrentValueYminus, finalValueYminus)) {
                    AutochangerThreeOnlineClamps.this.hasToWaitForEndOfCurrentRamp = false;
                    AutochangerThreeOnlineClamps.this.cancelCurrentRamp();
                } else {
                    AutochangerThreeOnlineClamps.this.onlineClampYminus.sendCurrentToControllerAndSaveValue(this.newCurrentValueYminus);
                    AutochangerThreeOnlineClamps.this.onlineClampXminus.sendCurrentToControllerAndSaveValue(this.newCurrentValueXminus);
                    AutochangerThreeOnlineClamps.this.onlineClampXplus.sendCurrentToControllerAndSaveValue(this.newCurrentValueXplus);
                    this.newCurrentValueYminus += stepHeightYminus;
                    this.newCurrentValueXminus += stepHeightXminus;
                    this.newCurrentValueXplus += stepHeightXplus;
                }
            }
        };
        this.currentRampHandle = this.scheduler.scheduleAtFixedRate(currentRamp, 0L, 250L, TimeUnit.MILLISECONDS);
    }

    private static boolean finalValueReached(int stepHeight, int newCurrentValue, int finalValue) {
        boolean goingUp = stepHeight > 0 && newCurrentValue > finalValue;
        boolean goingDown = stepHeight < 0 && newCurrentValue < finalValue;
        return goingUp || goingDown;
    }
}

