/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Observable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerWithBrake;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class AutochangerOnlineClampModule
extends MobileItemModule
implements MovedByEPOSController,
ControlledBySensors {
    private static final int CURRENT_RAMP_PERIOD = 500;
    public static final String ONLINE_CLAMP_CONFIG_CATEGORY = "onlineClampCurrent";
    private static final int TIMEOUT_FOR_CLOSING = 10000;
    private static final int TIMEOUT_FOR_OPENING = 10000;
    private AutoChangerModule autochanger;
    private final EPOSControllerWithBrake controller;
    private final ComplementarySensors closeSensors;
    private final ComplementarySensors openSensors;
    @ConfigurationParameter(description="current to close ONLINE clamp in mA", category="onlineClampCurrent")
    private int currentToClose = 0;
    @ConfigurationParameter(description="current to clamp ONLINE clamp in mA", category="onlineClampCurrent")
    private int currentToClamp = 0;
    @ConfigurationParameter(description="current to open ONLINE clamp in mA", category="onlineClampCurrent")
    private int currentToOpen = -this.currentToClose;
    @ConfigurationParameter(description="current sent to controller in mA", category="onlineClampCurrent")
    private int sentCurrent = 0;
    @ConfigurationParameter(description="increment of current in a current ramp in mA", category="onlineClampCurrent")
    private int stepHeightAbsValue = 250;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private boolean controllerInFault;
    private volatile boolean initialized;
    private boolean controllerConfigured = false;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    private ScheduledFuture<?> currentRampHandle;
    protected final Condition currentRampEnded = this.lock.newCondition();
    protected boolean hasToWaitForEndOfCurrentRamp;

    public AutochangerOnlineClampModule(EPOSControllerWithBrake controller, ComplementarySensors closeSensors, ComplementarySensors openSensors, int currentToClose, int currentToClamp) {
        super(3000);
        this.controller = controller;
        this.closeSensors = closeSensors;
        this.openSensors = openSensors;
        this.currentToClose = currentToClose;
        this.currentToOpen = -currentToClose;
        this.currentToClamp = currentToClamp;
    }

    @ConfigurationParameterChanger
    public void setSentCurrent(int sentCurrent) {
        this.sentCurrent = sentCurrent;
    }

    @ConfigurationParameterChanger
    public void setStepHeightAbsValue(int stepHeightAbsValue) {
        if (stepHeightAbsValue <= 0) {
            throw new IllegalArgumentException(stepHeightAbsValue + ":illegal value. stepHeightAbsValue must be > 0");
        }
        this.stepHeightAbsValue = stepHeightAbsValue;
    }

    public int getAdjustedStepHeight(int initialValue, int finalValue) {
        FCSLOG.finest((Object)"############################");
        FCSLOG.finest((Object)("initialValue=" + initialValue));
        FCSLOG.finest((Object)("finalValue=" + finalValue));
        FCSLOG.finest((Object)("|stepHeight|=" + this.stepHeightAbsValue));
        int nbSteps = Math.abs(finalValue - initialValue) / this.stepHeightAbsValue;
        int adjustedStepHeight = (finalValue - initialValue) / nbSteps;
        FCSLOG.finest((Object)("adjustedStepHeight=" + adjustedStepHeight));
        return adjustedStepHeight;
    }

    public int getSentCurrent() {
        return this.sentCurrent;
    }

    public EPOSControllerWithBrake getController() {
        return this.controller;
    }

    public int getCurrentToClose() {
        return this.currentToClose;
    }

    public int getCurrentToOpen() {
        return this.currentToOpen;
    }

    public int getCurrentToClamp() {
        return this.currentToClamp;
    }

    public ComplementarySensors getCloseSensors() {
        return this.closeSensors;
    }

    public ComplementarySensors getOpenSensors() {
        return this.openSensors;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if lockSensor and lockSensorC retun the same value. Doesn't read again sensors.")
    public boolean isCloseSensorsInError() {
        return this.closeSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if unlockSensor and unlockSensorC retun the same value. Doesn't read again sensors.")
    public boolean isOpenSensorsInError() {
        return this.openSensors.isInError();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=ERROR, this means that closeSensor or openSensor is in ERROR or thatopenSensor and closeSensor return non consistant values. Doesn't read again sensors.")
    public boolean isInError() {
        return this.lockStatus == FcsEnumerations.LockStatus.ERROR;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=CLOSED. Doesn't read again sensors.")
    public boolean isClosed() {
        return this.lockStatus == FcsEnumerations.LockStatus.CLOSED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=LOCKED. Doesn't read again sensors.")
    public boolean isLocked() {
        return this.lockStatus == FcsEnumerations.LockStatus.LOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=OPENED. Doesn't read again sensors.")
    public boolean isOpened() {
        return this.lockStatus == FcsEnumerations.LockStatus.OPENED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=INTRAVEL. Doesn't read again sensors.")
    public boolean isInTravel() {
        return this.lockStatus == FcsEnumerations.LockStatus.INTRAVEL;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if controller is in fault. Doesn't read controller CPU.")
    public boolean isControllerInFault() {
        return this.controllerInFault;
    }

    @Override
    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns controller name.")
    public String getControllerName() {
        return this.controller.getName();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if clamp is initialized : controller is booted, parameters in the controller CPU have been checked and controller is configured.")
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void initModule() {
        super.initModule();
        this.autochanger = (AutoChangerModule)this.getComponentLookup().getComponentByName("autochanger");
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        if (this.controller == null) {
            FCSLOG.error((Object)(this.getName() + "==>>> onlineController == null - Please fix groovy description file."));
            throw new IllegalArgumentException(this.getName() + "==>>> null onlineClampController - fix groovy description file.");
        }
        if (this.controller instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.controller)});
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if controller is initialized and configured.")
    public boolean isCANDevicesReady() {
        return ((MainModule)this.getComponentLookup().getComponentByName("main")).isCANDevicesReady() && this.controller.isInitialized() && this.controllerConfigured;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the onlineClamp can be locked.")
    public void checkConditionsForOpening() {
        this.checkConditionsForClosing();
        if (!this.autochanger.isHoldingFilter()) {
            throw new RejectedCommandException(this.getName() + " can't be OPENED if autochanger is not HOLDING filter.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the onlineClamp can be locked.")
    public void checkConditionsForClosing() {
        if (!this.autochanger.getAutochangerTrucks().isAtOnline()) {
            throw new RejectedCommandException(this.getName() + " can't be CLOSED if autochanger trucks are not at ONLINE position.");
        }
        if (this.autochanger.isEmpty()) {
            throw new RejectedCommandException(this.getName() + " can't be CLOSED if there is no filter in autochanger trucks.");
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Initialize controller and check parameters.")
    public TreeWalkerDiag checkHardware() throws HardwareException {
        super.checkHardware();
        FCSLOG.debug((Object)(this.getName() + " checking hardware."));
        try {
            this.controller.initializeAndCheckHardware();
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        catch (FailedCommandException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
        this.initialized = true;
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read in the CPU of the controller parameters for mode CURRENT.If a parameter has a different value than in configuration, throws an exception.")
    public void enableAndCheckControllerBeforeAction() {
        this.controller.enable();
        this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
        try {
            this.controller.checkParameters(EPOSEnumerations.EposMode.CURRENT);
            this.controller.checkFault();
        }
        catch (HardwareException ex) {
            String msg = this.getName() + " error in parameters ";
            FCSLOG.error((Object)(msg + (Object)((Object)ex)));
            throw new FcsHardwareException(msg, ex);
        }
        if (!this.controller.isParametersOK()) {
            String msg = this.getName() + " Some parameter values are not the same in CPU and configuration system.";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure controller.")
    public void configureController() throws HardwareException {
        try {
            this.controllerConfigured = false;
            this.configureDigitalInputOfOnlineClamps();
            this.configureDigitalOutputOfOnlineClamps();
            this.controllerConfigured = true;
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)this.getName(), (Throwable)ex);
        }
    }

    public void updateStateAndCheckSensors() {
        this.autochanger.updateStateWithSensors();
        this.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, level=1, description="Update state in reading sensors.")
    public void updateStateWithSensors(String[] hexaValues) {
        this.lock.lock();
        try {
            boolean inError;
            this.updatingState = true;
            this.closeSensors.updateValues(hexaValues);
            this.openSensors.updateValues(hexaValues);
            boolean closed = this.closeSensors.isOn();
            boolean opened = this.openSensors.isOn();
            boolean someSensorsInError = this.closeSensors.isInError() || this.openSensors.isInError();
            boolean bl = inError = someSensorsInError || closed && opened;
            this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (closed ? FcsEnumerations.LockStatus.CLOSED : (opened ? FcsEnumerations.LockStatus.OPENED : FcsEnumerations.LockStatus.INTRAVEL));
            if (closed && this.sentCurrent == this.currentToClamp) {
                this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
            }
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
        }
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.autochanger.updateStateWithSensors();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP || action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP) {
            return this.isClosed();
        }
        if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP) {
            return this.isOpened();
        }
        if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP) {
            return this.isLocked();
        }
        throw new IllegalArgumentException(this.getName() + " invalid action for ONLINE clamp:" + (Object)((Object)action));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Closes the ONLINE clamp.", timeout=10000)
    public void close() {
        this.updateStateAndCheckSensors();
        if (this.isOpened() || this.isInTravel()) {
            this.checkConditionsForClosing();
            this.executeAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP, 10000L);
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.getName() + " is already CLOSED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.getName() + " has to be OPENED before a close action.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Opens the ONLINE clamp.", timeout=10000)
    public void open() {
        this.updateStateAndCheckSensors();
        if (this.isClosed() || this.isInTravel()) {
            this.checkConditionsForOpening();
            this.executeAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP, 10000L);
        } else if (this.isOpened()) {
            FCSLOG.info((Object)(this.getName() + " is already OPENED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.getName() + " has to be CLOSED before an open action.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Locks the ONLINE clamp : sends currentToClamp to the controller with a ramp of currentfrom currentToClose to currentToRamp.", timeout=10000)
    public void lock() {
        this.updateStateAndCheckSensors();
        if (this.isClosed() || this.isInTravel()) {
            this.executeAction(FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP, 10000L);
        } else if (this.isLocked()) {
            FCSLOG.info((Object)(this.getName() + " is already LOCKED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.getName() + " has to be CLOSED before lock action.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlocks the ONLINE clamp : sends currentToClamp to the controller  with a ramp of current from currentToClamp to currentToClose.", timeout=10000)
    public void unlock() {
        this.updateStateAndCheckSensors();
        if (this.isLocked()) {
            this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP, 10000L);
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.getName() + " is already CLOSED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.getName() + " has to be LOCKED before unlock action.");
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.enableAndCheckControllerBeforeAction();
        this.autochanger.checkConditionsForActioningOnlineClamps();
        if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP) {
            this.sendCurrentToControllerAndSaveValue(this.currentToClose);
            this.controller.doReleaseBrake();
        } else if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP) {
            this.sendCurrentToControllerAndSaveValue(this.currentToOpen);
            this.controller.doReleaseBrake();
        } else if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP) {
            this.controller.doReleaseBrake();
            this.executeCurrentRamp(this.currentToClose, this.currentToClamp, 500L);
        } else if (action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP) {
            this.sendCurrentToControllerAndSaveValue(this.currentToClamp);
            this.controller.doReleaseBrake();
            this.executeCurrentRamp(this.currentToClamp, this.currentToClose, 500L);
        } else {
            throw new IllegalArgumentException(this.getName() + " invalid action for ONLINE clamp:" + (Object)((Object)action));
        }
    }

    public void sendCurrentToControllerAndSaveValue(int current) {
        FCSLOG.finest((Object)(this.getName() + " current to write to controller " + this.getControllerName() + ":" + current));
        this.controller.writeCurrent(current);
        this.getComponentConfigurationEnvironment().change("sentCurrent", (Object)current);
        this.autochanger.saveCurrentSentToOnlineClampsControllers();
        this.publishData();
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.controller.quickStop();
        this.controller.activateBrake();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.controller.activateBrake();
        this.controller.writeCurrent(0);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the online clamps controllers.")
    public void configureDigitalInputOfOnlineClamps() {
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, "0005");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, "0");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, "C20");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, "30");
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the online clamps controllers.")
    public void configureDigitalOutputOfOnlineClamps() {
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, "0");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, "8001");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, "8001");
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        this.updateControllerInFault(((EPOSController)((Object)source)).getName(), v);
    }

    public StatusDataPublishedByAutochangerOnlineClamp createStatusDataPublishedByOnlineClamp() {
        StatusDataPublishedByAutochangerOnlineClamp status = new StatusDataPublishedByAutochangerOnlineClamp();
        status.setName(this.getName());
        status.setLockSensorValue(this.closeSensors.isOn());
        status.setUnlockSensorValue(this.openSensors.isOn());
        status.setLockStatus(this.lockStatus);
        status.setLockSensorInError(this.closeSensors.isInError());
        status.setUnlockSensorInError(this.openSensors.isInError());
        status.setInError(this.lockStatus == FcsEnumerations.LockStatus.ERROR);
        status.setControllerBooted(this.controller.isBooted());
        status.setControllerInFault(this.controllerInFault);
        status.setSentCurrent(this.sentCurrent);
        return status;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)this.createStatusDataPublishedByOnlineClamp()));
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.controller.quickStop();
    }

    private void cancelCurrentRamp() {
        this.lock.lock();
        try {
            FCSLOG.debug((Object)" => stop writing current");
            this.currentRampEnded.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.currentRampHandle.cancel(true);
        FCSLOG.debug((Object)" => current ramp ended");
    }

    private void waitForEndOfCurrentRamp() {
        while (this.hasToWaitForEndOfCurrentRamp) {
            try {
                FCSLOG.debug((Object)(this.getName() + " waiting for end of current Ramp"));
                this.currentRampEnded.await();
            }
            catch (InterruptedException ex) {
                FCSLOG.debug((Object)(this.getName() + " InterruptedException received=" + ex.toString()));
                break;
            }
        }
        FCSLOG.debug((Object)(this.getName() + " STOP WAITING FOR END OF CURRENT RAMP"));
    }

    private void writeCurrentRamp(final int initialValue, final int finalValue, long period) {
        FCSLOG.debug((Object)"############################");
        FCSLOG.debug((Object)("initialValue=" + initialValue));
        FCSLOG.debug((Object)("finalValue=" + finalValue));
        FCSLOG.debug((Object)("|stepHeight|=" + this.stepHeightAbsValue));
        FCSLOG.debug((Object)("period=" + period));
        FCSLOG.debug((Object)"############################");
        Runnable currentRamp = new Runnable(){
            private final int adjustedStepHeight;
            private int newCurrentValue;
            {
                this.adjustedStepHeight = AutochangerOnlineClampModule.this.getAdjustedStepHeight(initialValue, finalValue);
                this.newCurrentValue = initialValue + this.adjustedStepHeight;
            }

            public boolean finalValueReached() {
                boolean reachedUp = this.adjustedStepHeight > 0 && this.newCurrentValue > finalValue;
                boolean reachedDown = this.adjustedStepHeight < 0 && this.newCurrentValue < finalValue;
                return reachedUp || reachedDown;
            }

            @Override
            public void run() {
                if (this.finalValueReached()) {
                    AutochangerOnlineClampModule.this.hasToWaitForEndOfCurrentRamp = false;
                    AutochangerOnlineClampModule.this.cancelCurrentRamp();
                } else {
                    AutochangerOnlineClampModule.this.sendCurrentToControllerAndSaveValue(this.newCurrentValue);
                    this.newCurrentValue += this.adjustedStepHeight;
                }
            }
        };
        this.currentRampHandle = this.scheduler.scheduleAtFixedRate(currentRamp, 0L, period, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCurrentRamp(int initialValue, int finalValue, long period) {
        this.lock.lock();
        try {
            this.hasToWaitForEndOfCurrentRamp = true;
            this.writeCurrentRamp(initialValue, finalValue, period);
            this.waitForEndOfCurrentRamp();
        }
        finally {
            this.hasToWaitForEndOfCurrentRamp = false;
            this.currentRampEnded.signalAll();
            this.lock.unlock();
        }
    }
}

