/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Observable;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutochangerTruckModule;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForLinearRail;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class AutoChangerTwoTrucksModule
extends MobileItemModule {
    AutochangerTruckModule truckXminus;
    AutochangerTruckModule truckXplus;
    private final int minActualPositionValue = 0;
    private final int maxActualPositionValue = 998000;
    @ConfigurationParameter(description="STANDBY position in micron")
    private int standbyPosition = 992000;
    @ConfigurationParameter(description="HANDOFF position in micron")
    private int handoffPosition = 70000;
    @ConfigurationParameter(description="ONLINE position in micron")
    private int onlinePosition = 2600;
    @ConfigurationParameter(description="timeout for trucks motion from ONLINE to STANDBY in milliseconds")
    private long timeoutForTrucksMotion = 20000L;
    private int current = 0;
    private int speed = 0;
    private int masterPosition;
    private int slavePosition;
    private int deltaPosition;
    @ConfigurationParameter(description="masterPosition is reached if |targetPosition - masterPosition| < positionRange")
    private int positionRange = 2;
    @ConfigurationParameter(description="masterPosition is reached if |targetPosition - masterPosition| < positionRange")
    private int deltaPositionMax = 10;
    private int absoluteTargetPosition = 0;
    private int relativeTargetPosition = 0;
    private EPOSControllerForLinearRail linearRailMasterController;
    private EPOSControllerForLinearRail linearRailSlaveController;
    private AutoChangerModule autochanger;
    private boolean atHandoff = false;
    private boolean atOnline = false;
    private boolean atStandby = false;

    public AutoChangerTwoTrucksModule(AutochangerTruckModule truckXminus, AutochangerTruckModule truckXplus) {
        this.truckXminus = truckXminus;
        this.truckXplus = truckXplus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return actual trucks position (master position). Doesn't read again the position on the controller.")
    public int getPosition() {
        return this.masterPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return HANDOFF position. Doesn't read again the position on the controller.")
    public int getHandoffPosition() {
        return this.handoffPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return STANDBY position. Doesn't read again the position on the controller.")
    public int getStandbyPosition() {
        return this.standbyPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return ONLINE position. Doesn't read again the position on the controller.")
    public int getOnlinePosition() {
        return this.onlinePosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return timeout for trucks motion.")
    public long getTimeoutForTrucksMotion() {
        return this.timeoutForTrucksMotion;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at handoff position. This command doesn't read again the sensors.")
    public boolean isAtHandoff() {
        return this.atHandoff;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at ONLINE position. This command doesn't read again the sensors.")
    public boolean isAtOnline() {
        return this.atOnline;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at STANDBY position. This command doesn't read again the sensors.")
    public boolean isAtStandby() {
        return this.atStandby;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the homing of the trucks has been done.")
    public boolean isHomingDone() {
        return this.linearRailSlaveController.isHomingDone() && this.linearRailMasterController.isHomingDone();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if TruckXminus position sensors or TruckXminus position sensors are in error.")
    public boolean isPositionSensorsInError() {
        return this.truckXminus.isPositionSensorsInError() || this.truckXplus.isPositionSensorsInError() || this.positionSensorsNonConsistant();
    }

    private boolean positionSensorsNonConsistant() {
        return this.isAtStandby() && this.isAtHandoff() || this.isAtStandby() && this.isAtOnline() || this.isAtHandoff() && this.isAtOnline();
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getSubsystem().getComponentLookup();
        this.autochanger = (AutoChangerModule)lookup.getComponentByName("autochanger");
        this.linearRailMasterController = (EPOSControllerForLinearRail)lookup.getComponentByName("linearRailMasterController");
        this.linearRailSlaveController = (EPOSControllerForLinearRail)lookup.getComponentByName("linearRailSlaveController");
        if (this.linearRailMasterController instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.linearRailMasterController)});
        }
        if (this.linearRailSlaveController instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.linearRailSlaveController)});
        }
    }

    private void checkControllersName() {
        if (!this.truckXminus.getControllerName().contains("Master")) {
            throw new FcsHardwareException("truckXminus has to be controlled by Master controller.");
        }
        FCSLOG.info((Object)(this.getName() + " is controlled by " + this.truckXminus.getControllerName()));
        if (!this.truckXplus.getControllerName().contains("Slave")) {
            throw new FcsHardwareException("truckXplus has to be controlled by Slave controller.");
        }
        FCSLOG.info((Object)(this.getName() + " is controlled by " + this.truckXplus.getControllerName()));
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        super.checkHardware();
        this.checkControllersName();
        FCSLOG.debug((Object)(this.getName() + " checking hardware."));
        try {
            this.linearRailSlaveController.initializeAndCheckHardware();
            this.linearRailMasterController.initializeAndCheckHardware();
            this.homing();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)this.getName(), (Throwable)ex);
        }
        catch (SDORequestException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            FCSLOG.error((Object)this.getName(), (Throwable)ex);
            throw new HardwareException(false, (Throwable)ex);
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure Autochanger trucks master and slave controllers.", alias="initControllers")
    public void configureControllers() {
        FCSLOG.info((Object)(this.getName() + " Begin configuration of the controllers"));
        this.linearRailMasterController.configureDigitalInputOfLinearRails();
        this.linearRailSlaveController.configureDigitalInputOfLinearRails();
        this.linearRailMasterController.configureDigitalOutputOfLinearRails();
        this.linearRailSlaveController.configureDigitalOutputOfLinearRails();
        FCSLOG.info((Object)(this.getName() + " End configuration of the controllers"));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if both controllers are initialized and homing of trucks are done.")
    public boolean isInitialized() {
        return this.linearRailMasterController.isInitialized() && this.linearRailSlaveController.isInitialized() && this.isHomingDone();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the motion of trucks are allowed.")
    public void checkConditionsForTrucksMotion() {
        if (!this.linearRailSlaveController.isInitialized() || !this.linearRailMasterController.isInitialized()) {
            String msg = this.getName() + " can't move autochanger trucks because controllers are not both initialized:\n";
            FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
        if (!this.isHomingDone()) {
            throw new RejectedCommandException(this.getName() + " can't be moved because the homing has not been done yet. ");
        }
        this.updatePosition();
        this.checkDeltaPosition();
        this.autochanger.checkFilterSafetyBeforeMotion();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Handoff position.", alias="goToHandoff")
    public void goToHandOff() {
        this.moveToAbsoluteTargetPosition(this.handoffPosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Online position.")
    public void goToOnline() {
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_ONLINE, FcsEnumerations.FilterReadinessState.NOT_READY});
        this.moveToAbsoluteTargetPosition(this.onlinePosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Standby position.")
    public void goToStandby() {
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_STANDBY, FcsEnumerations.FilterReadinessState.NOT_READY});
        this.moveToAbsoluteTargetPosition(this.standbyPosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the absolute position given as argument.", alias="mobeABSPos", timeout=20000)
    public void moveToAbsoluteTargetPosition(int targetPosition) {
        if (targetPosition < 0 || targetPosition > 998000) {
            throw new IllegalArgumentException(this.getName() + "argument has to be between " + 0 + " and " + 998000);
        }
        this.updatePosition();
        if (this.masterPosition == targetPosition) {
            FCSLOG.info((Object)(this.getName() + " is already at target position=" + targetPosition));
        } else {
            this.checkConditionsForTrucksMotion();
            this.absoluteTargetPosition = targetPosition;
            FCSLOG.info((Object)(this.getName() + " going to absolute position: " + this.absoluteTargetPosition));
            this.executeAction(FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION, this.timeoutForTrucksMotion);
        }
    }

    @Deprecated
    public void moveToRelativeTargetPosition(int relativePosition) {
        this.checkConditionsForTrucksMotion();
        if (relativePosition < -2000 || relativePosition > 2000) {
            throw new IllegalArgumentException("relativePosition=" + relativePosition + " Relative position value has to be between -2000 and 2000");
        }
        this.linearRailMasterController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.updatePosition();
        this.relativeTargetPosition = this.masterPosition + relativePosition;
        if (this.relativeTargetPosition < 0 || this.relativeTargetPosition > 998000) {
            throw new IllegalArgumentException(this.getName() + " actual position + argument has to be between " + 0 + " and " + 998000 + " relativeTargetPosition=" + this.relativeTargetPosition);
        }
        FCSLOG.info((Object)(this.getName() + " going to relative position: " + this.relativeTargetPosition));
        this.executeAction(FcsEnumerations.MobileItemAction.MOVE_TO_RELATIVE_POSITION, this.timeoutForTrucksMotion);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: {
                this.checkControllersMode();
                this.enableControllersAndReleaseBrake();
                this.linearRailMasterController.writeTargetPosition(this.absoluteTargetPosition);
                this.linearRailMasterController.writeControlWord("3F");
                break;
            }
            case MOVE_TO_RELATIVE_POSITION: {
                this.checkControllersMode();
                this.enableControllersAndReleaseBrake();
                this.linearRailMasterController.writeTargetPosition(this.relativeTargetPosition);
                this.linearRailMasterController.writeControlWord("7F");
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Enable and release brake for the 2 controllers.")
    public void enableControllersAndReleaseBrake() {
        this.linearRailMasterController.enable();
        this.linearRailSlaveController.enable();
        this.linearRailMasterController.doReleaseBrake();
        if (!this.linearRailMasterController.isEnabled()) {
            throw new FcsHardwareException(this.getName() + " can't release Slave Controller brake  because Master Controller is disabled.");
        }
        this.linearRailSlaveController.doReleaseBrake();
    }

    private void checkControllersMode() {
        if (!this.linearRailMasterController.isInMode(EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new FcsHardwareException(this.getName() + " : linearRailMasterController is not in PROFILE_POSITION mode, can't move.");
        }
        if (!this.linearRailSlaveController.isInMode(EPOSEnumerations.EposMode.MASTER_ENCODER)) {
            throw new FcsHardwareException(this.getName() + " : linearRailSlaveController is not in MASTER_ENCODER mode, can't move. Slave controller mode =" + (Object)((Object)this.linearRailSlaveController.getMode()) + " readMode=" + (Object)((Object)this.linearRailSlaveController.readMode()));
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Align slave controller position to master controller position.")
    public void alignSlave() {
        if (this.linearRailMasterController.isEnabled()) {
            throw new FcsHardwareException(this.getName() + " master controller must be disabled.");
        }
        if (!this.linearRailMasterController.isBrakeActivated()) {
            throw new FcsHardwareException(this.getName() + " master controller brake must be activated.");
        }
        this.updatePosition();
        if (Math.abs(this.masterPosition - this.slavePosition) > this.deltaPositionMax) {
            this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
            this.doAlignSlave(this.masterPosition);
            this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.MASTER_ENCODER);
        } else {
            FCSLOG.info((Object)(this.getName() + " slave and master position are identical, no need to align slave."));
        }
    }

    private void doAlignSlave(int pos) {
        int timeoutForSlaveAlignment = 2000;
        if (!this.linearRailSlaveController.isInMode(EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new FcsHardwareException(this.getName() + " can't align slave truck because couldn't change its mode to PROFILE_POSITION.");
        }
        this.linearRailSlaveController.enableAndReleaseBrake();
        this.linearRailSlaveController.enableAndWriteAbsolutePosition(pos);
        this.linearRailSlaveController.checkTargetReached(timeoutForSlaveAlignment);
        this.updatePosition();
        while (this.deltaPosition > this.deltaPositionMax) {
            FCSLOG.fine((Object)(this.getName() + "==> alignSlave non completed, slavePosition=" + this.slavePosition));
            this.updatePosition();
        }
        this.publishData();
        this.linearRailSlaveController.activateBrakeAndDisable();
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.info((Object)("ABORTING action: " + action.toString()));
        this.linearRailSlaveController.off();
        this.linearRailMasterController.off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.linearRailMasterController.quickStop();
        this.linearRailSlaveController.quickStop();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.publishData();
        this.linearRailMasterController.activateBrakeAndDisable();
        this.linearRailSlaveController.activateBrakeAndDisable();
        FCSLOG.info((Object)(this.getName() + ":" + action.toString() + " completed - doing postAction: checking position sensors."));
        if (action == FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION) {
            this.checkPositionSensors();
        }
        this.updatePosition();
        this.publishData();
        this.alignSlave();
        this.updatePosition();
        this.publishData();
        this.autochanger.updateFCSStateToReady();
    }

    public void checkPositionSensors() {
        this.autochanger.updateStateWithSensors();
        if (this.absoluteTargetPosition == this.standbyPosition && !this.atStandby) {
            throw new FailedCommandException(this.getName() + ": check with sensors: STANDBY sensors don't confirm trucks position.");
        }
        if (this.absoluteTargetPosition == this.handoffPosition && !this.atHandoff) {
            FCSLOG.info((Object)("this.absoluteTargetPosition=" + this.absoluteTargetPosition));
            FCSLOG.info((Object)("this.handoffPosition=" + this.handoffPosition));
            FCSLOG.info((Object)("this.atHandoff=" + this.atHandoff));
            throw new FailedCommandException(this.getName() + ": check with sensors: HANDOFF sensors don't confirm trucks position.");
        }
        if (this.absoluteTargetPosition == this.onlinePosition && !this.atOnline) {
            throw new FailedCommandException(this.getName() + ": check with sensors: ONLINE sensors don't confirm trucks position.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Do homing for both  controllers.")
    public void homing() {
        this.linearRailMasterController.homing();
        this.linearRailSlaveController.homing();
        this.updatePosition();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update trucks position in reading controller.")
    public void updatePosition() {
        this.truckXminus.updatePosition();
        this.truckXplus.updatePosition();
        this.masterPosition = this.linearRailMasterController.readPosition();
        this.slavePosition = this.linearRailSlaveController.readPosition();
        this.deltaPosition = this.masterPosition - this.slavePosition;
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read position on controllers, compute difference and throw exceptionif difference is > 1000.")
    public void checkDeltaPosition() {
        this.updatePosition();
        if (Math.abs(this.deltaPosition) > 1000) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_TRUCKS_ERROR, "Too much difference between trucks position. Alignment of Slave Truck to be done.");
            throw new FcsHardwareException();
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update trucks position in reading controller and return position.")
    public int readPosition() {
        this.updatePosition();
        return this.masterPosition;
    }

    @Override
    public boolean isCANDevicesReady() {
        return this.isInitialized();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: {
                return this.linearRailMasterController.isTargetReached() && Math.abs(this.masterPosition - this.absoluteTargetPosition) < this.positionRange;
            }
            case MOVE_TO_RELATIVE_POSITION: {
                return this.linearRailMasterController.isTargetReached() && Math.abs(this.masterPosition - this.relativeTargetPosition) < this.positionRange;
            }
        }
        assert (false) : action;
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.linearRailMasterController.checkFault();
            this.linearRailSlaveController.checkFault();
            this.updatePosition();
            FCSLOG.debug((Object)(this.getName() + " position=" + this.masterPosition));
            this.autochanger.updateStateWithSensors();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + "=> SDO ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        catch (SDORequestException ex) {
            FCSLOG.error((Object)(this.getName() + "=> SDO ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
    }

    void updateStateWithSensors(String[] readHexaValues) {
        this.truckXminus.updateStateWithSensors(readHexaValues);
        this.truckXplus.updateStateWithSensors(readHexaValues);
        this.atHandoff = this.truckXminus.isAtHandoff() && this.truckXplus.isAtHandoff();
        this.atOnline = this.truckXminus.isAtOnline() && this.truckXplus.isAtOnline();
        this.atStandby = this.truckXminus.isAtStandby() && this.truckXplus.isAtStandby();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Release slave controller brake.")
    public void releaseBrakeSlave() {
        if (this.linearRailSlaveController.isInMode(EPOSEnumerations.EposMode.MASTER_ENCODER) && !this.linearRailMasterController.isEnabled()) {
            throw new RejectedCommandException(this.getName() + " couldn't release slave controller brakebecause master controller is disabled and slave controller is in MASTER_ENCODER mode");
        }
        this.linearRailSlaveController.doReleaseBrake();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Release master controller brake.")
    public void releaseBrakeMaster() {
        this.linearRailMasterController.doReleaseBrake();
    }

    public StatusDataPublishedByAutoChangerTrucks createStatusDataPublishedByAutoChangerTrucks() {
        StatusDataPublishedByAutoChangerTrucks s = new StatusDataPublishedByAutoChangerTrucks();
        s.setMasterPosition(this.masterPosition);
        s.setSlavePosition(this.slavePosition);
        s.setCurrent(this.current);
        s.setSpeed(this.speed);
        s.setHomingDone(this.isHomingDone());
        s.setAtHandoff(this.atHandoff);
        s.setAtOnline(this.atOnline);
        s.setAtStandby(this.atStandby);
        s.setInError(this.isPositionSensorsInError());
        return s;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)this.createStatusDataPublishedByAutoChangerTrucks()));
    }
}

