/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;

public class Line
implements HasLifecycle {
    protected String devcName;
    protected int chan;
    protected String compDevcName;
    protected int compChan;
    private Device device;
    private Device compDevice;
    @LookupName
    protected String name;

    void configure(Monitor mon) {
        try {
            if (this.devcName != null) {
                this.device = mon.getDevice(this.devcName);
                if (this.device == null) {
                    MonitorLogUtils.reportError(mon.subsys.getLogger(), this.name, "device", this.devcName);
                } else {
                    this.device.checkLine(this.name, this.chan);
                }
            }
            if (this.compDevcName != null) {
                this.compDevice = mon.getDevice(this.compDevcName);
                if (this.compDevice == null) {
                    MonitorLogUtils.reportError(mon.subsys.getLogger(), this.name, "device", this.compDevcName);
                } else {
                    this.compDevice.checkLine(this.name, this.compChan);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWarm(boolean on) {
        if (this.device != null) {
            this.device.setLineWarm(this.chan, on);
        }
        if (this.compDevice != null) {
            this.compDevice.setLineWarm(this.compChan, !on);
        }
    }

    public void set(boolean on) {
        if (this.device != null && this.device.online) {
            this.device.setLine(this.chan, on);
        }
        if (this.compDevice != null && this.compDevice.online) {
            this.compDevice.setLine(this.compChan, !on);
        }
    }

    public boolean isSet() {
        boolean state = false;
        if (this.device != null && this.device.online) {
            state = this.device.isLineSet(this.chan);
        } else if (this.compDevice != null && this.compDevice.online) {
            state = !this.compDevice.isLineSet(this.compChan);
        }
        return state;
    }
}

