#!/bin/sh
#this script generates the groovy description file fr the whole FCS with simulated hardware

#Directory where one can find the groovy description files
source .setupFCS_BIN
echo "RESOURCES_DIR=$RESOURCES_DIR"

#Directory were are stored all scripts
echo "SCRIPTS_DIR=$SCRIPTS_DIR"

#the file this script is going to generate
FCS_FILENAME=fcs__simulation.groovy

#head file
FCSHEAD=wholeFCS_head

#bridge to changer hardware filename(carousel and autochanger)
B_CHANGER_DESC=bridgeToChanger_description

#bridge to loader hardware filename 
B_LOADER_DESC=bridgeToLoader_description

#filterManager description filename
FILTER_MGR_DESC=filterManager_description

#filterIdentificator description filename
FILTER_IDENT_DESC=filterIdentificator_description

#Carousel description
CAROUSEL_DESC=carousel_description

#Autochanger description
AUTOCHANGER_DESC=autochanger_description

#Loader description
LOADER_DESC=loader_description

#Directory to save files
TMPDIR=/Users/virieux/tmp/

#Generate Carousel Description
$SCRIPTS_DIR/generateCarouselDescriptionForWholeFCS.sh

cd $RESOURCES_DIR

### save existing FCS description file ###
echo "Saving $CAROUSEL_FILENAME in $TMPDIR"
DATE=`date '+%Y%m%d_%H%M%S'`
cp $FCS_FILENAME $TMPDIR/$FCS_FILENAME.$DATE

### Generation of file FCS_FILENAME

echo "Generation of $FCS_FILENAME from $FCSHEAD $FILTER_MGR_DESC $FILTER_IDENT_DESC $B_CHANGER_DESC $B_LOADER_DESC $CAROUSEL_DESC $AUTOCHANGER_DESC $LOADER_DESC"
chmod u+w $FCS_FILENAME
cat $FCSHEAD $FILTER_MGR_DESC $FILTER_IDENT_DESC $B_CHANGER_DESC $B_LOADER_DESC $CAROUSEL_DESC $AUTOCHANGER_DESC $LOADER_DESC > $FCS_FILENAME

echo "}    // main" >> $FCS_FILENAME
chmod u-w $FCS_FILENAME

