#!/bin/sh
#this script generates the groovy description file fr the autochanger with simulated hardware

#Directory where one can find the groovy description files
source .setupFCS_BIN
echo "RESOURCES_DIR=$RESOURCES_DIR"

#Directory were are stored all scripts
echo "SCRIPTS_DIR=$SCRIPTS_DIR"


#the file this script is going to generate
AUTOCHANGER_FILENAME=autochanger__simulation.groovy

#head file
AUTOCHANGER_HEAD=autochanger-standalone_head

#bridge to autochanger hardware filename 
B_AUTOCHANGER_DESC=bridgeToAutochanger_description
B_AUTOCHANGER_STANDALONE_DESC=bridgeToAutochangerSTANDALONE_description

#filterManager description filename
FILTER_MGR_DESC=filterManager_description

#filterIdentificator description filename
FILTER_IDENT_DESC=filterIdentificator_description

#Fake carousel Description
FAKE_CAROUSEL_DESC=fakeCarousel_description

#Fake loader Description
FAKE_LOADER_DESC=fakeLoader_description

#Loader description
AUTOCHANGER_DESC=autochanger_description

#Directory to save files
TMPDIR=/Users/virieux/tmp/

cd $RESOURCES_DIR

### save existing FCS description file ###
echo "Saving $AUTOCHANGER_FILENAME in $TMPDIR"
DATE=`date '+%Y%m%d_%H%M%S'`
cp $AUTOCHANGER_FILENAME $TMPDIR/$AUTOCHANGER_FILENAME.$DATE

### saving existing bridgeToAutochangerSTANDALONE_description description file ###
echo "Saving $B_AUTOCHANGER_STANDALONE_DESC in $TMPDIR"
DATE=`date '+%Y%m%d_%H%M%S'`
cp $B_AUTOCHANGER_STANDALONE_DESC $TMPDIR/$B_AUTOCHANGER_STANDALONE_DESC.$DATE

###Generation of B_AUTOCHANGER_STANDALONE_DESC from B_AUTOCHANGER_DESC
chmod u+w $B_AUTOCHANGER_STANDALONE_DESC
cat $B_AUTOCHANGER_DESC|sed 's/SimuAutochangerPlutoGateway/SimuAutochangerStandalonePlutoGateway/g' > $B_AUTOCHANGER_STANDALONE_DESC

### Generation of file AUTOCHANGER_FILENAME

echo "Generation of $AUTOCHANGER_FILENAME from $AUTOCHANGER_HEAD $FILTER_MGR_DESC $FILTER_IDENT_DESC $B_AUTOCHANGER_STANDALONE_DESC $FAKE_CAROUSEL_DESC $FAKE_LOADER_DESC $AUTOCHANGER_DESC"

chmod u+w $AUTOCHANGER_FILENAME
cat $AUTOCHANGER_HEAD $FILTER_MGR_DESC $FILTER_IDENT_DESC $B_AUTOCHANGER_STANDALONE_DESC $FAKE_CAROUSEL_DESC $FAKE_LOADER_DESC $AUTOCHANGER_DESC > $AUTOCHANGER_FILENAME

echo "}    // main" >> $AUTOCHANGER_FILENAME
chmod u-w $AUTOCHANGER_FILENAME
chmod u-w $B_AUTOCHANGER_STANDALONE_DESC

