/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class TruckModule
extends Module {
    private FcsEnumerations.AutoChangerTrucksLocation truckLocation;
    protected DigitalSensor railSensorStandback;
    protected DigitalSensor railSensorStandby;
    private volatile boolean updatingTruckLocation = false;
    private final Lock lock = new ReentrantLock();
    private final Condition truckLocationUpdated = this.lock.newCondition();

    public TruckModule(DigitalSensor railSensorStandback, DigitalSensor railSensorStandby) {
        super(3000);
        this.railSensorStandback = railSensorStandback;
        this.railSensorStandby = railSensorStandby;
    }

    public DigitalSensor getRailSensorStandback() {
        return this.railSensorStandback;
    }

    public void setRailSensorStandback(DigitalSensor railSensorStandback) {
        this.railSensorStandback = railSensorStandback;
    }

    public DigitalSensor getRailSensorStandby() {
        return this.railSensorStandby;
    }

    public void setRailSensorStandby(DigitalSensor railSensorStandby) {
        this.railSensorStandby = railSensorStandby;
    }

    public void initModule() {
        this.truckLocation = FcsEnumerations.AutoChangerTrucksLocation.UNKNOWN;
    }

    public FcsEnumerations.AutoChangerTrucksLocation getTruckLocation() {
        this.lock.lock();
        try {
            while (this.updatingTruckLocation) {
                try {
                    this.truckLocationUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)ex);
                }
            }
            FcsEnumerations.AutoChangerTrucksLocation autoChangerTrucksLocation = this.truckLocation;
            return autoChangerTrucksLocation;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void updateLocation(String hexaValueOfInputs) {
        this.lock.lock();
        try {
            this.updatingTruckLocation = true;
            FCSCst.FCSLOG.debug((Object)(this.getName() + " is updating its location in parsing the values sent by rail sensors:" + hexaValueOfInputs));
            this.railSensorStandback.updateValue(hexaValueOfInputs);
            this.railSensorStandby.updateValue(hexaValueOfInputs);
            if (this.railSensorStandby.isOn() && !this.railSensorStandback.isOn()) {
                this.truckLocation = FcsEnumerations.AutoChangerTrucksLocation.STANDBY;
            } else if (!this.railSensorStandby.isOn() && this.railSensorStandback.isOn()) {
                this.truckLocation = FcsEnumerations.AutoChangerTrucksLocation.STANDBACK;
            } else {
                if (this.railSensorStandby.isOn() && this.railSensorStandback.isOn()) {
                    this.truckLocation = FcsEnumerations.AutoChangerTrucksLocation.ERROR;
                    throw new FcsHardwareException(this.getName() + " ERROR IN READING RAIL SENSORS : a truck can't be at standby AND at standback ");
                }
                this.truckLocation = FcsEnumerations.AutoChangerTrucksLocation.UNKNOWN;
            }
            FCSCst.FCSLOG.debug((Object)("truckLocation=" + this.truckLocation.toString()));
        }
        finally {
            this.updatingTruckLocation = false;
            this.truckLocationUpdated.signal();
            this.lock.unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/rail sensor at STANDBACK=");
        if (this.railSensorStandback == null) {
            sb.append("NULL");
        } else {
            sb.append(this.railSensorStandback.getName());
        }
        sb.append("/rail sensor at STANDBY=");
        if (this.railSensorStandby == null) {
            sb.append("NULL");
        } else {
            sb.append(this.railSensorStandby.getName());
        }
        return sb.toString();
    }
}

