/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.subsystems.fcs.CarouselClampModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselClampLockSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;

public class SimuCarouselClampController
extends SimuEPOSControllerModule {
    private CarouselModule carousel;

    public SimuCarouselClampController(String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.setTickMillis(3000);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.carousel = (CarouselModule)this.getComponentLookup().getComponentByName("carousel");
        this.mode = EPOSEnumerations.EposMode.CURRENT;
    }

    @Override
    public void writeCurrent(int currentValue) {
        CarouselClampModule clamp;
        FCSCst.FCSLOG.debug((Object)(this.getName() + "==========> ACTUATOR ON"));
        if (this.getName().contains("Xminus")) {
            clamp = this.carousel.getClampXminus();
        } else if (this.getName().contains("Xplus")) {
            clamp = this.carousel.getClampXplus();
        } else {
            throw new RejectedCommandException(this.getName() + ":couldn't find the clamp to unlock");
        }
        ((SimuCarouselClampLockSensor)clamp.getLockSensor()).simulateClampIsUNLOCKED();
        this.publishData();
    }

    @Override
    public void off() {
        CarouselClampModule clamp;
        FCSCst.FCSLOG.debug((Object)(this.getName() + "==========> ACTUATOR OFF"));
        if (this.getName().contains("Xminus")) {
            clamp = this.carousel.getClampXminus();
        } else if (this.getName().contains("Xplus")) {
            clamp = this.carousel.getClampXplus();
        } else {
            throw new FailedCommandException(this.getName() + ": unable to find the clamp to unlock.");
        }
        ((SimuCarouselClampLockSensor)clamp.getLockSensor()).simulateClampIsLOCKED();
        this.turnedOff = true;
        this.publishData();
    }
}

