/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.UsesSubsystem;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;

public interface MovedByEPOSController
extends UsesSubsystem {
    public String getControllerName();

    public boolean isControllerInFault();

    public void setControllerInFault(boolean var1);

    public void publishData();

    default public void updateControllerInFault(String controllerName, Module.ValueUpdate v) {
        FCSCst.FCSLOG.finest((Object)(this.getName() + ":processUpdate from controller=" + controllerName + " ValueUpdate=" + v.getName()));
        if (v.getValue() instanceof EmergencyMessage) {
            EmergencyMessage emcyMsg = (EmergencyMessage)v.getValue();
            FCSCst.FCSLOG.finest((Object)(this.getName() + ":EmergencyMessage received from CanOpenProxy=" + emcyMsg.toString()));
            this.processEmergencyMessage(emcyMsg);
        } else if (v.getValue() instanceof String) {
            if ("faultReset".equals((String)v.getValue())) {
                this.processFaultReset();
            } else if ("inFault".equals((String)v.getValue())) {
                this.setControllerInFault(true);
            }
        }
        this.publishData();
    }

    default public void processEmergencyMessage(EmergencyMessage emcyMsg) {
        String errCode = emcyMsg.getDeviceErrorCode();
        if ("00".equals(errCode)) {
            FCSCst.FCSLOG.finest((Object)(this.getName() + ": faultReset has been done on controller. " + emcyMsg.toString()));
            this.setControllerInFault(false);
        } else {
            FCSCst.FCSLOG.finest((Object)(this.getName() + ":EmergencyMessage received for my controller from CanOpenProxy=" + emcyMsg.toString()));
            this.setControllerInFault(true);
        }
        this.publishData();
    }

    default public void processFaultReset() {
        this.setControllerInFault(false);
    }
}

