/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Observable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTruck;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerWithBrake;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class AutochangerTruckModule
extends MobileItemModule
implements MovedByEPOSController {
    protected final Lock lock = new ReentrantLock();
    private final ComplementarySensors handoffPositionSensors;
    private final ComplementarySensors onlinePositionSensors;
    private final ComplementarySensors standbyPositionSensors;
    private final EPOSControllerWithBrake controller;
    private int position;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    private boolean controllerInFault;
    private int absoluteTargetPosition = 0;
    private int relativeTargetPosition = 0;

    public AutochangerTruckModule(EPOSControllerWithBrake controller, ComplementarySensors handoffPositionSensors, ComplementarySensors onlinePositionSensors, ComplementarySensors standbyPositionSensors) {
        this.controller = controller;
        this.handoffPositionSensors = handoffPositionSensors;
        this.onlinePositionSensors = onlinePositionSensors;
        this.standbyPositionSensors = standbyPositionSensors;
    }

    @Override
    public void initModule() {
        if (this.controller == null) {
            FCSLOG.error((Object)(this.getName() + "==>>> controller == null - Please fix groovy description file."));
            throw new IllegalArgumentException(this.getName() + "==>>> null controller - fix groovy description file.");
        }
        if (this.controller instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.controller)});
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if truck is at HANDOFF position.")
    public boolean isAtHandoff() {
        return this.handoffPositionSensors.isOn();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if truck is at ONLINE position.")
    public boolean isAtOnline() {
        return this.onlinePositionSensors.isOn();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if truck is at STANDBY position.")
    public boolean isAtStandby() {
        return this.standbyPositionSensors.isOn();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Standby are equal. Doesn't read again sensors.")
    public boolean isStandbySensorsInError() {
        return this.standbyPositionSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Handoff are equal.Doesn't read again sensors.")
    public boolean isHandoffSensorsInError() {
        return this.handoffPositionSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Online are equal.Doesn't read again sensors.")
    public boolean isOnlineSensorsInError() {
        return this.onlinePositionSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if position sensors are in error.Doesn't read again sensors.")
    public boolean isPositionSensorsInError() {
        return this.isOnlineSensorsInError() || this.isHandoffSensorsInError() || this.isStandbySensorsInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return truck position.")
    public int getPosition() {
        return this.position;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="return controller name.")
    public String getControllerName() {
        return this.controller.getName();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if the controller is in fault.")
    public boolean isControllerInFault() {
        return this.controllerInFault;
    }

    @Override
    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update truck position in reading controller.")
    public void updatePosition() {
        this.position = this.controller.readPosition();
        this.publishData();
    }

    protected void updateStateWithSensors(String[] readHexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.handoffPositionSensors.updateValues(readHexaValues);
            this.onlinePositionSensors.updateValues(readHexaValues);
            this.standbyPositionSensors.updateValues(readHexaValues);
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
        }
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        this.updateControllerInFault(((EPOSController)((Object)source)).getName(), v);
    }

    public StatusDataPublishedByAutochangerTruck createStatusDataPublishedByAutoChangerTruck() {
        StatusDataPublishedByAutochangerTruck s = new StatusDataPublishedByAutochangerTruck();
        s.setControllerName(this.getControllerName());
        s.setHandoffInError(this.handoffPositionSensors.isInError());
        s.setOnlineInError(this.onlinePositionSensors.isInError());
        s.setStandbyInError(this.standbyPositionSensors.isInError());
        s.setHandoffSensorValue(this.handoffPositionSensors.isOn());
        s.setOnlineSensorValue(this.onlinePositionSensors.isOn());
        s.setStandbySensorValue(this.standbyPositionSensors.isOn());
        s.setPosition(this.position);
        s.setControllerInFault(this.controllerInFault);
        return s;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)this.createStatusDataPublishedByAutoChangerTruck()));
    }

    public void moveToAbsoluteTargetPosition(int targetPosition) {
        this.updatePosition();
        if (this.position == targetPosition) {
            FCSLOG.info((Object)(this.getName() + " is already at target position=" + targetPosition));
        } else {
            this.absoluteTargetPosition = targetPosition;
            FCSLOG.info((Object)(this.getName() + " going to absolute position: " + this.absoluteTargetPosition));
            this.executeAction(FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION, 120000L);
        }
    }

    @Override
    public boolean isCANDevicesReady() {
        return this.controller.isInitialized();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: {
                return this.position == this.absoluteTargetPosition;
            }
            case MOVE_TO_RELATIVE_POSITION: {
                return this.position == this.relativeTargetPosition;
            }
        }
        assert (false) : action;
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.controller.checkFault();
            this.position = this.controller.readPosition();
            FCSLOG.debug((Object)(this.getName() + " position=" + this.position));
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + "=> SDO ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        catch (SDORequestException ex) {
            FCSLOG.error((Object)(this.getName() + "=> SDO ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: {
                this.controller.enableAndWriteAbsolutePosition(this.absoluteTargetPosition);
                break;
            }
            case MOVE_TO_RELATIVE_POSITION: {
                this.controller.enableAndWriteRelativePosition(this.relativeTargetPosition);
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.controller.activateBrakeAndDisable();
    }
}

