/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentException;

public class CanOpenErrorsTableTest
extends CcsTestCaseTemplate {
    @BeforeClass
    public static void setUpClass() throws DeploymentException {
        System.out.println("***************************************");
        System.out.println("TESTS OF READING CANopen errors tables");
        System.out.println("loadDeviceErrorTable");
        CanOpenErrorsTable.loadDeviceErrorTable();
        System.out.println("loadErrorRegisterTable");
        CanOpenErrorsTable.loadErrorRegisterTable();
        System.out.println("loadCommunicationErrorTable");
        CanOpenErrorsTable.loadCommunicationErrorTable();
    }

    @AfterClass
    public static void tearDownClass() {
        System.out.println("********* end of CanOpenErrorsTable tests *************");
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetDeviceErrorNameByCode() throws DeploymentException {
        System.out.println("getDeviceErrorNameByCode");
        CanOpenErrorsTable.loadDeviceErrorTable();
        String aCode = "0000";
        String expResult = "No Error";
        String result = CanOpenErrorsTable.getDeviceErrorNameByCode((String)aCode);
        Assert.assertEquals((String)"Error 0000 is No Error", (Object)expResult, (Object)result);
        aCode = "FF12";
        expResult = "Auxiliary Sensor Direction Error";
        result = CanOpenErrorsTable.getDeviceErrorNameByCode((String)aCode);
        Assert.assertEquals((String)"Error FF12 is Auxiliary Sensor Direction Error", (Object)expResult, (Object)result);
        aCode = "018F112z";
        expResult = "018F112Z=device error code not found in deviceErrorCodes";
        result = CanOpenErrorsTable.getDeviceErrorNameByCode((String)aCode);
        Assert.assertEquals((String)"Error 018F112Z is 018F112Z=device error code not found in deviceErrorCodes", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetErrorRegisterNameByCode() {
        System.out.println("getErrorRegisterNameByCode");
        String aCode = "00";
        String expResult = "no errors";
        String result = CanOpenErrorsTable.getErrorRegisterNameByCode((String)aCode);
        Assert.assertEquals((String)"Error 00 is no errors", (Object)expResult, (Object)result);
        aCode = "80";
        expResult = "motion error";
        result = CanOpenErrorsTable.getErrorRegisterNameByCode((String)aCode);
        Assert.assertEquals((String)"Error 80 is motion error", (Object)expResult, (Object)result);
        aCode = "tata";
        expResult = "TATA=error register code not found in errorRegisterCodes";
        result = CanOpenErrorsTable.getErrorRegisterNameByCode((String)aCode);
        Assert.assertEquals((String)"Error tata is TATA=error register code not found in errorRegisterCodes", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetCommErrorNameByCode() {
        System.out.println("getCommErrorNameByCode");
        String aCode = "00000000";
        String expResult = "No Communication Error";
        String result = CanOpenErrorsTable.getCommErrorNameByCode((String)aCode);
        Assert.assertEquals((String)"error 00000000 is No Communication Error", (Object)expResult, (Object)result);
        aCode = "0F00FFB9";
        expResult = "Error CAN ID";
        result = CanOpenErrorsTable.getCommErrorNameByCode((String)aCode);
        Assert.assertEquals((String)"error 0F00FFB9 is Error CAN ID", (Object)expResult, (Object)result);
        aCode = "0f00ffbf";
        result = CanOpenErrorsTable.getCommErrorNameByCode((String)aCode);
        expResult = "Illegal Command Error";
        Assert.assertEquals((String)"error 0f00ffbf is 0F00FFBF and is Illegal Command Error", (Object)expResult, (Object)result);
        aCode = "TOTO";
        result = CanOpenErrorsTable.getCommErrorNameByCode((String)aCode);
        expResult = "TOTO=communication error code not found in commErrorCodes";
        Assert.assertEquals((String)"error TOTO is : TOTO=communication error code not found in commErrorCodes", (Object)expResult, (Object)result);
    }
}

