/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderCarrierController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderStandalonePlutoGateway;

public class LoaderCarrierModuleTest
extends CcsTestCaseTemplate {
    private static ComponentLookup lookup;
    private static Subsystem loaderSubsystem;
    private static LoaderCarrierModule carrier;
    private static LoaderModule loader;
    private static SimuLoaderStandalonePlutoGateway gateway;
    private static SimuLoaderCarrierController carrierController;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("*************************************************");
        System.out.println("TESTS OF LOADER CARRIER MOTION IN STANDALONE MODE");
        System.out.println("*************************************************");
        CCS.initializeScriptingEnvironment();
        loaderSubsystem = BootUtils.getSubsystemFromFile((String)"loader__simulation");
        loaderSubsystem.start();
        loaderSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        lookup = loaderSubsystem.getComponentLookup();
        carrier = (LoaderCarrierModule)lookup.getComponentByName("carrier");
        loader = (LoaderModule)lookup.getComponentByName("loader");
        gateway = (SimuLoaderStandalonePlutoGateway)lookup.getComponentByName("loaderPlutoGateway");
        carrierController = (SimuLoaderCarrierController)lookup.getComponentByName("carrierController");
    }

    @AfterClass
    public static void after() throws Exception {
        loaderSubsystem.shutdown();
        loaderSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 60L, TimeUnit.SECONDS);
        CCS.shutdownScriptingEnvironment();
    }

    @Before
    public void setUp() {
        gateway.simulateFilterIsOnLoader();
        gateway.simulateLoaderClampIsClamped();
        gateway.simulateLoaderIsConnectedOnCamera();
        gateway.simulateLoaderCarrierIsAtHandoff();
        loader.updateStateWithSensors();
    }

    @After
    public void tearDown() throws Exception {
        loaderSubsystem.clearAllAlerts();
    }

    @Test
    public void testGetControllerName() {
        System.out.println("###getControllerName");
        String ctlrName = carrier.getControllerName();
        Assert.assertTrue((String)("Carrier controller name should contains String carrier " + ctlrName), (boolean)ctlrName.contains("carrier"));
    }

    @Test
    public void testIsStorageSensorsInError() {
        System.out.println("### isStorageSensorsInError");
        gateway.simulateStorageSensorsAreInError();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"carrier handoff sensors are in error.", (boolean)carrier.isStorageSensorsInError());
        Assert.assertTrue((String)"carrier handoff sensors are in error.", (boolean)carrier.isInError());
    }

    @Test
    public void testIsHandoffSensorsInError() {
        System.out.println("### isHandoffSensorsInError");
        gateway.simulateHandoffSensorsAreInError();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"carrier handoff sensors are in error.", (boolean)carrier.isHandoffSensorsInError());
        Assert.assertTrue((String)"carrier handoff sensors are in error.", (boolean)carrier.isInError());
    }

    @Test
    public void testCheckHardware() throws Exception {
        System.out.println("### checkHardware");
        TreeWalkerDiag treeWalker = carrier.checkHardware();
        Assert.assertEquals((Object)TreeWalkerDiag.HANDLING_CHILDREN, (Object)treeWalker);
        Assert.assertTrue((String)"carrier controller is initialized", (boolean)carrierController.isInitialized());
    }

    @Test
    public void testInitializeHardware() throws Exception {
        System.out.println("### initializeHardware");
        carrier.initializeHardware();
        Assert.assertTrue((String)"carrier is initialized", (boolean)carrier.isInitialized());
    }

    @Test
    public void testGoToHandOff() {
        System.out.println("### goToHandOff");
        carrier.goToHandOff();
        Assert.assertTrue((String)"carrier is still at HANDOFF position", (boolean)carrier.isAtHandoffPosition());
        gateway.simulateLoaderCarrierIsAtStorage();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"carrier is now at STORAGE position", (boolean)carrier.isAtStoragePosition());
        carrier.goToHandOff();
        Assert.assertTrue((String)"carrier is again at HANDOFF position", (boolean)carrier.isAtHandoffPosition());
    }

    @Test
    public void testGoToStorage() {
        System.out.println("### goToStorage");
        carrier.goToStorage();
        Assert.assertTrue((String)"carrier is now at STORAGE position", (boolean)carrier.isAtStoragePosition());
    }

    @Test
    public void testGoToAbsolutePosition() {
        System.out.println("### goToAbsolutePosition");
        int absolutePosition = 500;
        carrier.goToAbsolutePosition(absolutePosition);
        Assert.assertEquals((String)("carrier position is now " + absolutePosition), (long)absolutePosition, (long)carrier.getPosition());
    }

    @Test
    public void testReadPosition() {
        System.out.println("### readPosition");
        Assert.assertEquals((String)"readPosition is equals to getPosition", (long)carrier.getPosition(), (long)carrier.readPosition());
    }

    static {
        loaderSubsystem = null;
    }
}

