/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.subsystems.fcs.ForceSensor;

public class ForceSensorTest {
    static ForceSensor forceSensor;
    static String[] hexaValues;

    @BeforeClass
    public static void setUpClass() {
        int byteNumero = 0;
        forceSensor = new ForceSensor(byteNumero);
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        ForceSensorTest.hexaValues[0] = "10";
        forceSensor.updateForce(hexaValues);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetVoltage() {
        System.out.println("getAnalogValue");
        int expResult = 1600;
        int result = forceSensor.getVoltage();
        Assert.assertEquals((String)"voltage is 1600", (long)expResult, (long)result);
    }

    @Test
    public void testGetForce() {
        System.out.println("getForce");
        double expResult = 321.13;
        double result = forceSensor.getForce();
        Assert.assertEquals((double)expResult, (double)result, (double)0.0);
    }

    @Test
    public void testUpdateForce() {
        System.out.println("updateForce");
        double expResult = 1600.0;
        double result = forceSensor.getVoltage();
        double delta = 0.0;
        Assert.assertEquals((double)expResult, (double)result, (double)delta);
        ForceSensorTest.hexaValues[0] = "11";
        forceSensor.updateForce(hexaValues);
        expResult = 1700.0;
        result = forceSensor.getVoltage();
        Assert.assertEquals((double)expResult, (double)result, (double)delta);
        ForceSensorTest.hexaValues[0] = "12";
        forceSensor.updateForce(hexaValues);
        expResult = 1800.0;
        result = forceSensor.getVoltage();
        Assert.assertEquals((double)expResult, (double)result, (double)delta);
    }

    @Test
    public void testTransfertFunction() {
        System.out.println("transfertFunction");
        int tension = 0;
        double expResult = 0.0;
        double result = forceSensor.transfertFunction(tension);
        double delta = 0.0;
        Assert.assertEquals((double)expResult, (double)result, (double)delta);
        tension = 947;
        expResult = 0.0;
        result = forceSensor.transfertFunction(tension);
        Assert.assertEquals((double)expResult, (double)result, (double)delta);
        tension = 1000;
        expResult = 25.21;
        delta = 1.0E-4;
        result = forceSensor.transfertFunction(tension);
        Assert.assertEquals((double)expResult, (double)result, (double)delta);
        tension = 1700;
        expResult = 370.45;
        delta = 1.0E-4;
        result = forceSensor.transfertFunction(tension);
        Assert.assertEquals((double)expResult, (double)result, (double)delta);
        tension = 1800;
        expResult = 419.77;
        delta = 1.0E-4;
        result = forceSensor.transfertFunction(tension);
        Assert.assertEquals((double)expResult, (double)result, (double)delta);
        tension = 2000;
        expResult = 518.41;
        delta = 1.0E-4;
        result = forceSensor.transfertFunction(tension);
        Assert.assertEquals((double)expResult, (double)result, (double)delta);
        tension = 2550;
        expResult = 789.67;
        delta = 1.0E-4;
        result = forceSensor.transfertFunction(tension);
        Assert.assertEquals((double)expResult, (double)result, (double)delta);
        tension = 25500;
        expResult = 12108.61;
        delta = 1.0E-4;
        result = forceSensor.transfertFunction(tension);
        Assert.assertEquals((double)expResult, (double)result, (double)delta);
    }

    @Test
    public void testIsClamped() {
        System.out.println("isClamped");
        Assert.assertFalse((String)"clamp is not CLAMPED", (boolean)forceSensor.isClamped());
        ForceSensorTest.hexaValues[0] = "1a";
        forceSensor.updateForce(hexaValues);
        double expResult = 2600.0;
        int voltage = forceSensor.getVoltage();
        double delta = 0.0;
        Assert.assertEquals((double)expResult, (double)voltage, (double)delta);
        expResult = 814.33;
        delta = 1.0E-4;
        Assert.assertEquals((double)expResult, (double)forceSensor.getForce(), (double)delta);
        Assert.assertTrue((String)"clamp is CLAMPED", (boolean)forceSensor.isClamped());
        ForceSensorTest.hexaValues[0] = "FF";
        forceSensor.updateForce(hexaValues);
        expResult = 25500.0;
        voltage = forceSensor.getVoltage();
        Assert.assertEquals((double)expResult, (double)voltage, (double)delta);
        expResult = 12108.61;
        Assert.assertEquals((double)expResult, (double)forceSensor.getForce(), (double)delta);
        Assert.assertFalse((String)"clamp is NOT CLAMPED", (boolean)forceSensor.isClamped());
    }

    static {
        hexaValues = new String[1];
    }
}

