/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutochangerLatchModule;
import org.lsst.ccs.subsystems.fcs.AutochangerMainModule;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerLatchController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerStandalonePlutoGateway;

public class AutochangerLatchModuleTest {
    private static Subsystem autochangerSubsystem = null;
    private static AutochangerMainModule main;
    private static AutoChangerModule autochanger;
    private static AutochangerTwoLatches latches;
    private static AutochangerLatchModule latchXminus;
    private static AutochangerLatchModule latchXplus;
    private static SimuAutochangerStandalonePlutoGateway plutoGateway;
    private static SimuAutochangerLatchController latchXminusController;
    private static SimuAutochangerLatchController latchXplusController;
    private static AutochangerLatchModule[] latchesList;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("*****************************************************");
        System.out.println("TESTS OF AUTOCHANGER LATCH MODULE IN STANDALONE MODE");
        System.out.println("*****************************************************");
        CCS.initializeScriptingEnvironment();
        autochangerSubsystem = BootUtils.getSubsystemFromFile((String)"autochanger__simulation");
        autochangerSubsystem.start();
        autochangerSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = autochangerSubsystem.getComponentLookup();
        main = (AutochangerMainModule)lookup.getComponentByName("main");
        autochanger = (AutoChangerModule)lookup.getComponentByName("autochanger");
        autochanger.updateStateWithSensors();
        plutoGateway = (SimuAutochangerStandalonePlutoGateway)lookup.getComponentByName("acSensorsGateway");
        latches = (AutochangerTwoLatches)lookup.getComponentByName("latches");
        latchXminus = (AutochangerLatchModule)lookup.getComponentByName("latchXminus");
        latchXplus = (AutochangerLatchModule)lookup.getComponentByName("latchXplus");
        latchesList = new AutochangerLatchModule[]{latchXminus, latchXplus};
        latchXminusController = (SimuAutochangerLatchController)lookup.getComponentByName("latchXminusController");
        latchXplusController = (SimuAutochangerLatchController)lookup.getComponentByName("latchXplusController");
        Assert.assertTrue((String)"After initialization phase, simulated hardware should be ready.", (boolean)main.isCANDevicesReady());
    }

    @AfterClass
    public static void after() throws Exception {
        autochangerSubsystem.shutdown();
        autochangerSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        CCS.shutdownScriptingEnvironment();
    }

    @Before
    public void setUp() {
        System.out.println("*************************  setUp    ************************************");
        System.out.println("*** go back to initial conditions: autochanger empty and latches UNLOCKED");
        System.out.println("*** simulateAutochangerIsEmpty");
        plutoGateway.simulateAutochangerIsEmpty();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger should be empty", (boolean)autochanger.isEmpty());
        System.out.println("*** simulateAutochangerAreUnlocked");
        plutoGateway.simulateAutochangerLatchesAreUnlocked();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Latches are UNLOCKED", (boolean)latches.isUnlocked());
        plutoGateway.simulateAutochangerTrucksAreAtStandby();
        plutoGateway.simulateCarouselIsNotHoldingFilter();
        plutoGateway.simulateLoaderIsNotHoldingFilter();
        main.updateStateWithSensors();
        autochangerSubsystem.clearAllAlerts();
    }

    @Test
    public void testGetControllerName() {
        System.out.println("### getControllerName");
        Assert.assertEquals((String)"latchXminus controller name is latchXminusController", (Object)"latchXminusController", (Object)latchXminus.getControllerName());
        Assert.assertEquals((String)"latchXplus controller name is latchXplusController", (Object)"latchXplusController", (Object)latchXplus.getControllerName());
    }

    @Test
    public void testGetLatchController() {
        System.out.println("### getLatchController");
        Assert.assertSame((String)"latchXminus.getLatchController() IS latchXminusController", (Object)latchXminusController, (Object)latchXminus.getLatchController());
        Assert.assertSame((String)"latchXplus.getLatchController() IS latchXplusController", (Object)latchXplusController, (Object)latchXplus.getLatchController());
    }

    @Test
    public void testSetControllerInFault() {
        System.out.println("### setControllerInFault");
        latchXminus.setControllerInFault(true);
        Assert.assertTrue((String)"latchXminusController should be in fault", (boolean)latchXminus.isControllerInFault());
        latchXminus.setControllerInFault(false);
        Assert.assertFalse((String)"latchXminusController should not be in fault", (boolean)latchXminus.isControllerInFault());
    }

    @Test
    public void testIsInitialized() {
        System.out.println("### isInitialized");
        Assert.assertTrue((String)"in simulation hardware should be always initialized", (boolean)latchXplus.isInitialized());
    }

    @Test
    public void testGetLockStatus() {
        System.out.println("### getLockStatus");
        plutoGateway.simulateAutochangerLatchIsLocked("latchXminus");
        autochanger.updateStateWithSensors();
        Assert.assertEquals((String)"latchXminus lockStatus should be LOCKED", (Object)FcsEnumerations.LockStatus.LOCKED, (Object)latchXminus.getLockStatus());
        plutoGateway.simulateAutochangerLatchIsLocked("latchXplus");
        autochanger.updateStateWithSensors();
        Assert.assertEquals((String)"latchXplus lockStatus should be LOCKED", (Object)FcsEnumerations.LockStatus.LOCKED, (Object)latchXplus.getLockStatus());
        plutoGateway.simulateAutochangerLatchIsUnlocked("latchXminus");
        autochanger.updateStateWithSensors();
        Assert.assertEquals((String)"latchXminus lockStatus should be UNLOCKED", (Object)FcsEnumerations.LockStatus.UNLOCKED, (Object)latchXminus.getLockStatus());
        plutoGateway.simulateAutochangerLatchIsUnlocked("latchXplus");
        autochanger.updateStateWithSensors();
        Assert.assertEquals((String)"latchXplus lockStatus should be UNLOCKED", (Object)FcsEnumerations.LockStatus.UNLOCKED, (Object)latchXplus.getLockStatus());
    }

    @Test
    public void testIsLocked() {
        System.out.println("### isLocked");
        plutoGateway.simulateAutochangerLatchIsLocked("latchXminus");
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"latchXminus should be locked", (boolean)latchXminus.isLocked());
        plutoGateway.simulateAutochangerLatchIsLocked("latchXplus");
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"latchXplus should be locked", (boolean)latchXplus.isLocked());
    }

    @Test
    public void testIsUnlocked() {
        System.out.println("### isUnlocked");
        plutoGateway.simulateAutochangerLatchIsUnlocked("latchXminus");
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"latchXminus should be unlocked", (boolean)latchXminus.isUnlocked());
        plutoGateway.simulateAutochangerLatchIsUnlocked("latchXplus");
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"latchXplus should be unlocked", (boolean)latchXplus.isUnlocked());
    }

    @Test
    public void testIsInError() {
        System.out.println("### isInError");
        plutoGateway.simulateLatchLockSensorsInError("latchXminus");
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"latchXminus should be in ERROR", (boolean)latchXminus.isInError());
        plutoGateway.simulateLatchLockSensorsInError("latchXplus");
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"latchXplus should be in ERROR", (boolean)latchXplus.isInError());
    }

    @Test
    public void testIsEmpty() {
        System.out.println("### isEmpty");
        plutoGateway.simulateFilterIsOnAutochanger();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"latchXminus should NOT be empty", (boolean)latchXminus.isEmpty());
        Assert.assertFalse((String)"latchXminus should NOT be empty", (boolean)latchXminus.isEmpty());
    }

    @Test
    public void testCheckSensors() {
        System.out.println("### checkSensors");
        plutoGateway.simulateAutochangerLatchesAreLocked();
        autochanger.updateStateWithSensors();
        try {
            latchXminus.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR);
        }
        catch (Exception ex) {
            System.out.println("NO ERROR: checkSensors should not throw an exception " + ex);
        }
        plutoGateway.simulateLatchLockSensorsInError("latchXplus");
        autochanger.updateStateWithSensors();
        try {
            latchXplus.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR);
            Assert.fail((String)"latchXplus an Exception should be thrown");
        }
        catch (Exception ex) {
            System.out.println("Exception thrown:" + ex);
            Assert.assertTrue((boolean)autochangerSubsystem.isInState((Enum)AlertState.ALARM));
        }
    }

    public void testUpdateCurrent() {
        System.out.println("updateCurrent");
        latchXminus.updateCurrent();
    }

    @Test
    public void testIsCANDevicesReady() {
        System.out.println("### isCANDevicesReady");
        Assert.assertEquals((String)"isCANDevicesReady() returns autochanger.isCANDevicesReady()", (Object)autochanger.isCANDevicesReady(), (Object)latchXminus.isCANDevicesReady());
    }

    @Test
    public void testClose() {
        System.out.println("### close");
        try {
            latchXminus.close();
            Assert.fail((String)"close latch should fail because autochanger is empty");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        plutoGateway.simulateFilterIsOnAutochanger();
        main.updateStateWithSensors();
        latchXminus.close();
        Assert.assertTrue((String)"latchXminus is now closed", (boolean)latchXminus.isLocked());
        latchXplus.close();
        Assert.assertTrue((String)"latchXplus is now closed", (boolean)latchXplus.isLocked());
    }

    @Test
    public void testOpen() {
        System.out.println("### test open");
        this.testOpenALatch(latchXplus);
        Assert.assertTrue((String)"latchXplus should be opened", (boolean)latchXplus.isUnlocked());
    }

    private void testOpenALatch(AutochangerLatchModule latch) {
        System.out.println("### testing open latch " + latch.getName());
        try {
            latch.open();
            Assert.fail((String)(latch.getName() + " is already openened, a RejectedCommendException should be thrown."));
        }
        catch (Exception ex) {
            System.out.println("RejectedCommendException thrown:" + ex);
        }
        plutoGateway.simulateFilterIsOnAutochanger();
        main.updateStateWithSensors();
        latch.close();
        Assert.assertTrue((String)(latch.getName() + " is now locked"), (boolean)latch.isLocked());
        try {
            latch.open();
            Assert.fail((String)(latch.getName() + " command open should have failed because filter is not held by loader or carousel"));
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        plutoGateway.simulateCarouselIsHoldingFilter();
        main.updateStateWithSensors();
        latch.open();
        Assert.assertTrue((String)(latch.getName() + " is now unlocked"), (boolean)latch.isUnlocked());
    }

    @Test
    public void testPostAction() {
        System.out.println("postAction");
        FcsEnumerations.MobileItemAction action = FcsEnumerations.MobileItemAction.CLOSE;
        for (AutochangerLatchModule latch : latchesList) {
            latch.postAction(action);
            Assert.assertEquals((String)"current is 0 at the end of the action", (long)0L, (long)latch.getLatchController().readCurrent());
        }
    }

    @Test
    public void testCreateStatusDataPublishedByLatch() {
        System.out.println("createStatusDataPublishedByLatch");
        StatusDataPublishedByAutochangerLatch status = latchXminus.createStatusDataPublishedByLatch();
        Assert.assertEquals((String)"LockStatus published should be latchXminus lockStatus", (Object)latchXminus.getLockStatus(), (Object)status.getLockStatus());
        Assert.assertEquals((String)"Name published should be latchXminus name", (Object)latchXminus.getName(), (Object)status.getName());
    }
}

