/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.framework.Module;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenThermometer;

/**
 * This is the main module for the control software of the APC test bench.
 *
 * When the TestBenchMainModule starts, it starts a a TCP-IP server. the can
 * open wrapper software will connect. Then the TestBenchProxy and the Wrapper
 * will communicate over this TCP connection with a protocol to be define. In a
 * first version : 1- The TCP server is started and waits for a client
 * connection, 2- When the client connects, it sends first a key word
 * "TestBench". 3- When the server receives the key word "TestBench", it's ready
 * to boot the hardware and receive commands.
 *
 * @author virieux
 */
public class APCTestBenchMainModule extends Module {

    private final BridgeToHardware bridge;

    /**
     * * The thermometer mesures the temperature inside the clamp.
     */
    private final CanOpenThermometer thermometer;
    private final CanOpenLED led;
    private final CanOpenLED fakeLed;
    private final CanOpenThermometer fakeSensor;

    public double temperature;

    public APCTestBenchMainModule(String name, int tickMillis,
            BridgeToHardware bridge, 
            CanOpenThermometer thermometer, 
            CanOpenLED led, CanOpenLED fakeLed, 
            CanOpenThermometer fakeSensor) {
        super(name, tickMillis);
        this.bridge = bridge;
        this.thermometer = thermometer;
        this.led = led;
        this.fakeLed = fakeLed;
        this.fakeSensor = fakeSensor;
    }


    
    

    /**
     * Returns the value read on the socket for the input of the ADC given as an
     * argument.
     *
     * @param responseLine A string read on the socket.
     * @param inputNB The numero if the input on the ADC. (1<=inputNB<=8)
     * @return the value (int) given
     */
    public int getReturnValue(String responseLine, int inputNB) 
    {
        if (inputNB < 1 || inputNB > 8) 
        {
            throw new IllegalArgumentException();
        }
        String[] words = responseLine.split(",");
        //String command = words[0];
        FCSLOG.debug("Value in HEXA:" + words[inputNB]);
        int value = Integer.parseInt(words[inputNB], 16);
        FCSLOG.debug("Value in decimal:" + words[inputNB]);
        return value;
    }

    public double readTemperature()  {
        return this.thermometer.readTemperature();
    }

    public double readTemperatureFromPDO()   {
        PDOStorage pdoStore = this.bridge.readPDOs();
        return this.thermometer.readTemperatureWithPDO(pdoStore);
    }

    public String turnOnLED()  {
        return led.turnON();
    }

    public String turnOffLED()  {
        return led.turnOFF();
    }

    public String turnOnFakeLED()  {
        return fakeLed.turnON();
    }

    public String turnOffFakeLED()  {
        return fakeLed.turnOFF();
    }

    public double readFakeSensor()  {
        PDOStorage pdoStore = this.bridge.readPDOs();
        return this.fakeSensor.readTemperatureWithPDO(pdoStore);
    }


}
