
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.framework.Module;

/**
 *
 * @author virieux
 */
public abstract class SftTruckMotor extends Module {

    /* FOR THE GUI 
     * 
     */
    private volatile boolean movingToStandby;
    private volatile boolean movingToStandback;

    /**
     * Build a SftTruckMotor with a tickMillis value of 5000. 
     */
    public SftTruckMotor() {
        super(5000);
    }

    

    public boolean isMovingToStandback() {
        return movingToStandback;
    }

    public boolean isMovingToStandby() {
        return movingToStandby;
    }

    public void setMovingToStandback(boolean movingToStandback) {
        this.movingToStandback = movingToStandback;
        setChanged();
        this.notifyObservers(new ValueUpdate("IsMovingToStandback", movingToStandback));
    }

    public void setMovingToStandby(boolean movingToStandby) {
        this.movingToStandby = movingToStandby;
        setChanged();
        this.notifyObservers(new ValueUpdate("IsMovingToStandby", movingToStandby));
    }

    public abstract String moveToStandback();

    public abstract String moveToStandby();

    public abstract String off();

}
