
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import static org.lsst.ccs.subsystems.fcs.utils.FcsUtils.TICKMILLIS;

/**
 * For the single-filter-test, a model for the actuator which opens and close
 * the latches to release or hold a filter.
 *
 * @author virieux
 */
public abstract class LatchActuatorModule extends Module {

    @ConfigurationParameter(description="decimal value of the current limit (in Ampere) to determine the couple")
    protected double currentLimitInVolt = 0.150; // to limit the current sent to the motor
    
    @ConfigurationParameter(range="-10..10",
            description="decimal value of the voltage (in Volt) to send to the actuator to determine the speed")
    protected double speedVoltageInVolt = 4; // to start the motor

    //for the GUI
    @ConfigurationParameter(description="minimal decimal value of the speed voltage (used for the GUI)")
    public int speedVoltageMinValue = -10;
    
    //for the GUI
    @ConfigurationParameter(description="maximal decimal value of the speed voltage (used for the GUI)")
    public int speedVoltageMaxValue = 10;

    /**
     * Build a LatchActuatorModule with a tickMillis value of 3000 ms.
     * @param currentLimitInVolt
     * @param speedVoltageInVolt
     * @param speedVoltageMinValue
     * @param speedVoltageMaxValue 
     */
    public LatchActuatorModule(double currentLimitInVolt, 
            double speedVoltageInVolt, int speedVoltageMinValue, int speedVoltageMaxValue) {
        super(TICKMILLIS);
        this.currentLimitInVolt = currentLimitInVolt;
        this.speedVoltageInVolt = speedVoltageInVolt;
        this.speedVoltageMinValue = speedVoltageMinValue;
        this.speedVoltageMaxValue = speedVoltageMaxValue;
    }

    /**
     * ***********************************************************************************************
     */
    /**
     * ******************** SETTERS AND GETTERS  *****************************************************
     */
    /**
     * ***********************************************************************************************
     */
    public double getCurrentLimitInVolt() {
        return currentLimitInVolt;
    }

    public void setCurrentLimitInVolt(double currentLimitInVolt) {
        this.currentLimitInVolt = currentLimitInVolt;
    }

    public double getSpeedVoltageInVolt() {
        return speedVoltageInVolt;
    }

    public void setSpeedVoltageInVolt(int speedVoltageInVolt) {
        this.speedVoltageInVolt = speedVoltageInVolt;
    }

    public int getSpeedVoltageMaxValue() {
        return speedVoltageMaxValue;
    }

    public void setSpeedVoltageMaxValue(int speedVoltageMaxValue) {
        this.speedVoltageMaxValue = speedVoltageMaxValue;
    }

    public int getSpeedVoltageMinValue() {
        return speedVoltageMinValue;
    }

    public void setSpeedVoltageMinValue(int speedVoltageMinValue) {
        this.speedVoltageMinValue = speedVoltageMinValue;
    }

    /**
     * ***********************************************************************************************
     */
    /**
     * ******************** END OF SETTERS AND GETTERS  **********************************************
     */
    /**
     * ***********************************************************************************************
     */
    /**
     * This is the command that has to be sent to the latch actuator to open the
     * latch (same as unlock it).
     *
     * @return
     * @throws FailedCommandException
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException
     */
    public abstract String open() ;

    /**
     * This is the command that has to be sent to the latch actuator to close
     * the latch it (same as lock it).
     *
     * @return
     * @throws FailedCommandException
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException
     */
    public abstract String close() ;

    /**
     * Power off the latch actuator.
     *
     * @return
     * @throws FailedCommandException
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException
     */
    public abstract String powerOff() ;

}
