
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.List;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FilterIdentificator;

/**
 * To test SimuFilterIDPlutoGatewayInterface.
 * Used only in FilterIdentificatorTest.
 * 
 * @author virieux
 */
public class SimuPlutoGatewayWithFilterID extends SimuPlutoGateway implements SimuFilterIDPlutoGatewayInterface {
    
    private FilterIdentificator filterIdentificator;

    /**
     * Build a new SimuPlutoGatewayWithFilterID
     * @param nodeID
     * @param serialNB 
     */
    public SimuPlutoGatewayWithFilterID(String nodeID, String serialNB) {
        super(nodeID, serialNB);
    }
    
    @Override
    public void initModule() {
        super.initModule();
        filterIdentificator = (FilterIdentificator) getComponentLookup().getComponentByName("filterIdentificator");
    }

    /**
     * return a list of filterID sensors.
     * @return 
     */
    @Override
    public List<DigitalSensor> getFilterIDSensors() {
        return filterIdentificator.getFilterIDSensors();
    }

}
