
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;

/**
 * Used only for Simulation to simulate a gateway where we read the fake autochanger sensor.
 * In carousel-standalone subsystem, there is an electric switch connected to a numeric sensor.
 * This sensor : autochangerHoldingFilterSensor simulates that the autochnager is holding a filter or not.
 * Therefore we can do mechanical tests of unlocking clamps.
 *
 * @author virieux
 */
public class SimuCarouselStandalonePlutoGateway extends SimuPlutoGateway {
    
    private DigitalSensor autochangerHoldingFilterSensor0;
    private DigitalSensor autochangerHoldingFilterSensor1;

    /**
     * Build a new SimuCarouselStandalonePlutoGateway
     * @param nodeID
     * @param serialNB 
     */
    public SimuCarouselStandalonePlutoGateway(String nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.autochangerHoldingFilterSensor0 = (DigitalSensor) getComponentLookup().
                getComponentByName("autochangerHoldingFilterSensor0");
        this.autochangerHoldingFilterSensor1 = (DigitalSensor) getComponentLookup().
                getComponentByName("autochangerHoldingFilterSensor1");
        simulateAutochangerIsNotHoldingFilter();
    }
    
    /**
     * For the simulation software, set autochangerHoldingFilterSensor value to 1.
     */
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerIsHoldingFilter() {
        replaceHexaValues(autochangerHoldingFilterSensor0, true);
        replaceHexaValues(autochangerHoldingFilterSensor1, false);
    }

    /**
     * For the simulation software, set autochangerHoldingFilterSensor value to 0.
     */
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerIsNotHoldingFilter() {
        replaceHexaValues(autochangerHoldingFilterSensor0, false);
        replaceHexaValues(autochangerHoldingFilterSensor1, true);
    }
}
