/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.framework.TreeWalkerDiag;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 * The tcp server for the loader when we want to connect or disconnect loader
 * hardware. So this tcp proxy won't start during initialisation phase.
 *
 * @author virieux
 */
public class LoaderCanOpenProxy extends CanOpenProxy {

    public LoaderCanOpenProxy(int portNumber, int fieldBusTimeout, String clientName, long hardwareBootTimeout) {
        super(portNumber, fieldBusTimeout, clientName, hardwareBootTimeout);
    }

    /**
     * We don't want the tcp server to be started during INITIALISATION phase.
     */
    @Override
    public void start() {
        FCSLOG.debug(getName() + ": START DU TCP PROXY DU LOADER");
    }

    /**
     * We want that the checkHardware method does nothing during INITIALISATION
     * phase for the loader tcpProxy because the loader might be not connected.
     *
     * @return
     * @throws org.lsst.ccs.HardwareException
     */
    @Override
    public TreeWalkerDiag checkHardware() throws org.lsst.ccs.HardwareException {
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    /**
     * This methods connect the CWrapper client, and the TCP server and check
     * the hardware.
     *
     * @throws org.lsst.ccs.HardwareException
     */
    @Override
    public void connectHardware() throws HardwareException {
        super.connectHardware();
        try {
            super.checkHardware();
        } catch (HardwareException ex) {
            FCSLOG.error(getName() + ": ERROR in connecting hardware");
            throw ex;
        }
    }
}
