
package org.lsst.ccs.subsystems.fcs;

/**
 * Represents a couple of sensors which are redondant : that means they must have the same digitalValue.
 * If the 2 sensors have different digital value, the couple of sensors is in error.
 * 
 * This sort of sensors are used in loader carrier.
 * The goal is to be able to detect errors in sensors (capteur défectueux, error de câblage)
 * 
 * @author virieux
 */
public class RedondantSensors {
    
    /**
     * one sensor of the couple of RedondantSensors
     */
    private final DigitalSensor sensor;
    
    /**
     * redondant sensor
     */
    private final DigitalSensor sensorR;

    /**
     * builds a RedondantSensors object from a couple of sensors.
     * @param sensor
     * @param sensorR 
     */
    public RedondantSensors(DigitalSensor sensor, DigitalSensor sensorR) {
        this.sensor = sensor;
        this.sensorR = sensorR;
    }

    /**
     * for simulation
     * @return 
     */
    public DigitalSensor getSensor() {
        return sensor;
    }

    /**
     * for simulation
     * @return 
     */
    public DigitalSensor getSensorR() {
        return sensorR;
    }
    
    

    /**
     * returns true if sensors send different values.
     * @return 
     */
    public boolean isInError() {
        return sensor.isOn() != sensorR.isOn();
    }

     /**
     * 
     * @return true if both sensors value is 1
     */
    public boolean isOn() {
        return sensor.isOn() && sensorR.isOn();
    }
    
    
    /**
     * Updates sensors values from an array of hexadecimal values.
     * @param hexaValues 
     */
    public synchronized void updateValues(String[] hexaValues) {
        sensor.updateValue(hexaValues);
        sensorR.updateValue(hexaValues);
    }    
    

}
