// see documentation on single-filter-test on : https://confluence.slac.stanford.edu/display/LSSTCAM/Single+Filter+Test
package sftHardware

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.singlefiltertest.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.description.groovy.CCSBuilder


//Carousel Can Open Devices (CAN-CBX-AI814)
def adcName = "ai814"
//Autochanger Can Open Devices
def dacName = "ao412"  // to control the latches actuator
def railsSensorsDIOName = "dio8n1"  // to control the trucks and monitor the rails sensors
def filterSensorsDIOName = "dio8n2" // to monitor the filter sensors

CCSBuilder builder = ["single-filter-test"]

builder.
    main ( SftMainModule, bridge:ref("tcpProxy"),dummyFilter:ref("dummyFilter")) {
    // tcp Proxy
    tcpProxy (CanOpenProxy,
        portNumber:54000,
        fieldBusTimeout:2000,
        clientName:"TestBench",
        hardwareBootTimeout:1000) {
        
        // can open devices
        ai814 (CanOpenADC, 
            nodeID:"21", serialNB:"c7c40234",transmissionType:"1")

        ao412 (CanOpenDAC,
            nodeID:"22",serialNB:"c7c60307")

        dio8n1 (CompactIOModule,
            nodeID:"23", serialNB:"c7ca0914")

        dio8n2 (CompactIOModule,
            nodeID:"24", serialNB:"c7ca0913")

        clampXminusController (CanOpenEPOS,    
            nodeID:"1a", serialNB:"79003317",
            paramsForCurrent:[
                MotorType:11, PositionSensorType:3,PolePairNumber:8,
                ContinuousCurrentLimit:2360,OutputCurrentLimit:4720,
                ThermalTimeConstantWinding:160,
                MaxSpeedInCurrentMode:25],
            paramsForProfilePosition:[MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])  

        clampXplusController (CanOpenEPOS,
            nodeID:"1b", serialNB:"79003313",
            paramsForCurrent:[
                MotorType:11, PositionSensorType:3,PolePairNumber:8,
                ContinuousCurrentLimit:2360,OutputCurrentLimit:4720,
                ThermalTimeConstantWinding:160, MaxSpeedInCurrentMode:25],
            paramsForProfilePosition:[MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])
                              
    }
    
    //-------------------------
    // BEGIN Filter description
    
    dummyFilter (Filter, filterID:10, weight:44, socketName:"socket1")
                                
    // BEGIN Carousel description
    carousel (SftCarouselModule) {

        socket1 ( CarouselSocket,
            clampXminus:ref("clampXminus"),
            clampXplus:ref("clampXplus"),
            position:0, standbyPosition:0) {
                                
            clampXminus (CarouselClampModule,
                filterPresenceSensor:ref("filterPresenceXminus"),
                lockSensor:ref("lockSensorXminus"),
                thermometer:ref("thermometerXminus")) {

                filterPresenceXminus (CanOpenSensor14bits, adcName:adcName, numOfAnalogInput:5)

                lockSensorXminus (CanOpenSensor14bits, adcName:adcName, numOfAnalogInput:7) 

                thermometerXminus ( CanOpenThermometer, adcName:adcName, numOfAnalogInput:6)

            }
            // BEGIN clampXplus description  
            clampXplus (CarouselClampModule,
                filterPresenceSensor:ref("filterPresenceXplus"),
                lockSensor:ref("lockSensorXplus"),
                thermometer:ref("thermometerXplus")) {
                    
                    filterPresenceXplus (CanOpenSensor14bits,
                        adcName:adcName, numOfAnalogInput:1)

                    lockSensorXplus (CanOpenSensor14bits,
                        adcName:adcName, numOfAnalogInput:3)

                    thermometerXplus ( CanOpenThermometer,
                        adcName:adcName, numOfAnalogInput:2)
                }
            }
        }//end description of carousel's children
        //END Carousel description

    //BEGIN AUTO CHANGER
    autochanger (SftAutoChangerModule,
        latchXminus:ref("latchXminus"),
        latchXplus:ref("latchXplus"),
        truckXminus:ref("truckXminus"),
        truckXplus:ref("truckXplus"),
        railsSensorsDIOName:railsSensorsDIOName,
        filterSensorsDIOName:filterSensorsDIOName,
        sftTrucksMotor:ref("sftTrucksMotor")) {

        //BEGIN  SFT TRUCKS MOTOR (AUTOCHANGER)
        sftTrucksMotor(CanOpenTruckMotor,
            dioName:railsSensorsDIOName,
            outputNumeroToStandby:2,
            outputNumeroToStandback:1)

        //BEGIN  latchMinux    (AUTOCHANGER)
        latchXminus (SftFilterLatchModule,
            filterSensorsDIOName:filterSensorsDIOName,
            lockSensor:ref("lockSensorLatchXminus"),
            unlockSensor:ref("unlockSensorLatchXminus"),
            filterPresenceSensor:ref("filterPresenceSensorLatchXminus"),
            latchActuator:ref("latchActuatorXminus")) {
            
            lockSensorLatchXminus ( DigitalSensor ,
                dioName:filterSensorsDIOName, inputNumero:1, byteNumero:1)
                                    
            unlockSensorLatchXminus ( DigitalSensor ,
                dioName:filterSensorsDIOName, inputNumero:2, byteNumero:1)

        filterPresenceSensorLatchXminus ( DigitalSensor ,
            dioName:filterSensorsDIOName, inputNumero:0, byteNumero:1)

            latchActuatorXminus (CanOpenLatchActuatorModule,
                currentLimitInVolt:0.150,
                speedVoltageInVolt:4,
                speedVoltageMaxValue:10,
                speedVoltageMinValue:-10,
                dacName:dacName,
                numOfAnalogOutputForSpeedVoltage:1,
                numOfAnalogOutputForCurrentLimit:2)
        }
        //END  latchXminus    (AUTOCHANGER)

        //BEGIN  latchXplus    (AUTOCHANGER)
        latchXplus(SftFilterLatchModule,
            filterSensorsDIOName:filterSensorsDIOName,
            lockSensor:ref("lockSensorLatchXplus"),
            unlockSensor:ref("unlockSensorLatchXplus"),
            filterPresenceSensor:ref("filterPresenceSensorLatchXplus"),
            latchActuator:ref("latchActuatorXplus")) {
            
            lockSensorLatchXplus ( DigitalSensor ,
                dioName:filterSensorsDIOName, inputNumero:5, byteNumero:1)

            unlockSensorLatchXplus ( DigitalSensor ,
                dioName:filterSensorsDIOName, inputNumero:6, byteNumero:1)

            filterPresenceSensorLatchXplus ( DigitalSensor ,
                dioName:filterSensorsDIOName, inputNumero:4, byteNumero:1)

            latchActuatorXplus (CanOpenLatchActuatorModule,
                currentLimitInVolt:0.150,
                speedVoltageInVolt:4,
                speedVoltageMinValue:-10,
                speedVoltageMaxValue:10,
                dacName:dacName,
                numOfAnalogOutputForSpeedVoltage:3,
                numOfAnalogOutputForCurrentLimit:4)
        }
        //END  LATCH   (AUTOCHANGER)

        //BEGIN  TRUCK   (AUTOCHANGER)
        truckXminus (  TruckModule ,
            railSensorStandback:ref("railSensorStandbackXminus"),
            railSensorStandby:ref("railSensorStandbyXminus")) {
            
            railSensorStandbackXminus (  DigitalSensor ,
                dioName:railsSensorsDIOName, inputNumero:4, byteNumero:1)
            
            railSensorStandbyXminus (  DigitalSensor ,
                dioName:railsSensorsDIOName, inputNumero:5, byteNumero:1)
        }
        
        truckXplus (  TruckModule ,
            railSensorStandback:ref("railSensorStandbackXplus"),
            railSensorStandby:ref("railSensorStandbyXplus")) {
                               
            railSensorStandbackXplus (  DigitalSensor ,
                dioName:railsSensorsDIOName, inputNumero:6, byteNumero:1)
            
            railSensorStandbyXplus (  DigitalSensor ,
                dioName:railsSensorsDIOName, inputNumero:7, byteNumero:1)
        }
    }//END AUTO CHANGER
}//end description of Main submodules

                


