/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups;

import java.util.Properties;
import org.jgroups.stack.GossipRouter;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.definition.Bus;

class BusGossipRouter
implements Runnable {
    private final GossipRouter router;
    private final int port;
    private final String routerHost = BusGossipRouter.getRouterProperties().getProperty("org.lsst.ccs.router.host", "");
    private final String busName;
    private static Properties routerProperties;

    BusGossipRouter(Bus bus) {
        if (this.routerHost.isEmpty()) {
            throw new RuntimeException("The Gossip Router Host must be provided via property \"org.lsst.ccs.router.host\"");
        }
        String routerPortStr = BusGossipRouter.getRouterProperties().getProperty("org.lsst.ccs.router.port", "12000");
        int routerPort = Integer.parseInt(routerPortStr);
        this.port = routerPort + bus.ordinal() * 10;
        this.router = new GossipRouter(this.port, this.routerHost);
        this.busName = bus.toString();
    }

    int getPort() {
        return this.port;
    }

    String getHost() {
        return this.routerHost;
    }

    @Override
    public void run() {
        try {
            System.out.println("\nStarting gossip router for " + this.busName + " bus on port " + this.port);
            this.router.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start Gossip Router ", e);
        }
    }

    boolean isStarted() {
        return this.router.isStarted();
    }

    static Properties getRouterProperties() {
        if (routerProperties == null) {
            routerProperties = BootstrapResourceUtils.getBootstrapProperties((String)"GossipRouter.properties");
        }
        return routerProperties;
    }
}

