/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class CompactIOModule
extends CanOpenDevice {
    public String hexaValue;
    private volatile boolean updatingValue = false;
    private final Lock lock = new ReentrantLock();
    private final Condition valueUpdated = this.lock.newCondition();

    public CompactIOModule(String nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.hexaValue = "00";
    }

    public String readNewHexaValue() {
        try {
            this.hexaValue = this.tcpProxy.readSDO(this.nodeID, "6000", "1");
        }
        catch (SDORequestException ex) {
            String mes = this.name + ": ERROR IN READING SENSOR:";
            this.raiseAlarm("FCS004:" + this.name, mes, ex);
        }
        catch (ShortResponseToSDORequestException ex) {
            String mes = this.name + ": GOT A STRANGE RESPONSE IN READING SENSOR:";
            FCSCst.FCSLOG.warning((Object)(mes + ex));
        }
        return this.hexaValue;
    }

    public String getHexaValue() {
        this.lock.lock();
        try {
            while (this.updatingValue) {
                try {
                    this.valueUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.getName() + ex.getMessage()));
                }
            }
            String string = this.hexaValue;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getValue() {
        FCSCst.FCSLOG.debug((Object)(this.getName() + Integer.parseInt(this.getHexaValue(), 16)));
        return Integer.parseInt(this.getHexaValue(), 16);
    }

    public void updateValue() {
        this.lock.lock();
        try {
            this.updatingValue = true;
            this.hexaValue = this.readNewHexaValue();
            FCSCst.FCSLOG.debug((Object)(this.getName() + " HEXA VALUE READ=" + this.hexaValue));
        }
        finally {
            this.updatingValue = false;
            this.valueUpdated.signal();
            this.lock.unlock();
        }
    }

    public String writeDigitalOutput(int outputNB, int value) {
        if (!this.tcpProxy.isCANDevicesReady()) {
            String message = String.format("DAC %s / nodeID=%s is NOT BOOTED", this.getName(), this.nodeID);
            FCSCst.FCSLOG.error((Object)message);
            throw new HardwareNotDetectedException("a CanOpenDIO is missing", this.getName(), this.nodeID, this.serialNB);
        }
        if (outputNB < 1 || outputNB > 8) {
            throw new IllegalArgumentException("CAN-CBX-DIO8 : input has to be 1..8");
        }
        String valueInHexa = Integer.toHexString(value);
        String inputNBInHexa = Integer.toHexString(outputNB);
        return this.tcpProxy.writeSDO(this.nodeID, "6200", inputNBInHexa, "2", valueInHexa);
    }

    public String writeMask() {
        return this.tcpProxy.writeSDO(this.nodeID, "2250", "1", "1", "3");
    }

    public boolean checkMask() {
        String maskValue = this.tcpProxy.readSDO(this.nodeID, "6000", "1");
        return maskValue.equals("3");
    }
}

