/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.drivers.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class SimuPlutoGateway
extends PlutoGatewayModule {
    public SimuPlutoGateway(String nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public void initModule() {
        super.initModule();
        for (int i = 0; i < this.hexaValues.length; ++i) {
            this.hexaValues[i] = "00";
        }
    }

    @Override
    public String[] readNewHexaValues() {
        return this.hexaValues;
    }

    @Override
    public String[] readHexaValuesFromPDO() {
        return this.hexaValues;
    }

    public void replaceHexaValues(DigitalSensor sensor, boolean on) {
        this.lock.lock();
        try {
            this.updatingValues = true;
            this.replaceSensorValue(sensor, on);
        }
        finally {
            this.updatingValues = false;
            this.valueUpdated.signal();
            this.lock.unlock();
        }
    }

    private void replaceSensorValue(DigitalSensor sensor, boolean on) {
        int byteNo = sensor.getByteNumero();
        String hexaValue = this.hexaValues[byteNo];
        FCSCst.FCSLOG.finest((Object)(this.getName() + "=> old hexa value = " + hexaValue));
        String newHexaValue = on ? FcsUtils.force2one(hexaValue, sensor.getInputNumero()) : FcsUtils.force2zero(hexaValue, sensor.getInputNumero());
        FCSCst.FCSLOG.finest((Object)(this.getName() + "=> new hexa value =" + newHexaValue));
        this.hexaValues[byteNo] = newHexaValue;
    }
}

