/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Observable;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenSensor14bits;

public class SimuCarouselClampLockSensor
extends SimuCanOpenSensor14bits {
    int acTrucksStandbyPosition = 992000;

    public SimuCarouselClampLockSensor(String adcName, int numOfAnalogInput) {
        super(adcName, numOfAnalogInput);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.simulateClampIsLOCKED();
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        FCSCst.FCSLOG.finest((Object)(this.getName() + " :old Value=" + this.printValue()));
        if (this.isAtStandby()) {
            FCSCst.FCSLOG.finest((Object)(this.getName() + " is AT STANDBY."));
        }
        if (this.getSubsystem().isInState((Enum)PhaseState.OPERATIONAL) && this.isAtStandby() && this.autochanger.isHoldingFilter()) {
            if ((Integer)v.getValue() < this.acTrucksStandbyPosition - 500) {
                this.simulateClampIsUNLOCKED();
            } else if ((Integer)v.getValue() == this.acTrucksStandbyPosition) {
                this.simulateClampIsLOCKED();
            }
        }
        FCSCst.FCSLOG.finest((Object)(this.getName() + " :new Value=" + this.printValue()));
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateClampIsLOCKED() {
        this.setNewRange(this.clamp.getLockSensorValueB(), this.clamp.getLockSensorValueC());
        this.updateFakePDOStorage();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateClampIsUNLOCKED() {
        this.setNewRange(0, this.clamp.getLockSensorValueA());
        this.updateFakePDOStorage();
    }
}

