/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenADC;

public class CanOpenSensor14bits
extends Sensor14bits {
    protected CanOpenADC adc;
    @ConfigurationParameter(isFinal=true, description="The name of the ADC where this sensor is plugged on.")
    private final String adcName;
    @ConfigurationParameter(range="1..25", description="The numero of the input of ADC where this sensor is plugged on.")
    protected int numOfAnalogInput;

    public CanOpenSensor14bits(String adcName, int numOfAnalogInput) {
        super(1000);
        this.adcName = adcName;
        this.numOfAnalogInput = numOfAnalogInput;
    }

    @Override
    public void initModule() {
        this.adc = (CanOpenADC)this.getComponentLookup().getComponentByName(this.adcName);
    }

    @Override
    public int readNewValue() {
        String valueInHexa = this.adc.readAnalogInput(this.numOfAnalogInput);
        this.value = Integer.parseInt(valueInHexa, 16);
        return this.value;
    }

    @Override
    public int updateValue(PDOStorage pdoStorage) {
        String hexaValue = pdoStorage.getVarValue(this.adc.nodeID, Integer.toString(this.numOfAnalogInput));
        this.value = Integer.parseInt(hexaValue, 16);
        return this.value;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/adcName=");
        sb.append(this.adcName);
        sb.append("/inputNumero=");
        sb.append(this.numOfAnalogInput);
        return sb.toString();
    }
}

